/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.Creator;
import com.datadog.api.v1.client.model.SLOCorrectionCategory;
import com.datadog.api.v1.client.model.SLOCorrectionResponseAttributesModifier;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="The attribute object associated with the SLO correction.")
@JsonPropertyOrder(value={"category", "created_at", "creator", "description", "duration", "end", "modified_at", "modifier", "rrule", "slo_id", "start", "timezone"})
public class SLOCorrectionResponseAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private SLOCorrectionCategory category;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private Long createdAt;
    public static final String JSON_PROPERTY_CREATOR = "creator";
    private Creator creator;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DURATION = "duration";
    private JsonNullable<Long> duration = JsonNullable.undefined();
    public static final String JSON_PROPERTY_END = "end";
    private Long end;
    public static final String JSON_PROPERTY_MODIFIED_AT = "modified_at";
    private Long modifiedAt;
    public static final String JSON_PROPERTY_MODIFIER = "modifier";
    private JsonNullable<SLOCorrectionResponseAttributesModifier> modifier = JsonNullable.undefined();
    public static final String JSON_PROPERTY_RRULE = "rrule";
    private JsonNullable<String> rrule = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SLO_ID = "slo_id";
    private String sloId;
    public static final String JSON_PROPERTY_START = "start";
    private Long start;
    public static final String JSON_PROPERTY_TIMEZONE = "timezone";
    private String timezone;

    public SLOCorrectionResponseAttributes category(SLOCorrectionCategory category) {
        this.category = category;
        this.unparsed |= !category.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SLOCorrectionCategory getCategory() {
        return this.category;
    }

    public void setCategory(SLOCorrectionCategory category) {
        if (!category.isValid()) {
            this.unparsed = true;
        }
        this.category = category;
    }

    public SLOCorrectionResponseAttributes createdAt(Long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The epoch timestamp of when the correction was created at")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    public SLOCorrectionResponseAttributes creator(Creator creator) {
        this.creator = creator;
        this.unparsed |= creator.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Creator getCreator() {
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
    }

    public SLOCorrectionResponseAttributes description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Description of the correction being made.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SLOCorrectionResponseAttributes duration(Long duration) {
        this.duration = JsonNullable.of((Object)duration);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="3600", value="Length of time (in seconds) for a specified `rrule` recurring SLO correction.")
    @JsonIgnore
    public Long getDuration() {
        return (Long)this.duration.orElse(null);
    }

    @JsonProperty(value="duration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getDuration_JsonNullable() {
        return this.duration;
    }

    @JsonProperty(value="duration")
    public void setDuration_JsonNullable(JsonNullable<Long> duration) {
        this.duration = duration;
    }

    public void setDuration(Long duration) {
        this.duration = JsonNullable.of((Object)duration);
    }

    public SLOCorrectionResponseAttributes end(Long end) {
        this.end = end;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Ending time of the correction in epoch seconds.")
    @JsonProperty(value="end")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getEnd() {
        return this.end;
    }

    public void setEnd(Long end) {
        this.end = end;
    }

    public SLOCorrectionResponseAttributes modifiedAt(Long modifiedAt) {
        this.modifiedAt = modifiedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The epoch timestamp of when the correction was modified at")
    @JsonProperty(value="modified_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(Long modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public SLOCorrectionResponseAttributes modifier(SLOCorrectionResponseAttributesModifier modifier) {
        this.modifier = JsonNullable.of((Object)modifier);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public SLOCorrectionResponseAttributesModifier getModifier() {
        return (SLOCorrectionResponseAttributesModifier)this.modifier.orElse(null);
    }

    @JsonProperty(value="modifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<SLOCorrectionResponseAttributesModifier> getModifier_JsonNullable() {
        return this.modifier;
    }

    @JsonProperty(value="modifier")
    public void setModifier_JsonNullable(JsonNullable<SLOCorrectionResponseAttributesModifier> modifier) {
        this.modifier = modifier;
    }

    public void setModifier(SLOCorrectionResponseAttributesModifier modifier) {
        this.modifier = JsonNullable.of((Object)modifier);
    }

    public SLOCorrectionResponseAttributes rrule(String rrule) {
        this.rrule = JsonNullable.of((Object)rrule);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="FREQ=DAILY;INTERVAL=10;COUNT=5", value="The recurrence rules as defined in the iCalendar RFC 5545. The supported rules for SLO corrections are `FREQ`, `INTERVAL`, `COUNT` and `UNTIL`.")
    @JsonIgnore
    public String getRrule() {
        return (String)this.rrule.orElse(null);
    }

    @JsonProperty(value="rrule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getRrule_JsonNullable() {
        return this.rrule;
    }

    @JsonProperty(value="rrule")
    public void setRrule_JsonNullable(JsonNullable<String> rrule) {
        this.rrule = rrule;
    }

    public void setRrule(String rrule) {
        this.rrule = JsonNullable.of((Object)rrule);
    }

    public SLOCorrectionResponseAttributes sloId(String sloId) {
        this.sloId = sloId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the SLO that this correction will be applied to.")
    @JsonProperty(value="slo_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSloId() {
        return this.sloId;
    }

    public void setSloId(String sloId) {
        this.sloId = sloId;
    }

    public SLOCorrectionResponseAttributes start(Long start) {
        this.start = start;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Starting time of the correction in epoch seconds.")
    @JsonProperty(value="start")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getStart() {
        return this.start;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    public SLOCorrectionResponseAttributes timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The timezone to display in the UI for the correction times (defaults to \"UTC\").")
    @JsonProperty(value="timezone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOCorrectionResponseAttributes slOCorrectionResponseAttributes = (SLOCorrectionResponseAttributes)o;
        return Objects.equals(this.category, slOCorrectionResponseAttributes.category) && Objects.equals(this.createdAt, slOCorrectionResponseAttributes.createdAt) && Objects.equals(this.creator, slOCorrectionResponseAttributes.creator) && Objects.equals(this.description, slOCorrectionResponseAttributes.description) && Objects.equals(this.duration, slOCorrectionResponseAttributes.duration) && Objects.equals(this.end, slOCorrectionResponseAttributes.end) && Objects.equals(this.modifiedAt, slOCorrectionResponseAttributes.modifiedAt) && Objects.equals(this.modifier, slOCorrectionResponseAttributes.modifier) && Objects.equals(this.rrule, slOCorrectionResponseAttributes.rrule) && Objects.equals(this.sloId, slOCorrectionResponseAttributes.sloId) && Objects.equals(this.start, slOCorrectionResponseAttributes.start) && Objects.equals(this.timezone, slOCorrectionResponseAttributes.timezone);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.createdAt, this.creator, this.description, this.duration, this.end, this.modifiedAt, this.modifier, this.rrule, this.sloId, this.start, this.timezone);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOCorrectionResponseAttributes {\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    end: ").append(this.toIndentedString(this.end)).append("\n");
        sb.append("    modifiedAt: ").append(this.toIndentedString(this.modifiedAt)).append("\n");
        sb.append("    modifier: ").append(this.toIndentedString(this.modifier)).append("\n");
        sb.append("    rrule: ").append(this.toIndentedString(this.rrule)).append("\n");
        sb.append("    sloId: ").append(this.toIndentedString(this.sloId)).append("\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

