/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.LogsStringBuilderProcessorType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Use the string builder processor to add a new attribute (without spaces or special characters) to a log with the result of the provided template. This enables aggregation of different attributes or raw strings into a single attribute.  The template is defined by both raw text and blocks with the syntax `%{attribute_path}`.  **Notes**:  - The processor only accepts attributes with values or an array of values in the blocks. - If an attribute cannot be used (object or array of object),   it is replaced by an empty string or the entire operation is skipped depending on your selection. - If the target attribute already exists, it is overwritten by the result of the template. - Results of the template cannot exceed 256 characters.")
@JsonPropertyOrder(value={"is_enabled", "is_replace_missing", "name", "target", "template", "type"})
public class LogsStringBuilderProcessor {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled = false;
    public static final String JSON_PROPERTY_IS_REPLACE_MISSING = "is_replace_missing";
    private Boolean isReplaceMissing = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TARGET = "target";
    private String target;
    public static final String JSON_PROPERTY_TEMPLATE = "template";
    private String template;
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogsStringBuilderProcessorType type = LogsStringBuilderProcessorType.STRING_BUILDER_PROCESSOR;

    public LogsStringBuilderProcessor() {
    }

    @JsonCreator
    public LogsStringBuilderProcessor(@JsonProperty(required=true, value="target") String target, @JsonProperty(required=true, value="template") String template, @JsonProperty(required=true, value="type") LogsStringBuilderProcessorType type) {
        this.target = target;
        this.template = template;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public LogsStringBuilderProcessor isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the processor is enabled.")
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public LogsStringBuilderProcessor isReplaceMissing(Boolean isReplaceMissing) {
        this.isReplaceMissing = isReplaceMissing;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, it replaces all missing attributes of `template` by an empty string. If `false` (default), skips the operation for missing attributes.")
    @JsonProperty(value="is_replace_missing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsReplaceMissing() {
        return this.isReplaceMissing;
    }

    public void setIsReplaceMissing(Boolean isReplaceMissing) {
        this.isReplaceMissing = isReplaceMissing;
    }

    public LogsStringBuilderProcessor name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the processor.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsStringBuilderProcessor target(String target) {
        this.target = target;
        return this;
    }

    @ApiModelProperty(example="", required=true, value="The name of the attribute that contains the result of the template.")
    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public LogsStringBuilderProcessor template(String template) {
        this.template = template;
        return this;
    }

    @ApiModelProperty(example="", required=true, value="A formula with one or more attributes and raw text.")
    @JsonProperty(value="template")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public LogsStringBuilderProcessor type(LogsStringBuilderProcessorType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsStringBuilderProcessorType getType() {
        return this.type;
    }

    public void setType(LogsStringBuilderProcessorType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsStringBuilderProcessor logsStringBuilderProcessor = (LogsStringBuilderProcessor)o;
        return Objects.equals(this.isEnabled, logsStringBuilderProcessor.isEnabled) && Objects.equals(this.isReplaceMissing, logsStringBuilderProcessor.isReplaceMissing) && Objects.equals(this.name, logsStringBuilderProcessor.name) && Objects.equals(this.target, logsStringBuilderProcessor.target) && Objects.equals(this.template, logsStringBuilderProcessor.template) && Objects.equals(this.type, logsStringBuilderProcessor.type);
    }

    public int hashCode() {
        return Objects.hash(this.isEnabled, this.isReplaceMissing, this.name, this.target, this.template, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsStringBuilderProcessor {\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    isReplaceMissing: ").append(this.toIndentedString(this.isReplaceMissing)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

