/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.LogsRetentionSumUsage;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object containing a summary of indexed logs usage by retention period for a single month.")
@JsonPropertyOrder(value={"date", "usage"})
public class LogsByRetentionMonthlyUsage {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DATE = "date";
    private String date;
    public static final String JSON_PROPERTY_USAGE = "usage";
    private List<LogsRetentionSumUsage> usage = null;

    public LogsByRetentionMonthlyUsage date(String date) {
        this.date = date;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The month for the usage.")
    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public LogsByRetentionMonthlyUsage usage(List<LogsRetentionSumUsage> usage) {
        this.usage = usage;
        for (LogsRetentionSumUsage item : usage) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public LogsByRetentionMonthlyUsage addUsageItem(LogsRetentionSumUsage usageItem) {
        if (this.usage == null) {
            this.usage = new ArrayList<LogsRetentionSumUsage>();
        }
        this.usage.add(usageItem);
        this.unparsed |= usageItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indexed logs usage for each active retention for the month.")
    @JsonProperty(value="usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LogsRetentionSumUsage> getUsage() {
        return this.usage;
    }

    public void setUsage(List<LogsRetentionSumUsage> usage) {
        this.usage = usage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsByRetentionMonthlyUsage logsByRetentionMonthlyUsage = (LogsByRetentionMonthlyUsage)o;
        return Objects.equals(this.date, logsByRetentionMonthlyUsage.date) && Objects.equals(this.usage, logsByRetentionMonthlyUsage.usage);
    }

    public int hashCode() {
        return Objects.hash(this.date, this.usage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsByRetentionMonthlyUsage {\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    usage: ").append(this.toIndentedString(this.usage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

