/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.ImageWidgetDefinitionType;
import com.datadog.api.v1.client.model.WidgetHorizontalAlign;
import com.datadog.api.v1.client.model.WidgetImageSizing;
import com.datadog.api.v1.client.model.WidgetMargin;
import com.datadog.api.v1.client.model.WidgetVerticalAlign;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The image widget allows you to embed an image on your dashboard. An image can be a PNG, JPG, or animated GIF. Only available on FREE layout dashboards.")
@JsonPropertyOrder(value={"has_background", "has_border", "horizontal_align", "margin", "sizing", "type", "url", "url_dark_theme", "vertical_align"})
public class ImageWidgetDefinition {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_HAS_BACKGROUND = "has_background";
    private Boolean hasBackground = true;
    public static final String JSON_PROPERTY_HAS_BORDER = "has_border";
    private Boolean hasBorder = true;
    public static final String JSON_PROPERTY_HORIZONTAL_ALIGN = "horizontal_align";
    private WidgetHorizontalAlign horizontalAlign;
    public static final String JSON_PROPERTY_MARGIN = "margin";
    private WidgetMargin margin;
    public static final String JSON_PROPERTY_SIZING = "sizing";
    private WidgetImageSizing sizing;
    public static final String JSON_PROPERTY_TYPE = "type";
    private ImageWidgetDefinitionType type = ImageWidgetDefinitionType.IMAGE;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    public static final String JSON_PROPERTY_URL_DARK_THEME = "url_dark_theme";
    private String urlDarkTheme;
    public static final String JSON_PROPERTY_VERTICAL_ALIGN = "vertical_align";
    private WidgetVerticalAlign verticalAlign;

    public ImageWidgetDefinition() {
    }

    @JsonCreator
    public ImageWidgetDefinition(@JsonProperty(required=true, value="type") ImageWidgetDefinitionType type, @JsonProperty(required=true, value="url") String url) {
        this.type = type;
        this.unparsed |= !type.isValid();
        this.url = url;
    }

    public ImageWidgetDefinition hasBackground(Boolean hasBackground) {
        this.hasBackground = hasBackground;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether to display a background or not.")
    @JsonProperty(value="has_background")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasBackground() {
        return this.hasBackground;
    }

    public void setHasBackground(Boolean hasBackground) {
        this.hasBackground = hasBackground;
    }

    public ImageWidgetDefinition hasBorder(Boolean hasBorder) {
        this.hasBorder = hasBorder;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether to display a border or not.")
    @JsonProperty(value="has_border")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasBorder() {
        return this.hasBorder;
    }

    public void setHasBorder(Boolean hasBorder) {
        this.hasBorder = hasBorder;
    }

    public ImageWidgetDefinition horizontalAlign(WidgetHorizontalAlign horizontalAlign) {
        this.horizontalAlign = horizontalAlign;
        this.unparsed |= !horizontalAlign.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="horizontal_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetHorizontalAlign getHorizontalAlign() {
        return this.horizontalAlign;
    }

    public void setHorizontalAlign(WidgetHorizontalAlign horizontalAlign) {
        if (!horizontalAlign.isValid()) {
            this.unparsed = true;
        }
        this.horizontalAlign = horizontalAlign;
    }

    public ImageWidgetDefinition margin(WidgetMargin margin) {
        this.margin = margin;
        this.unparsed |= !margin.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="margin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetMargin getMargin() {
        return this.margin;
    }

    public void setMargin(WidgetMargin margin) {
        if (!margin.isValid()) {
            this.unparsed = true;
        }
        this.margin = margin;
    }

    public ImageWidgetDefinition sizing(WidgetImageSizing sizing) {
        this.sizing = sizing;
        this.unparsed |= !sizing.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="sizing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetImageSizing getSizing() {
        return this.sizing;
    }

    public void setSizing(WidgetImageSizing sizing) {
        if (!sizing.isValid()) {
            this.unparsed = true;
        }
        this.sizing = sizing;
    }

    public ImageWidgetDefinition type(ImageWidgetDefinitionType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ImageWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(ImageWidgetDefinitionType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public ImageWidgetDefinition url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="https://example.com/image.png", required=true, value="URL of the image.")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ImageWidgetDefinition urlDarkTheme(String urlDarkTheme) {
        this.urlDarkTheme = urlDarkTheme;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://example.com/image-dark-mode.png", value="URL of the image in dark mode.")
    @JsonProperty(value="url_dark_theme")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrlDarkTheme() {
        return this.urlDarkTheme;
    }

    public void setUrlDarkTheme(String urlDarkTheme) {
        this.urlDarkTheme = urlDarkTheme;
    }

    public ImageWidgetDefinition verticalAlign(WidgetVerticalAlign verticalAlign) {
        this.verticalAlign = verticalAlign;
        this.unparsed |= !verticalAlign.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="vertical_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetVerticalAlign getVerticalAlign() {
        return this.verticalAlign;
    }

    public void setVerticalAlign(WidgetVerticalAlign verticalAlign) {
        if (!verticalAlign.isValid()) {
            this.unparsed = true;
        }
        this.verticalAlign = verticalAlign;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageWidgetDefinition imageWidgetDefinition = (ImageWidgetDefinition)o;
        return Objects.equals(this.hasBackground, imageWidgetDefinition.hasBackground) && Objects.equals(this.hasBorder, imageWidgetDefinition.hasBorder) && Objects.equals(this.horizontalAlign, imageWidgetDefinition.horizontalAlign) && Objects.equals(this.margin, imageWidgetDefinition.margin) && Objects.equals(this.sizing, imageWidgetDefinition.sizing) && Objects.equals(this.type, imageWidgetDefinition.type) && Objects.equals(this.url, imageWidgetDefinition.url) && Objects.equals(this.urlDarkTheme, imageWidgetDefinition.urlDarkTheme) && Objects.equals(this.verticalAlign, imageWidgetDefinition.verticalAlign);
    }

    public int hashCode() {
        return Objects.hash(this.hasBackground, this.hasBorder, this.horizontalAlign, this.margin, this.sizing, this.type, this.url, this.urlDarkTheme, this.verticalAlign);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageWidgetDefinition {\n");
        sb.append("    hasBackground: ").append(this.toIndentedString(this.hasBackground)).append("\n");
        sb.append("    hasBorder: ").append(this.toIndentedString(this.hasBorder)).append("\n");
        sb.append("    horizontalAlign: ").append(this.toIndentedString(this.horizontalAlign)).append("\n");
        sb.append("    margin: ").append(this.toIndentedString(this.margin)).append("\n");
        sb.append("    sizing: ").append(this.toIndentedString(this.sizing)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    urlDarkTheme: ").append(this.toIndentedString(this.urlDarkTheme)).append("\n");
        sb.append("    verticalAlign: ").append(this.toIndentedString(this.verticalAlign)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

