/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=FormulaAndFunctionEventsDataSourceSerializer.class)
public class FormulaAndFunctionEventsDataSource {
    public static final FormulaAndFunctionEventsDataSource LOGS = new FormulaAndFunctionEventsDataSource("logs");
    public static final FormulaAndFunctionEventsDataSource SPANS = new FormulaAndFunctionEventsDataSource("spans");
    public static final FormulaAndFunctionEventsDataSource NETWORK = new FormulaAndFunctionEventsDataSource("network");
    public static final FormulaAndFunctionEventsDataSource RUM = new FormulaAndFunctionEventsDataSource("rum");
    public static final FormulaAndFunctionEventsDataSource SECURITY_SIGNALS = new FormulaAndFunctionEventsDataSource("security_signals");
    public static final FormulaAndFunctionEventsDataSource PROFILES = new FormulaAndFunctionEventsDataSource("profiles");
    public static final FormulaAndFunctionEventsDataSource AUDIT = new FormulaAndFunctionEventsDataSource("audit");
    public static final FormulaAndFunctionEventsDataSource EVENTS = new FormulaAndFunctionEventsDataSource("events");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("logs", "spans", "network", "rum", "security_signals", "profiles", "audit", "events"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    FormulaAndFunctionEventsDataSource(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((FormulaAndFunctionEventsDataSource)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static FormulaAndFunctionEventsDataSource fromValue(String value) {
        return new FormulaAndFunctionEventsDataSource(value);
    }

    public static class FormulaAndFunctionEventsDataSourceSerializer
    extends StdSerializer<FormulaAndFunctionEventsDataSource> {
        public FormulaAndFunctionEventsDataSourceSerializer(Class<FormulaAndFunctionEventsDataSource> t) {
            super(t);
        }

        public FormulaAndFunctionEventsDataSourceSerializer() {
            this(null);
        }

        public void serialize(FormulaAndFunctionEventsDataSource value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

