/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Datadog-Azure integrations configured for your organization.")
@JsonPropertyOrder(value={"automute", "client_id", "client_secret", "errors", "host_filters", "new_client_id", "new_tenant_name", "tenant_name"})
public class AzureAccount {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AUTOMUTE = "automute";
    private Boolean automute;
    public static final String JSON_PROPERTY_CLIENT_ID = "client_id";
    private String clientId;
    public static final String JSON_PROPERTY_CLIENT_SECRET = "client_secret";
    private String clientSecret;
    public static final String JSON_PROPERTY_ERRORS = "errors";
    private List<String> errors = null;
    public static final String JSON_PROPERTY_HOST_FILTERS = "host_filters";
    private String hostFilters;
    public static final String JSON_PROPERTY_NEW_CLIENT_ID = "new_client_id";
    private String newClientId;
    public static final String JSON_PROPERTY_NEW_TENANT_NAME = "new_tenant_name";
    private String newTenantName;
    public static final String JSON_PROPERTY_TENANT_NAME = "tenant_name";
    private String tenantName;

    public AzureAccount automute(Boolean automute) {
        this.automute = automute;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Silence monitors for expected Azure VM shutdowns.")
    @JsonProperty(value="automute")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAutomute() {
        return this.automute;
    }

    public void setAutomute(Boolean automute) {
        this.automute = automute;
    }

    public AzureAccount clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="testc7f6-1234-5678-9101-3fcbf464test", value="Your Azure web application ID.")
    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public AzureAccount clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="testingx./Sw*g/Y33t..R1cH+hScMDt", value="Your Azure web application secret key.")
    @JsonProperty(value="client_secret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public AzureAccount errors(List<String> errors) {
        this.errors = errors;
        return this;
    }

    public AzureAccount addErrorsItem(String errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"*\"]", value="Errors in your configuration.")
    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public AzureAccount hostFilters(String hostFilters) {
        this.hostFilters = hostFilters;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="key:value,filter:example", value="Limit the Azure instances that are pulled into Datadog by using tags. Only hosts that match one of the defined tags are imported into Datadog.")
    @JsonProperty(value="host_filters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHostFilters() {
        return this.hostFilters;
    }

    public void setHostFilters(String hostFilters) {
        this.hostFilters = hostFilters;
    }

    public AzureAccount newClientId(String newClientId) {
        this.newClientId = newClientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="new1c7f6-1234-5678-9101-3fcbf464test", value="Your New Azure web application ID.")
    @JsonProperty(value="new_client_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNewClientId() {
        return this.newClientId;
    }

    public void setNewClientId(String newClientId) {
        this.newClientId = newClientId;
    }

    public AzureAccount newTenantName(String newTenantName) {
        this.newTenantName = newTenantName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="new1c44-1234-5678-9101-cc00736ftest", value="Your New Azure Active Directory ID.")
    @JsonProperty(value="new_tenant_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNewTenantName() {
        return this.newTenantName;
    }

    public void setNewTenantName(String newTenantName) {
        this.newTenantName = newTenantName;
    }

    public AzureAccount tenantName(String tenantName) {
        this.tenantName = tenantName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="testc44-1234-5678-9101-cc00736ftest", value="Your Azure Active Directory ID.")
    @JsonProperty(value="tenant_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureAccount azureAccount = (AzureAccount)o;
        return Objects.equals(this.automute, azureAccount.automute) && Objects.equals(this.clientId, azureAccount.clientId) && Objects.equals(this.clientSecret, azureAccount.clientSecret) && Objects.equals(this.errors, azureAccount.errors) && Objects.equals(this.hostFilters, azureAccount.hostFilters) && Objects.equals(this.newClientId, azureAccount.newClientId) && Objects.equals(this.newTenantName, azureAccount.newTenantName) && Objects.equals(this.tenantName, azureAccount.tenantName);
    }

    public int hashCode() {
        return Objects.hash(this.automute, this.clientId, this.clientSecret, this.errors, this.hostFilters, this.newClientId, this.newTenantName, this.tenantName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AzureAccount {\n");
        sb.append("    automute: ").append(this.toIndentedString(this.automute)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    hostFilters: ").append(this.toIndentedString(this.hostFilters)).append("\n");
        sb.append("    newClientId: ").append(this.toIndentedString(this.newClientId)).append("\n");
        sb.append("    newTenantName: ").append(this.toIndentedString(this.newTenantName)).append("\n");
        sb.append("    tenantName: ").append(this.toIndentedString(this.tenantName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

