/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.WebhooksIntegration;
import com.datadog.api.v1.client.model.WebhooksIntegrationCustomVariable;
import com.datadog.api.v1.client.model.WebhooksIntegrationCustomVariableResponse;
import com.datadog.api.v1.client.model.WebhooksIntegrationCustomVariableUpdateRequest;
import com.datadog.api.v1.client.model.WebhooksIntegrationUpdateRequest;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class WebhooksIntegrationApi {
    private ApiClient apiClient;

    public WebhooksIntegrationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WebhooksIntegrationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public WebhooksIntegration createWebhooksIntegration(WebhooksIntegration body) throws ApiException {
        return this.createWebhooksIntegrationWithHttpInfo(body).getData();
    }

    public ApiResponse<WebhooksIntegration> createWebhooksIntegrationWithHttpInfo(WebhooksIntegration body) throws ApiException {
        WebhooksIntegration localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createWebhooksIntegration");
        }
        String localVarPath = "/api/v1/integration/webhooks/configuration/webhooks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createWebhooksIntegration");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<WebhooksIntegration> localVarReturnType = new GenericType<WebhooksIntegration>(){};
        return this.apiClient.invokeAPI("WebhooksIntegrationApi.createWebhooksIntegration", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public WebhooksIntegrationCustomVariableResponse createWebhooksIntegrationCustomVariable(WebhooksIntegrationCustomVariable body) throws ApiException {
        return this.createWebhooksIntegrationCustomVariableWithHttpInfo(body).getData();
    }

    public ApiResponse<WebhooksIntegrationCustomVariableResponse> createWebhooksIntegrationCustomVariableWithHttpInfo(WebhooksIntegrationCustomVariable body) throws ApiException {
        WebhooksIntegrationCustomVariable localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createWebhooksIntegrationCustomVariable");
        }
        String localVarPath = "/api/v1/integration/webhooks/configuration/custom-variables";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createWebhooksIntegrationCustomVariable");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<WebhooksIntegrationCustomVariableResponse> localVarReturnType = new GenericType<WebhooksIntegrationCustomVariableResponse>(){};
        return this.apiClient.invokeAPI("WebhooksIntegrationApi.createWebhooksIntegrationCustomVariable", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public void deleteWebhooksIntegration(String webhookName) throws ApiException {
        this.deleteWebhooksIntegrationWithHttpInfo(webhookName);
    }

    public ApiResponse<Void> deleteWebhooksIntegrationWithHttpInfo(String webhookName) throws ApiException {
        Object localVarPostBody = null;
        if (webhookName == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookName' when calling deleteWebhooksIntegration");
        }
        String localVarPath = "/api/v1/integration/webhooks/configuration/webhooks/{webhook_name}".replaceAll("\\{webhook_name\\}", this.apiClient.escapeString(webhookName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteWebhooksIntegration");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("WebhooksIntegrationApi.deleteWebhooksIntegration", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public void deleteWebhooksIntegrationCustomVariable(String customVariableName) throws ApiException {
        this.deleteWebhooksIntegrationCustomVariableWithHttpInfo(customVariableName);
    }

    public ApiResponse<Void> deleteWebhooksIntegrationCustomVariableWithHttpInfo(String customVariableName) throws ApiException {
        Object localVarPostBody = null;
        if (customVariableName == null) {
            throw new ApiException(400, "Missing the required parameter 'customVariableName' when calling deleteWebhooksIntegrationCustomVariable");
        }
        String localVarPath = "/api/v1/integration/webhooks/configuration/custom-variables/{custom_variable_name}".replaceAll("\\{custom_variable_name\\}", this.apiClient.escapeString(customVariableName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteWebhooksIntegrationCustomVariable");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("WebhooksIntegrationApi.deleteWebhooksIntegrationCustomVariable", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public WebhooksIntegration getWebhooksIntegration(String webhookName) throws ApiException {
        return this.getWebhooksIntegrationWithHttpInfo(webhookName).getData();
    }

    public ApiResponse<WebhooksIntegration> getWebhooksIntegrationWithHttpInfo(String webhookName) throws ApiException {
        Object localVarPostBody = null;
        if (webhookName == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookName' when calling getWebhooksIntegration");
        }
        String localVarPath = "/api/v1/integration/webhooks/configuration/webhooks/{webhook_name}".replaceAll("\\{webhook_name\\}", this.apiClient.escapeString(webhookName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getWebhooksIntegration");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<WebhooksIntegration> localVarReturnType = new GenericType<WebhooksIntegration>(){};
        return this.apiClient.invokeAPI("WebhooksIntegrationApi.getWebhooksIntegration", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public WebhooksIntegrationCustomVariableResponse getWebhooksIntegrationCustomVariable(String customVariableName) throws ApiException {
        return this.getWebhooksIntegrationCustomVariableWithHttpInfo(customVariableName).getData();
    }

    public ApiResponse<WebhooksIntegrationCustomVariableResponse> getWebhooksIntegrationCustomVariableWithHttpInfo(String customVariableName) throws ApiException {
        Object localVarPostBody = null;
        if (customVariableName == null) {
            throw new ApiException(400, "Missing the required parameter 'customVariableName' when calling getWebhooksIntegrationCustomVariable");
        }
        String localVarPath = "/api/v1/integration/webhooks/configuration/custom-variables/{custom_variable_name}".replaceAll("\\{custom_variable_name\\}", this.apiClient.escapeString(customVariableName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getWebhooksIntegrationCustomVariable");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<WebhooksIntegrationCustomVariableResponse> localVarReturnType = new GenericType<WebhooksIntegrationCustomVariableResponse>(){};
        return this.apiClient.invokeAPI("WebhooksIntegrationApi.getWebhooksIntegrationCustomVariable", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public WebhooksIntegration updateWebhooksIntegration(String webhookName, WebhooksIntegrationUpdateRequest body) throws ApiException {
        return this.updateWebhooksIntegrationWithHttpInfo(webhookName, body).getData();
    }

    public ApiResponse<WebhooksIntegration> updateWebhooksIntegrationWithHttpInfo(String webhookName, WebhooksIntegrationUpdateRequest body) throws ApiException {
        WebhooksIntegrationUpdateRequest localVarPostBody = body;
        if (webhookName == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookName' when calling updateWebhooksIntegration");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateWebhooksIntegration");
        }
        String localVarPath = "/api/v1/integration/webhooks/configuration/webhooks/{webhook_name}".replaceAll("\\{webhook_name\\}", this.apiClient.escapeString(webhookName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateWebhooksIntegration");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<WebhooksIntegration> localVarReturnType = new GenericType<WebhooksIntegration>(){};
        return this.apiClient.invokeAPI("WebhooksIntegrationApi.updateWebhooksIntegration", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public WebhooksIntegrationCustomVariableResponse updateWebhooksIntegrationCustomVariable(String customVariableName, WebhooksIntegrationCustomVariableUpdateRequest body) throws ApiException {
        return this.updateWebhooksIntegrationCustomVariableWithHttpInfo(customVariableName, body).getData();
    }

    public ApiResponse<WebhooksIntegrationCustomVariableResponse> updateWebhooksIntegrationCustomVariableWithHttpInfo(String customVariableName, WebhooksIntegrationCustomVariableUpdateRequest body) throws ApiException {
        WebhooksIntegrationCustomVariableUpdateRequest localVarPostBody = body;
        if (customVariableName == null) {
            throw new ApiException(400, "Missing the required parameter 'customVariableName' when calling updateWebhooksIntegrationCustomVariable");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateWebhooksIntegrationCustomVariable");
        }
        String localVarPath = "/api/v1/integration/webhooks/configuration/custom-variables/{custom_variable_name}".replaceAll("\\{custom_variable_name\\}", this.apiClient.escapeString(customVariableName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateWebhooksIntegrationCustomVariable");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<WebhooksIntegrationCustomVariableResponse> localVarReturnType = new GenericType<WebhooksIntegrationCustomVariableResponse>(){};
        return this.apiClient.invokeAPI("WebhooksIntegrationApi.updateWebhooksIntegrationCustomVariable", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }
}

