/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.IntakePayloadAccepted;
import com.datadog.api.v1.client.model.MetricContentEncoding;
import com.datadog.api.v1.client.model.MetricMetadata;
import com.datadog.api.v1.client.model.MetricSearchResponse;
import com.datadog.api.v1.client.model.MetricsListResponse;
import com.datadog.api.v1.client.model.MetricsPayload;
import com.datadog.api.v1.client.model.MetricsQueryResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class MetricsApi {
    private ApiClient apiClient;

    public MetricsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MetricsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public MetricMetadata getMetricMetadata(String metricName) throws ApiException {
        return this.getMetricMetadataWithHttpInfo(metricName).getData();
    }

    public ApiResponse<MetricMetadata> getMetricMetadataWithHttpInfo(String metricName) throws ApiException {
        Object localVarPostBody = null;
        if (metricName == null) {
            throw new ApiException(400, "Missing the required parameter 'metricName' when calling getMetricMetadata");
        }
        String localVarPath = "/api/v1/metrics/{metric_name}".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getMetricMetadata");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<MetricMetadata> localVarReturnType = new GenericType<MetricMetadata>(){};
        return this.apiClient.invokeAPI("MetricsApi.getMetricMetadata", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public MetricsListResponse listActiveMetrics(Long from) throws ApiException {
        return this.listActiveMetricsWithHttpInfo(from, new ListActiveMetricsOptionalParameters()).getData();
    }

    public MetricsListResponse listActiveMetrics(Long from, ListActiveMetricsOptionalParameters parameters) throws ApiException {
        return this.listActiveMetricsWithHttpInfo(from, parameters).getData();
    }

    public ApiResponse<MetricsListResponse> listActiveMetricsWithHttpInfo(Long from, ListActiveMetricsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (from == null) {
            throw new ApiException(400, "Missing the required parameter 'from' when calling listActiveMetrics");
        }
        String host = parameters.host;
        String tagFilter = parameters.tagFilter;
        String localVarPath = "/api/v1/metrics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from", from));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "host", host));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tag_filter", tagFilter));
        localVarHeaderParams.put("DD-OPERATION-ID", "listActiveMetrics");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<MetricsListResponse> localVarReturnType = new GenericType<MetricsListResponse>(){};
        return this.apiClient.invokeAPI("MetricsApi.listActiveMetrics", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public MetricSearchResponse listMetrics(String q) throws ApiException {
        return this.listMetricsWithHttpInfo(q).getData();
    }

    public ApiResponse<MetricSearchResponse> listMetricsWithHttpInfo(String q) throws ApiException {
        Object localVarPostBody = null;
        if (q == null) {
            throw new ApiException(400, "Missing the required parameter 'q' when calling listMetrics");
        }
        String localVarPath = "/api/v1/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "q", q));
        localVarHeaderParams.put("DD-OPERATION-ID", "listMetrics");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<MetricSearchResponse> localVarReturnType = new GenericType<MetricSearchResponse>(){};
        return this.apiClient.invokeAPI("MetricsApi.listMetrics", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public MetricsQueryResponse queryMetrics(Long from, Long to, String query) throws ApiException {
        return this.queryMetricsWithHttpInfo(from, to, query).getData();
    }

    public ApiResponse<MetricsQueryResponse> queryMetricsWithHttpInfo(Long from, Long to, String query) throws ApiException {
        Object localVarPostBody = null;
        if (from == null) {
            throw new ApiException(400, "Missing the required parameter 'from' when calling queryMetrics");
        }
        if (to == null) {
            throw new ApiException(400, "Missing the required parameter 'to' when calling queryMetrics");
        }
        if (query == null) {
            throw new ApiException(400, "Missing the required parameter 'query' when calling queryMetrics");
        }
        String localVarPath = "/api/v1/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from", from));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to", to));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarHeaderParams.put("DD-OPERATION-ID", "queryMetrics");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<MetricsQueryResponse> localVarReturnType = new GenericType<MetricsQueryResponse>(){};
        return this.apiClient.invokeAPI("MetricsApi.queryMetrics", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public IntakePayloadAccepted submitMetrics(MetricsPayload body) throws ApiException {
        return this.submitMetricsWithHttpInfo(body, new SubmitMetricsOptionalParameters()).getData();
    }

    public IntakePayloadAccepted submitMetrics(MetricsPayload body, SubmitMetricsOptionalParameters parameters) throws ApiException {
        return this.submitMetricsWithHttpInfo(body, parameters).getData();
    }

    public ApiResponse<IntakePayloadAccepted> submitMetricsWithHttpInfo(MetricsPayload body, SubmitMetricsOptionalParameters parameters) throws ApiException {
        MetricsPayload localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling submitMetrics");
        }
        MetricContentEncoding contentEncoding = parameters.contentEncoding;
        String localVarPath = "/api/v1/series";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "submitMetrics");
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.apiClient.parameterToString(contentEncoding));
        }
        String[] localVarAccepts = new String[]{"text/json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"text/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth"};
        GenericType<IntakePayloadAccepted> localVarReturnType = new GenericType<IntakePayloadAccepted>(){};
        return this.apiClient.invokeAPI("MetricsApi.submitMetrics", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public MetricMetadata updateMetricMetadata(String metricName, MetricMetadata body) throws ApiException {
        return this.updateMetricMetadataWithHttpInfo(metricName, body).getData();
    }

    public ApiResponse<MetricMetadata> updateMetricMetadataWithHttpInfo(String metricName, MetricMetadata body) throws ApiException {
        MetricMetadata localVarPostBody = body;
        if (metricName == null) {
            throw new ApiException(400, "Missing the required parameter 'metricName' when calling updateMetricMetadata");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateMetricMetadata");
        }
        String localVarPath = "/api/v1/metrics/{metric_name}".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateMetricMetadata");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<MetricMetadata> localVarReturnType = new GenericType<MetricMetadata>(){};
        return this.apiClient.invokeAPI("MetricsApi.updateMetricMetadata", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public static class SubmitMetricsOptionalParameters {
        private MetricContentEncoding contentEncoding;

        public SubmitMetricsOptionalParameters contentEncoding(MetricContentEncoding contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }
    }

    public static class ListActiveMetricsOptionalParameters {
        private String host;
        private String tagFilter;

        public ListActiveMetricsOptionalParameters host(String host) {
            this.host = host;
            return this;
        }

        public ListActiveMetricsOptionalParameters tagFilter(String tagFilter) {
            this.tagFilter = tagFilter;
            return this;
        }
    }
}

