/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The Agent rule.")
@JsonPropertyOrder(value={"agentRuleId", "expression"})
public class SecurityMonitoringRuntimeAgentRule {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGENT_RULE_ID = "agentRuleId";
    private String agentRuleId;
    public static final String JSON_PROPERTY_EXPRESSION = "expression";
    private String expression;

    public SecurityMonitoringRuntimeAgentRule agentRuleId(String agentRuleId) {
        this.agentRuleId = agentRuleId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="etc_shadow", value="The Agent rule ID. Must be unique within the rule.")
    @JsonProperty(value="agentRuleId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAgentRuleId() {
        return this.agentRuleId;
    }

    public void setAgentRuleId(String agentRuleId) {
        this.agentRuleId = agentRuleId;
    }

    public SecurityMonitoringRuntimeAgentRule expression(String expression) {
        this.expression = expression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A Runtime Security expression determines what activity should be collected by the Datadog Agent. These logical expressions can use predefined operators and attributes. Tags cannot be used in Runtime Security expressions. Instead, allow or deny based on tags under the advanced option.")
    @JsonProperty(value="expression")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityMonitoringRuntimeAgentRule securityMonitoringRuntimeAgentRule = (SecurityMonitoringRuntimeAgentRule)o;
        return Objects.equals(this.agentRuleId, securityMonitoringRuntimeAgentRule.agentRuleId) && Objects.equals(this.expression, securityMonitoringRuntimeAgentRule.expression);
    }

    public int hashCode() {
        return Objects.hash(this.agentRuleId, this.expression);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityMonitoringRuntimeAgentRule {\n");
        sb.append("    agentRuleId: ").append(this.toIndentedString(this.agentRuleId)).append("\n");
        sb.append("    expression: ").append(this.toIndentedString(this.expression)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

