/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.NotebookMetadataType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Metadata associated with the notebook.")
@JsonPropertyOrder(value={"is_template", "take_snapshots", "type"})
public class NotebookMetadata {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_IS_TEMPLATE = "is_template";
    private Boolean isTemplate = false;
    public static final String JSON_PROPERTY_TAKE_SNAPSHOTS = "take_snapshots";
    private Boolean takeSnapshots = false;
    public static final String JSON_PROPERTY_TYPE = "type";
    private JsonNullable<NotebookMetadataType> type = JsonNullable.of(null);

    public NotebookMetadata isTemplate(Boolean isTemplate) {
        this.isTemplate = isTemplate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Whether or not the notebook is a template.")
    @JsonProperty(value="is_template")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsTemplate() {
        return this.isTemplate;
    }

    public void setIsTemplate(Boolean isTemplate) {
        this.isTemplate = isTemplate;
    }

    public NotebookMetadata takeSnapshots(Boolean takeSnapshots) {
        this.takeSnapshots = takeSnapshots;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Whether or not the notebook takes snapshot image backups of the notebook's fixed-time graphs.")
    @JsonProperty(value="take_snapshots")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getTakeSnapshots() {
        return this.takeSnapshots;
    }

    public void setTakeSnapshots(Boolean takeSnapshots) {
        this.takeSnapshots = takeSnapshots;
    }

    public NotebookMetadata type(NotebookMetadataType type) {
        this.type = JsonNullable.of((Object)type);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public NotebookMetadataType getType() {
        return (NotebookMetadataType)this.type.orElse(null);
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<NotebookMetadataType> getType_JsonNullable() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType_JsonNullable(JsonNullable<NotebookMetadataType> type) {
        this.type = type;
    }

    public void setType(NotebookMetadataType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = JsonNullable.of((Object)type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotebookMetadata notebookMetadata = (NotebookMetadata)o;
        return Objects.equals(this.isTemplate, notebookMetadata.isTemplate) && Objects.equals(this.takeSnapshots, notebookMetadata.takeSnapshots) && Objects.equals(this.type, notebookMetadata.type);
    }

    public int hashCode() {
        return Objects.hash(this.isTemplate, this.takeSnapshots, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotebookMetadata {\n");
        sb.append("    isTemplate: ").append(this.toIndentedString(this.isTemplate)).append("\n");
        sb.append("    takeSnapshots: ").append(this.toIndentedString(this.takeSnapshots)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

