/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The paging attributes for listing security signals.")
@JsonPropertyOrder(value={"cursor", "limit"})
public class SecurityMonitoringSignalListRequestPage {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CURSOR = "cursor";
    private String cursor;
    public static final String JSON_PROPERTY_LIMIT = "limit";
    private Integer limit = 10;

    public SecurityMonitoringSignalListRequestPage cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="eyJzdGFydEF0IjoiQVFBQUFYS2tMS3pPbm40NGV3QUFBQUJCV0V0clRFdDZVbG8zY3pCRmNsbHJiVmxDWlEifQ==", value="A list of results using the cursor provided in the previous query.")
    @JsonProperty(value="cursor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public SecurityMonitoringSignalListRequestPage limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="25", value="The maximum number of security signals in the response.")
    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityMonitoringSignalListRequestPage securityMonitoringSignalListRequestPage = (SecurityMonitoringSignalListRequestPage)o;
        return Objects.equals(this.cursor, securityMonitoringSignalListRequestPage.cursor) && Objects.equals(this.limit, securityMonitoringSignalListRequestPage.limit);
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.limit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityMonitoringSignalListRequestPage {\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

