/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.LogsMetricCompute;
import com.datadog.api.v2.client.model.LogsMetricFilter;
import com.datadog.api.v2.client.model.LogsMetricGroupBy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The object describing the Datadog log-based metric to create.")
@JsonPropertyOrder(value={"compute", "filter", "group_by"})
public class LogsMetricCreateAttributes {
    public static final String JSON_PROPERTY_COMPUTE = "compute";
    private LogsMetricCompute compute;
    public static final String JSON_PROPERTY_FILTER = "filter";
    private LogsMetricFilter filter;
    public static final String JSON_PROPERTY_GROUP_BY = "group_by";
    private List<LogsMetricGroupBy> groupBy = null;

    public LogsMetricCreateAttributes() {
    }

    @JsonCreator
    public LogsMetricCreateAttributes(@JsonProperty(required=true, value="compute") LogsMetricCompute compute) {
        this.compute = compute;
    }

    public LogsMetricCreateAttributes compute(LogsMetricCompute compute) {
        this.compute = compute;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="compute")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsMetricCompute getCompute() {
        return this.compute;
    }

    public void setCompute(LogsMetricCompute compute) {
        this.compute = compute;
    }

    public LogsMetricCreateAttributes filter(LogsMetricFilter filter) {
        this.filter = filter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsMetricFilter getFilter() {
        return this.filter;
    }

    public void setFilter(LogsMetricFilter filter) {
        this.filter = filter;
    }

    public LogsMetricCreateAttributes groupBy(List<LogsMetricGroupBy> groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    public LogsMetricCreateAttributes addGroupByItem(LogsMetricGroupBy groupByItem) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<LogsMetricGroupBy>();
        }
        this.groupBy.add(groupByItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The rules for the group by.")
    @JsonProperty(value="group_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LogsMetricGroupBy> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(List<LogsMetricGroupBy> groupBy) {
        this.groupBy = groupBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsMetricCreateAttributes logsMetricCreateAttributes = (LogsMetricCreateAttributes)o;
        return Objects.equals(this.compute, logsMetricCreateAttributes.compute) && Objects.equals(this.filter, logsMetricCreateAttributes.filter) && Objects.equals(this.groupBy, logsMetricCreateAttributes.groupBy);
    }

    public int hashCode() {
        return Objects.hash(this.compute, this.filter, this.groupBy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsMetricCreateAttributes {\n");
        sb.append("    compute: ").append(this.toIndentedString(this.compute)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    groupBy: ").append(this.toIndentedString(this.groupBy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

