/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.Creator;
import com.datadog.api.v2.client.model.DashboardType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A dashboard within a list.")
@JsonPropertyOrder(value={"author", "created", "icon", "id", "is_favorite", "is_read_only", "is_shared", "modified", "popularity", "title", "type", "url"})
public class DashboardListItem {
    public static final String JSON_PROPERTY_AUTHOR = "author";
    private Creator author;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_ICON = "icon";
    private String icon;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_IS_FAVORITE = "is_favorite";
    private Boolean isFavorite;
    public static final String JSON_PROPERTY_IS_READ_ONLY = "is_read_only";
    private Boolean isReadOnly;
    public static final String JSON_PROPERTY_IS_SHARED = "is_shared";
    private Boolean isShared;
    public static final String JSON_PROPERTY_MODIFIED = "modified";
    private OffsetDateTime modified;
    public static final String JSON_PROPERTY_POPULARITY = "popularity";
    private Integer popularity;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TYPE = "type";
    private DashboardType type;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;

    public DashboardListItem() {
    }

    @JsonCreator
    public DashboardListItem(@JsonProperty(required=true, value="id") String id, @JsonProperty(required=true, value="type") DashboardType type) {
        this.id = id;
        this.type = type;
    }

    public DashboardListItem author(Creator author) {
        this.author = author;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="author")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Creator getAuthor() {
        return this.author;
    }

    public void setAuthor(Creator author) {
        this.author = author;
    }

    @Nullable
    @ApiModelProperty(value="Date of creation of the dashboard.")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @Nullable
    @ApiModelProperty(value="URL to the icon of the dashboard.")
    @JsonProperty(value="icon")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIcon() {
        return this.icon;
    }

    public DashboardListItem id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="q5j-nti-fv6", required=true, value="ID of the dashboard.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the dashboard is in the favorites.")
    @JsonProperty(value="is_favorite")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsFavorite() {
        return this.isFavorite;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the dashboard is read only.")
    @JsonProperty(value="is_read_only")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsReadOnly() {
        return this.isReadOnly;
    }

    @Nullable
    @ApiModelProperty(value="Whether the dashboard is publicly shared or not.")
    @JsonProperty(value="is_shared")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsShared() {
        return this.isShared;
    }

    @Nullable
    @ApiModelProperty(value="Date of last edition of the dashboard.")
    @JsonProperty(value="modified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getModified() {
        return this.modified;
    }

    @Nullable
    @ApiModelProperty(value="Popularity of the dashboard.")
    @JsonProperty(value="popularity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPopularity() {
        return this.popularity;
    }

    @Nullable
    @ApiModelProperty(value="Title of the dashboard.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public DashboardListItem type(DashboardType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DashboardType getType() {
        return this.type;
    }

    public void setType(DashboardType type) {
        this.type = type;
    }

    @Nullable
    @ApiModelProperty(value="URL path to the dashboard.")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashboardListItem dashboardListItem = (DashboardListItem)o;
        return Objects.equals(this.author, dashboardListItem.author) && Objects.equals(this.created, dashboardListItem.created) && Objects.equals(this.icon, dashboardListItem.icon) && Objects.equals(this.id, dashboardListItem.id) && Objects.equals(this.isFavorite, dashboardListItem.isFavorite) && Objects.equals(this.isReadOnly, dashboardListItem.isReadOnly) && Objects.equals(this.isShared, dashboardListItem.isShared) && Objects.equals(this.modified, dashboardListItem.modified) && Objects.equals(this.popularity, dashboardListItem.popularity) && Objects.equals(this.title, dashboardListItem.title) && Objects.equals((Object)this.type, (Object)dashboardListItem.type) && Objects.equals(this.url, dashboardListItem.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.author, this.created, this.icon, this.id, this.isFavorite, this.isReadOnly, this.isShared, this.modified, this.popularity, this.title, this.type, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DashboardListItem {\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    icon: ").append(this.toIndentedString(this.icon)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isFavorite: ").append(this.toIndentedString(this.isFavorite)).append("\n");
        sb.append("    isReadOnly: ").append(this.toIndentedString(this.isReadOnly)).append("\n");
        sb.append("    isShared: ").append(this.toIndentedString(this.isShared)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    popularity: ").append(this.toIndentedString(this.popularity)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

