/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.UsageBillableSummaryKeys;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Response with monthly summary of data billed by Datadog.")
@JsonPropertyOrder(value={"billing_plan", "end_date", "num_orgs", "org_name", "public_id", "ratio_in_month", "start_date", "usage"})
public class UsageBillableSummaryHour {
    public static final String JSON_PROPERTY_BILLING_PLAN = "billing_plan";
    private String billingPlan;
    public static final String JSON_PROPERTY_END_DATE = "end_date";
    private OffsetDateTime endDate;
    public static final String JSON_PROPERTY_NUM_ORGS = "num_orgs";
    private Long numOrgs;
    public static final String JSON_PROPERTY_ORG_NAME = "org_name";
    private String orgName;
    public static final String JSON_PROPERTY_PUBLIC_ID = "public_id";
    private String publicId;
    public static final String JSON_PROPERTY_RATIO_IN_MONTH = "ratio_in_month";
    private Long ratioInMonth;
    public static final String JSON_PROPERTY_START_DATE = "start_date";
    private OffsetDateTime startDate;
    public static final String JSON_PROPERTY_USAGE = "usage";
    private UsageBillableSummaryKeys usage;

    public UsageBillableSummaryHour billingPlan(String billingPlan) {
        this.billingPlan = billingPlan;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The billing plan.")
    @JsonProperty(value="billing_plan")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBillingPlan() {
        return this.billingPlan;
    }

    public void setBillingPlan(String billingPlan) {
        this.billingPlan = billingPlan;
    }

    public UsageBillableSummaryHour endDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the last date of usage.")
    @JsonProperty(value="end_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public UsageBillableSummaryHour numOrgs(Long numOrgs) {
        this.numOrgs = numOrgs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of organizations.")
    @JsonProperty(value="num_orgs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getNumOrgs() {
        return this.numOrgs;
    }

    public void setNumOrgs(Long numOrgs) {
        this.numOrgs = numOrgs;
    }

    public UsageBillableSummaryHour orgName(String orgName) {
        this.orgName = orgName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The organization name.")
    @JsonProperty(value="org_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public UsageBillableSummaryHour publicId(String publicId) {
        this.publicId = publicId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The organization public ID.")
    @JsonProperty(value="public_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public UsageBillableSummaryHour ratioInMonth(Long ratioInMonth) {
        this.ratioInMonth = ratioInMonth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows usage aggregation for a billing period.")
    @JsonProperty(value="ratio_in_month")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getRatioInMonth() {
        return this.ratioInMonth;
    }

    public void setRatioInMonth(Long ratioInMonth) {
        this.ratioInMonth = ratioInMonth;
    }

    public UsageBillableSummaryHour startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the first date of usage.")
    @JsonProperty(value="start_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public UsageBillableSummaryHour usage(UsageBillableSummaryKeys usage) {
        this.usage = usage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UsageBillableSummaryKeys getUsage() {
        return this.usage;
    }

    public void setUsage(UsageBillableSummaryKeys usage) {
        this.usage = usage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageBillableSummaryHour usageBillableSummaryHour = (UsageBillableSummaryHour)o;
        return Objects.equals(this.billingPlan, usageBillableSummaryHour.billingPlan) && Objects.equals(this.endDate, usageBillableSummaryHour.endDate) && Objects.equals(this.numOrgs, usageBillableSummaryHour.numOrgs) && Objects.equals(this.orgName, usageBillableSummaryHour.orgName) && Objects.equals(this.publicId, usageBillableSummaryHour.publicId) && Objects.equals(this.ratioInMonth, usageBillableSummaryHour.ratioInMonth) && Objects.equals(this.startDate, usageBillableSummaryHour.startDate) && Objects.equals(this.usage, usageBillableSummaryHour.usage);
    }

    public int hashCode() {
        return Objects.hash(this.billingPlan, this.endDate, this.numOrgs, this.orgName, this.publicId, this.ratioInMonth, this.startDate, this.usage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageBillableSummaryHour {\n");
        sb.append("    billingPlan: ").append(this.toIndentedString(this.billingPlan)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    numOrgs: ").append(this.toIndentedString(this.numOrgs)).append("\n");
        sb.append("    orgName: ").append(this.toIndentedString(this.orgName)).append("\n");
        sb.append("    publicId: ").append(this.toIndentedString(this.publicId)).append("\n");
        sb.append("    ratioInMonth: ").append(this.toIndentedString(this.ratioInMonth)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    usage: ").append(this.toIndentedString(this.usage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

