/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.LogsArchiveDestination;
import com.datadog.api.v2.client.model.LogsArchiveState;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The attributes associated with the archive.")
@JsonPropertyOrder(value={"destination", "include_tags", "name", "query", "rehydration_tags", "state"})
public class LogsArchiveAttributes {
    public static final String JSON_PROPERTY_DESTINATION = "destination";
    private LogsArchiveDestination destination;
    public static final String JSON_PROPERTY_INCLUDE_TAGS = "include_tags";
    private Boolean includeTags = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    public static final String JSON_PROPERTY_REHYDRATION_TAGS = "rehydration_tags";
    private List<String> rehydrationTags = null;
    public static final String JSON_PROPERTY_STATE = "state";
    private LogsArchiveState state;

    public LogsArchiveAttributes() {
    }

    @JsonCreator
    public LogsArchiveAttributes(@JsonProperty(required=true, value="destination") LogsArchiveDestination destination, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="query") String query) {
        this.destination = destination;
        this.name = name;
        this.query = query;
    }

    public LogsArchiveAttributes destination(LogsArchiveDestination destination) {
        this.destination = destination;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsArchiveDestination getDestination() {
        return this.destination;
    }

    public void setDestination(LogsArchiveDestination destination) {
        this.destination = destination;
    }

    public LogsArchiveAttributes includeTags(Boolean includeTags) {
        this.includeTags = includeTags;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="To store the tags in the archive, set the value \"true\". If it is set to \"false\", the tags will be deleted when the logs are sent to the archive.")
    @JsonProperty(value="include_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeTags() {
        return this.includeTags;
    }

    public void setIncludeTags(Boolean includeTags) {
        this.includeTags = includeTags;
    }

    public LogsArchiveAttributes name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Nginx Archive", required=true, value="The archive name.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsArchiveAttributes query(String query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(example="source:nginx", required=true, value="The archive query/filter. Logs matching this query are included in the archive.")
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public LogsArchiveAttributes rehydrationTags(List<String> rehydrationTags) {
        this.rehydrationTags = rehydrationTags;
        return this;
    }

    public LogsArchiveAttributes addRehydrationTagsItem(String rehydrationTagsItem) {
        if (this.rehydrationTags == null) {
            this.rehydrationTags = new ArrayList<String>();
        }
        this.rehydrationTags.add(rehydrationTagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"team:intake\",\"team:app\"]", value="An array of tags to add to rehydrated logs from an archive.")
    @JsonProperty(value="rehydration_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRehydrationTags() {
        return this.rehydrationTags;
    }

    public void setRehydrationTags(List<String> rehydrationTags) {
        this.rehydrationTags = rehydrationTags;
    }

    public LogsArchiveAttributes state(LogsArchiveState state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsArchiveState getState() {
        return this.state;
    }

    public void setState(LogsArchiveState state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsArchiveAttributes logsArchiveAttributes = (LogsArchiveAttributes)o;
        return Objects.equals(this.destination, logsArchiveAttributes.destination) && Objects.equals(this.includeTags, logsArchiveAttributes.includeTags) && Objects.equals(this.name, logsArchiveAttributes.name) && Objects.equals(this.query, logsArchiveAttributes.query) && Objects.equals(this.rehydrationTags, logsArchiveAttributes.rehydrationTags) && Objects.equals((Object)this.state, (Object)logsArchiveAttributes.state);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.destination, this.includeTags, this.name, this.query, this.rehydrationTags, this.state});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsArchiveAttributes {\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    includeTags: ").append(this.toIndentedString(this.includeTags)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    rehydrationTags: ").append(this.toIndentedString(this.rehydrationTags)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

