/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.DashboardListAddItemsRequest;
import com.datadog.api.v2.client.model.DashboardListAddItemsResponse;
import com.datadog.api.v2.client.model.DashboardListDeleteItemsRequest;
import com.datadog.api.v2.client.model.DashboardListDeleteItemsResponse;
import com.datadog.api.v2.client.model.DashboardListItems;
import com.datadog.api.v2.client.model.DashboardListUpdateItemsRequest;
import com.datadog.api.v2.client.model.DashboardListUpdateItemsResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class DashboardListsApi {
    private ApiClient apiClient;

    public DashboardListsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DashboardListsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public DashboardListAddItemsResponse createDashboardListItems(Long dashboardListId, DashboardListAddItemsRequest body) throws ApiException {
        return this.createDashboardListItemsWithHttpInfo(dashboardListId, body).getData();
    }

    public ApiResponse<DashboardListAddItemsResponse> createDashboardListItemsWithHttpInfo(Long dashboardListId, DashboardListAddItemsRequest body) throws ApiException {
        DashboardListAddItemsRequest localVarPostBody = body;
        if (dashboardListId == null) {
            throw new ApiException(400, "Missing the required parameter 'dashboardListId' when calling createDashboardListItems");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDashboardListItems");
        }
        String localVarPath = "/api/v2/dashboard/lists/manual/{dashboard_list_id}/dashboards".replaceAll("\\{dashboard_list_id\\}", this.apiClient.escapeString(dashboardListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createDashboardListItems");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<DashboardListAddItemsResponse> localVarReturnType = new GenericType<DashboardListAddItemsResponse>(){};
        return this.apiClient.invokeAPI("DashboardListsApi.createDashboardListItems", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public DashboardListDeleteItemsResponse deleteDashboardListItems(Long dashboardListId, DashboardListDeleteItemsRequest body) throws ApiException {
        return this.deleteDashboardListItemsWithHttpInfo(dashboardListId, body).getData();
    }

    public ApiResponse<DashboardListDeleteItemsResponse> deleteDashboardListItemsWithHttpInfo(Long dashboardListId, DashboardListDeleteItemsRequest body) throws ApiException {
        DashboardListDeleteItemsRequest localVarPostBody = body;
        if (dashboardListId == null) {
            throw new ApiException(400, "Missing the required parameter 'dashboardListId' when calling deleteDashboardListItems");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteDashboardListItems");
        }
        String localVarPath = "/api/v2/dashboard/lists/manual/{dashboard_list_id}/dashboards".replaceAll("\\{dashboard_list_id\\}", this.apiClient.escapeString(dashboardListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteDashboardListItems");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<DashboardListDeleteItemsResponse> localVarReturnType = new GenericType<DashboardListDeleteItemsResponse>(){};
        return this.apiClient.invokeAPI("DashboardListsApi.deleteDashboardListItems", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public DashboardListItems getDashboardListItems(Long dashboardListId) throws ApiException {
        return this.getDashboardListItemsWithHttpInfo(dashboardListId).getData();
    }

    public ApiResponse<DashboardListItems> getDashboardListItemsWithHttpInfo(Long dashboardListId) throws ApiException {
        Object localVarPostBody = null;
        if (dashboardListId == null) {
            throw new ApiException(400, "Missing the required parameter 'dashboardListId' when calling getDashboardListItems");
        }
        String localVarPath = "/api/v2/dashboard/lists/manual/{dashboard_list_id}/dashboards".replaceAll("\\{dashboard_list_id\\}", this.apiClient.escapeString(dashboardListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getDashboardListItems");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<DashboardListItems> localVarReturnType = new GenericType<DashboardListItems>(){};
        return this.apiClient.invokeAPI("DashboardListsApi.getDashboardListItems", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public DashboardListUpdateItemsResponse updateDashboardListItems(Long dashboardListId, DashboardListUpdateItemsRequest body) throws ApiException {
        return this.updateDashboardListItemsWithHttpInfo(dashboardListId, body).getData();
    }

    public ApiResponse<DashboardListUpdateItemsResponse> updateDashboardListItemsWithHttpInfo(Long dashboardListId, DashboardListUpdateItemsRequest body) throws ApiException {
        DashboardListUpdateItemsRequest localVarPostBody = body;
        if (dashboardListId == null) {
            throw new ApiException(400, "Missing the required parameter 'dashboardListId' when calling updateDashboardListItems");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateDashboardListItems");
        }
        String localVarPath = "/api/v2/dashboard/lists/manual/{dashboard_list_id}/dashboards".replaceAll("\\{dashboard_list_id\\}", this.apiClient.escapeString(dashboardListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateDashboardListItems");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<DashboardListUpdateItemsResponse> localVarReturnType = new GenericType<DashboardListUpdateItemsResponse>(){};
        return this.apiClient.invokeAPI("DashboardListsApi.updateDashboardListItems", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }
}

