/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SyntheticsGlobalVariableParseTestOptions;
import com.datadog.api.v1.client.model.SyntheticsGlobalVariableValue;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Synthetics global variable.")
@JsonPropertyOrder(value={"description", "id", "name", "parse_test_options", "parse_test_public_id", "tags", "value"})
public class SyntheticsGlobalVariable {
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PARSE_TEST_OPTIONS = "parse_test_options";
    private SyntheticsGlobalVariableParseTestOptions parseTestOptions;
    public static final String JSON_PROPERTY_PARSE_TEST_PUBLIC_ID = "parse_test_public_id";
    private String parseTestPublicId;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = new ArrayList<String>();
    public static final String JSON_PROPERTY_VALUE = "value";
    private SyntheticsGlobalVariableValue value;

    public SyntheticsGlobalVariable() {
    }

    @JsonCreator
    public SyntheticsGlobalVariable(@JsonProperty(required=true, value="description") String description, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="tags") List<String> tags, @JsonProperty(required=true, value="value") SyntheticsGlobalVariableValue value) {
        this.description = description;
        this.name = name;
        this.tags = tags;
        this.value = value;
    }

    public SyntheticsGlobalVariable description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="Example description", required=true, value="Description of the global variable.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the global variable.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public SyntheticsGlobalVariable name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="MY_VARIABLE", required=true, value="Name of the global variable.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SyntheticsGlobalVariable parseTestOptions(SyntheticsGlobalVariableParseTestOptions parseTestOptions) {
        this.parseTestOptions = parseTestOptions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="parse_test_options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsGlobalVariableParseTestOptions getParseTestOptions() {
        return this.parseTestOptions;
    }

    public void setParseTestOptions(SyntheticsGlobalVariableParseTestOptions parseTestOptions) {
        this.parseTestOptions = parseTestOptions;
    }

    public SyntheticsGlobalVariable parseTestPublicId(String parseTestPublicId) {
        this.parseTestPublicId = parseTestPublicId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="abc-def-123", value="A Synthetic test ID to use as a test to generate the variable value.")
    @JsonProperty(value="parse_test_public_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getParseTestPublicId() {
        return this.parseTestPublicId;
    }

    public void setParseTestPublicId(String parseTestPublicId) {
        this.parseTestPublicId = parseTestPublicId;
    }

    public SyntheticsGlobalVariable tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public SyntheticsGlobalVariable addTagsItem(String tagsItem) {
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(example="[\"team:front\",\"test:workflow-1\"]", required=true, value="Tags of the global variable.")
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public SyntheticsGlobalVariable value(SyntheticsGlobalVariableValue value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SyntheticsGlobalVariableValue getValue() {
        return this.value;
    }

    public void setValue(SyntheticsGlobalVariableValue value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsGlobalVariable syntheticsGlobalVariable = (SyntheticsGlobalVariable)o;
        return Objects.equals(this.description, syntheticsGlobalVariable.description) && Objects.equals(this.id, syntheticsGlobalVariable.id) && Objects.equals(this.name, syntheticsGlobalVariable.name) && Objects.equals(this.parseTestOptions, syntheticsGlobalVariable.parseTestOptions) && Objects.equals(this.parseTestPublicId, syntheticsGlobalVariable.parseTestPublicId) && Objects.equals(this.tags, syntheticsGlobalVariable.tags) && Objects.equals(this.value, syntheticsGlobalVariable.value);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.id, this.name, this.parseTestOptions, this.parseTestPublicId, this.tags, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsGlobalVariable {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parseTestOptions: ").append(this.toIndentedString(this.parseTestOptions)).append("\n");
        sb.append("    parseTestPublicId: ").append(this.toIndentedString(this.parseTestPublicId)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

