/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Metadata about the response.")
@JsonPropertyOrder(value={"page", "page_count", "per_page", "total_count"})
public class MonitorSearchResponseMetadata {
    public static final String JSON_PROPERTY_PAGE = "page";
    private Long page;
    public static final String JSON_PROPERTY_PAGE_COUNT = "page_count";
    private Long pageCount;
    public static final String JSON_PROPERTY_PER_PAGE = "per_page";
    private Long perPage;
    public static final String JSON_PROPERTY_TOTAL_COUNT = "total_count";
    private Long totalCount;

    @Nullable
    @ApiModelProperty(value="The page to start paginating from.")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getPage() {
        return this.page;
    }

    @Nullable
    @ApiModelProperty(value="The number of pages.")
    @JsonProperty(value="page_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getPageCount() {
        return this.pageCount;
    }

    @Nullable
    @ApiModelProperty(value="The number of monitors to return per page.")
    @JsonProperty(value="per_page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getPerPage() {
        return this.perPage;
    }

    @Nullable
    @ApiModelProperty(value="The total number of monitors.")
    @JsonProperty(value="total_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTotalCount() {
        return this.totalCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonitorSearchResponseMetadata monitorSearchResponseMetadata = (MonitorSearchResponseMetadata)o;
        return Objects.equals(this.page, monitorSearchResponseMetadata.page) && Objects.equals(this.pageCount, monitorSearchResponseMetadata.pageCount) && Objects.equals(this.perPage, monitorSearchResponseMetadata.perPage) && Objects.equals(this.totalCount, monitorSearchResponseMetadata.totalCount);
    }

    public int hashCode() {
        return Objects.hash(this.page, this.pageCount, this.perPage, this.totalCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MonitorSearchResponseMetadata {\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    pageCount: ").append(this.toIndentedString(this.pageCount)).append("\n");
        sb.append("    perPage: ").append(this.toIndentedString(this.perPage)).append("\n");
        sb.append("    totalCount: ").append(this.toIndentedString(this.totalCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

