/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.IncidentFieldAttributes;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="The incident's attributes for an update request.")
@JsonPropertyOrder(value={"customer_impact_end", "customer_impact_scope", "customer_impact_start", "customer_impacted", "detected", "fields", "notification_handles", "resolved", "title"})
public class IncidentUpdateAttributes {
    public static final String JSON_PROPERTY_CUSTOMER_IMPACT_END = "customer_impact_end";
    private JsonNullable<OffsetDateTime> customerImpactEnd = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CUSTOMER_IMPACT_SCOPE = "customer_impact_scope";
    private String customerImpactScope;
    public static final String JSON_PROPERTY_CUSTOMER_IMPACT_START = "customer_impact_start";
    private JsonNullable<OffsetDateTime> customerImpactStart = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CUSTOMER_IMPACTED = "customer_impacted";
    private Boolean customerImpacted;
    public static final String JSON_PROPERTY_DETECTED = "detected";
    private JsonNullable<OffsetDateTime> detected = JsonNullable.undefined();
    public static final String JSON_PROPERTY_FIELDS = "fields";
    private Map<String, IncidentFieldAttributes> fields = null;
    public static final String JSON_PROPERTY_NOTIFICATION_HANDLES = "notification_handles";
    private List<String> notificationHandles = null;
    public static final String JSON_PROPERTY_RESOLVED = "resolved";
    private JsonNullable<OffsetDateTime> resolved = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;

    public IncidentUpdateAttributes customerImpactEnd(OffsetDateTime customerImpactEnd) {
        this.customerImpactEnd = JsonNullable.of((Object)customerImpactEnd);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when customers were no longer impacted by the incident.")
    @JsonIgnore
    public OffsetDateTime getCustomerImpactEnd() {
        return (OffsetDateTime)this.customerImpactEnd.orElse(null);
    }

    @JsonProperty(value="customer_impact_end")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getCustomerImpactEnd_JsonNullable() {
        return this.customerImpactEnd;
    }

    @JsonProperty(value="customer_impact_end")
    public void setCustomerImpactEnd_JsonNullable(JsonNullable<OffsetDateTime> customerImpactEnd) {
        this.customerImpactEnd = customerImpactEnd;
    }

    public void setCustomerImpactEnd(OffsetDateTime customerImpactEnd) {
        this.customerImpactEnd = JsonNullable.of((Object)customerImpactEnd);
    }

    public IncidentUpdateAttributes customerImpactScope(String customerImpactScope) {
        this.customerImpactScope = customerImpactScope;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Example customer impact scope", value="A summary of the impact customers experienced during the incident.")
    @JsonProperty(value="customer_impact_scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerImpactScope() {
        return this.customerImpactScope;
    }

    public void setCustomerImpactScope(String customerImpactScope) {
        this.customerImpactScope = customerImpactScope;
    }

    public IncidentUpdateAttributes customerImpactStart(OffsetDateTime customerImpactStart) {
        this.customerImpactStart = JsonNullable.of((Object)customerImpactStart);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when customers began being impacted by the incident.")
    @JsonIgnore
    public OffsetDateTime getCustomerImpactStart() {
        return (OffsetDateTime)this.customerImpactStart.orElse(null);
    }

    @JsonProperty(value="customer_impact_start")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getCustomerImpactStart_JsonNullable() {
        return this.customerImpactStart;
    }

    @JsonProperty(value="customer_impact_start")
    public void setCustomerImpactStart_JsonNullable(JsonNullable<OffsetDateTime> customerImpactStart) {
        this.customerImpactStart = customerImpactStart;
    }

    public void setCustomerImpactStart(OffsetDateTime customerImpactStart) {
        this.customerImpactStart = JsonNullable.of((Object)customerImpactStart);
    }

    public IncidentUpdateAttributes customerImpacted(Boolean customerImpacted) {
        this.customerImpacted = customerImpacted;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="A flag indicating whether the incident caused customer impact.")
    @JsonProperty(value="customer_impacted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCustomerImpacted() {
        return this.customerImpacted;
    }

    public void setCustomerImpacted(Boolean customerImpacted) {
        this.customerImpacted = customerImpacted;
    }

    public IncidentUpdateAttributes detected(OffsetDateTime detected) {
        this.detected = JsonNullable.of((Object)detected);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when the incident was detected.")
    @JsonIgnore
    public OffsetDateTime getDetected() {
        return (OffsetDateTime)this.detected.orElse(null);
    }

    @JsonProperty(value="detected")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getDetected_JsonNullable() {
        return this.detected;
    }

    @JsonProperty(value="detected")
    public void setDetected_JsonNullable(JsonNullable<OffsetDateTime> detected) {
        this.detected = detected;
    }

    public void setDetected(OffsetDateTime detected) {
        this.detected = JsonNullable.of((Object)detected);
    }

    public IncidentUpdateAttributes fields(Map<String, IncidentFieldAttributes> fields) {
        this.fields = fields;
        return this;
    }

    public IncidentUpdateAttributes putFieldsItem(String key, IncidentFieldAttributes fieldsItem) {
        if (this.fields == null) {
            this.fields = new HashMap<String, IncidentFieldAttributes>();
        }
        this.fields.put(key, fieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"severity\":{\"type\":\"dropdown\",\"value\":\"SEV-5\"}}", value="A condensed view of the user-defined fields for which to update selections.")
    @JsonProperty(value="fields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, IncidentFieldAttributes> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, IncidentFieldAttributes> fields) {
        this.fields = fields;
    }

    public IncidentUpdateAttributes notificationHandles(List<String> notificationHandles) {
        this.notificationHandles = notificationHandles;
        return this;
    }

    public IncidentUpdateAttributes addNotificationHandlesItem(String notificationHandlesItem) {
        if (this.notificationHandles == null) {
            this.notificationHandles = new ArrayList<String>();
        }
        this.notificationHandles.add(notificationHandlesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Notification handles that will be notified of the incident during update.")
    @JsonProperty(value="notification_handles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getNotificationHandles() {
        return this.notificationHandles;
    }

    public void setNotificationHandles(List<String> notificationHandles) {
        this.notificationHandles = notificationHandles;
    }

    public IncidentUpdateAttributes resolved(OffsetDateTime resolved) {
        this.resolved = JsonNullable.of((Object)resolved);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when the incident's state was set to resolved.")
    @JsonIgnore
    public OffsetDateTime getResolved() {
        return (OffsetDateTime)this.resolved.orElse(null);
    }

    @JsonProperty(value="resolved")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getResolved_JsonNullable() {
        return this.resolved;
    }

    @JsonProperty(value="resolved")
    public void setResolved_JsonNullable(JsonNullable<OffsetDateTime> resolved) {
        this.resolved = resolved;
    }

    public void setResolved(OffsetDateTime resolved) {
        this.resolved = JsonNullable.of((Object)resolved);
    }

    public IncidentUpdateAttributes title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="A test incident title", value="The title of the incident, which summarizes what happened.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentUpdateAttributes incidentUpdateAttributes = (IncidentUpdateAttributes)o;
        return Objects.equals(this.customerImpactEnd, incidentUpdateAttributes.customerImpactEnd) && Objects.equals(this.customerImpactScope, incidentUpdateAttributes.customerImpactScope) && Objects.equals(this.customerImpactStart, incidentUpdateAttributes.customerImpactStart) && Objects.equals(this.customerImpacted, incidentUpdateAttributes.customerImpacted) && Objects.equals(this.detected, incidentUpdateAttributes.detected) && Objects.equals(this.fields, incidentUpdateAttributes.fields) && Objects.equals(this.notificationHandles, incidentUpdateAttributes.notificationHandles) && Objects.equals(this.resolved, incidentUpdateAttributes.resolved) && Objects.equals(this.title, incidentUpdateAttributes.title);
    }

    public int hashCode() {
        return Objects.hash(this.customerImpactEnd, this.customerImpactScope, this.customerImpactStart, this.customerImpacted, this.detected, this.fields, this.notificationHandles, this.resolved, this.title);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncidentUpdateAttributes {\n");
        sb.append("    customerImpactEnd: ").append(this.toIndentedString(this.customerImpactEnd)).append("\n");
        sb.append("    customerImpactScope: ").append(this.toIndentedString(this.customerImpactScope)).append("\n");
        sb.append("    customerImpactStart: ").append(this.toIndentedString(this.customerImpactStart)).append("\n");
        sb.append("    customerImpacted: ").append(this.toIndentedString(this.customerImpacted)).append("\n");
        sb.append("    detected: ").append(this.toIndentedString(this.detected)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("    notificationHandles: ").append(this.toIndentedString(this.notificationHandles)).append("\n");
        sb.append("    resolved: ").append(this.toIndentedString(this.resolved)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

