/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Markers allow you to add visual conditional formatting for your graphs.")
@JsonPropertyOrder(value={"display_type", "label", "time", "value"})
public class WidgetMarker {
    public static final String JSON_PROPERTY_DISPLAY_TYPE = "display_type";
    private String displayType;
    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;
    public static final String JSON_PROPERTY_TIME = "time";
    private String time;
    public static final String JSON_PROPERTY_VALUE = "value";
    private String value;

    public WidgetMarker displayType(String displayType) {
        this.displayType = displayType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="error dashed", value="Combination of:   - A severity error, warning, ok, or info   - A line type: dashed, solid, or bold In this case of a Distribution widget, this can be set to be `x_axis_percentile`. ")
    @JsonProperty(value="display_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(String displayType) {
        this.displayType = displayType;
    }

    public WidgetMarker label(String label) {
        this.label = label;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Error threshold", value="Label to display over the marker.")
    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public WidgetMarker time(String time) {
        this.time = time;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp for the widget.")
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public WidgetMarker value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="y = 15", required=true, value="Value to apply. Can be a single value y = 15 or a range of values 0 < y < 10.")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WidgetMarker widgetMarker = (WidgetMarker)o;
        return Objects.equals(this.displayType, widgetMarker.displayType) && Objects.equals(this.label, widgetMarker.label) && Objects.equals(this.time, widgetMarker.time) && Objects.equals(this.value, widgetMarker.value);
    }

    public int hashCode() {
        return Objects.hash(this.displayType, this.label, this.time, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WidgetMarker {\n");
        sb.append("    displayType: ").append(this.toIndentedString(this.displayType)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

