/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.LogsByRetention;
import com.datadog.api.v1.client.model.UsageSummaryDate;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Response with hourly report of all data billed by Datadog all organizations.")
@JsonPropertyOrder(value={"agent_host_top99p_sum", "apm_azure_app_service_host_top99p_sum", "apm_host_top99p_sum", "aws_host_top99p_sum", "aws_lambda_func_count", "aws_lambda_invocations_sum", "azure_app_service_top99p_sum", "azure_host_top99p_sum", "billable_ingested_bytes_agg_sum", "compliance_container_agg_sum", "compliance_host_agg_sum", "container_avg_sum", "container_hwm_sum", "custom_ts_sum", "end_date", "fargate_tasks_count_avg_sum", "fargate_tasks_count_hwm_sum", "gcp_host_top99p_sum", "heroku_host_top99p_sum", "incident_management_monthly_active_users_hwm_sum", "indexed_events_count_agg_sum", "infra_host_top99p_sum", "ingested_events_bytes_agg_sum", "iot_device_agg_sum", "iot_device_top99p_sum", "last_updated", "live_indexed_events_agg_sum", "live_ingested_bytes_agg_sum", "logs_by_retention", "mobile_rum_session_count_agg_sum", "mobile_rum_session_count_android_agg_sum", "mobile_rum_session_count_ios_agg_sum", "netflow_indexed_events_count_agg_sum", "npm_host_top99p_sum", "opentelemetry_host_top99p_sum", "profiling_container_agent_count_avg", "profiling_host_count_top99p_sum", "rehydrated_indexed_events_agg_sum", "rehydrated_ingested_bytes_agg_sum", "rum_session_count_agg_sum", "rum_total_session_count_agg_sum", "start_date", "synthetics_browser_check_calls_count_agg_sum", "synthetics_check_calls_count_agg_sum", "trace_search_indexed_events_count_agg_sum", "twol_ingested_events_bytes_agg_sum", "usage", "vsphere_host_top99p_sum"})
public class UsageSummaryResponse {
    public static final String JSON_PROPERTY_AGENT_HOST_TOP99P_SUM = "agent_host_top99p_sum";
    private Long agentHostTop99pSum;
    public static final String JSON_PROPERTY_APM_AZURE_APP_SERVICE_HOST_TOP99P_SUM = "apm_azure_app_service_host_top99p_sum";
    private Long apmAzureAppServiceHostTop99pSum;
    public static final String JSON_PROPERTY_APM_HOST_TOP99P_SUM = "apm_host_top99p_sum";
    private Long apmHostTop99pSum;
    public static final String JSON_PROPERTY_AWS_HOST_TOP99P_SUM = "aws_host_top99p_sum";
    private Long awsHostTop99pSum;
    public static final String JSON_PROPERTY_AWS_LAMBDA_FUNC_COUNT = "aws_lambda_func_count";
    private Long awsLambdaFuncCount;
    public static final String JSON_PROPERTY_AWS_LAMBDA_INVOCATIONS_SUM = "aws_lambda_invocations_sum";
    private Long awsLambdaInvocationsSum;
    public static final String JSON_PROPERTY_AZURE_APP_SERVICE_TOP99P_SUM = "azure_app_service_top99p_sum";
    private Long azureAppServiceTop99pSum;
    public static final String JSON_PROPERTY_AZURE_HOST_TOP99P_SUM = "azure_host_top99p_sum";
    private Long azureHostTop99pSum;
    public static final String JSON_PROPERTY_BILLABLE_INGESTED_BYTES_AGG_SUM = "billable_ingested_bytes_agg_sum";
    private Long billableIngestedBytesAggSum;
    public static final String JSON_PROPERTY_COMPLIANCE_CONTAINER_AGG_SUM = "compliance_container_agg_sum";
    private JsonNullable<Object> complianceContainerAggSum = JsonNullable.of(null);
    public static final String JSON_PROPERTY_COMPLIANCE_HOST_AGG_SUM = "compliance_host_agg_sum";
    private Long complianceHostAggSum;
    public static final String JSON_PROPERTY_CONTAINER_AVG_SUM = "container_avg_sum";
    private Long containerAvgSum;
    public static final String JSON_PROPERTY_CONTAINER_HWM_SUM = "container_hwm_sum";
    private Long containerHwmSum;
    public static final String JSON_PROPERTY_CUSTOM_TS_SUM = "custom_ts_sum";
    private Long customTsSum;
    public static final String JSON_PROPERTY_END_DATE = "end_date";
    private OffsetDateTime endDate;
    public static final String JSON_PROPERTY_FARGATE_TASKS_COUNT_AVG_SUM = "fargate_tasks_count_avg_sum";
    private Long fargateTasksCountAvgSum;
    public static final String JSON_PROPERTY_FARGATE_TASKS_COUNT_HWM_SUM = "fargate_tasks_count_hwm_sum";
    private Long fargateTasksCountHwmSum;
    public static final String JSON_PROPERTY_GCP_HOST_TOP99P_SUM = "gcp_host_top99p_sum";
    private Long gcpHostTop99pSum;
    public static final String JSON_PROPERTY_HEROKU_HOST_TOP99P_SUM = "heroku_host_top99p_sum";
    private Long herokuHostTop99pSum;
    public static final String JSON_PROPERTY_INCIDENT_MANAGEMENT_MONTHLY_ACTIVE_USERS_HWM_SUM = "incident_management_monthly_active_users_hwm_sum";
    private Long incidentManagementMonthlyActiveUsersHwmSum;
    public static final String JSON_PROPERTY_INDEXED_EVENTS_COUNT_AGG_SUM = "indexed_events_count_agg_sum";
    private Long indexedEventsCountAggSum;
    public static final String JSON_PROPERTY_INFRA_HOST_TOP99P_SUM = "infra_host_top99p_sum";
    private Long infraHostTop99pSum;
    public static final String JSON_PROPERTY_INGESTED_EVENTS_BYTES_AGG_SUM = "ingested_events_bytes_agg_sum";
    private Long ingestedEventsBytesAggSum;
    public static final String JSON_PROPERTY_IOT_DEVICE_AGG_SUM = "iot_device_agg_sum";
    private Long iotDeviceAggSum;
    public static final String JSON_PROPERTY_IOT_DEVICE_TOP99P_SUM = "iot_device_top99p_sum";
    private Long iotDeviceTop99pSum;
    public static final String JSON_PROPERTY_LAST_UPDATED = "last_updated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_LIVE_INDEXED_EVENTS_AGG_SUM = "live_indexed_events_agg_sum";
    private Long liveIndexedEventsAggSum;
    public static final String JSON_PROPERTY_LIVE_INGESTED_BYTES_AGG_SUM = "live_ingested_bytes_agg_sum";
    private Long liveIngestedBytesAggSum;
    public static final String JSON_PROPERTY_LOGS_BY_RETENTION = "logs_by_retention";
    private LogsByRetention logsByRetention;
    public static final String JSON_PROPERTY_MOBILE_RUM_SESSION_COUNT_AGG_SUM = "mobile_rum_session_count_agg_sum";
    private Long mobileRumSessionCountAggSum;
    public static final String JSON_PROPERTY_MOBILE_RUM_SESSION_COUNT_ANDROID_AGG_SUM = "mobile_rum_session_count_android_agg_sum";
    private Long mobileRumSessionCountAndroidAggSum;
    public static final String JSON_PROPERTY_MOBILE_RUM_SESSION_COUNT_IOS_AGG_SUM = "mobile_rum_session_count_ios_agg_sum";
    private Long mobileRumSessionCountIosAggSum;
    public static final String JSON_PROPERTY_NETFLOW_INDEXED_EVENTS_COUNT_AGG_SUM = "netflow_indexed_events_count_agg_sum";
    private Long netflowIndexedEventsCountAggSum;
    public static final String JSON_PROPERTY_NPM_HOST_TOP99P_SUM = "npm_host_top99p_sum";
    private Long npmHostTop99pSum;
    public static final String JSON_PROPERTY_OPENTELEMETRY_HOST_TOP99P_SUM = "opentelemetry_host_top99p_sum";
    private Long opentelemetryHostTop99pSum;
    public static final String JSON_PROPERTY_PROFILING_CONTAINER_AGENT_COUNT_AVG = "profiling_container_agent_count_avg";
    private Long profilingContainerAgentCountAvg;
    public static final String JSON_PROPERTY_PROFILING_HOST_COUNT_TOP99P_SUM = "profiling_host_count_top99p_sum";
    private Long profilingHostCountTop99pSum;
    public static final String JSON_PROPERTY_REHYDRATED_INDEXED_EVENTS_AGG_SUM = "rehydrated_indexed_events_agg_sum";
    private Long rehydratedIndexedEventsAggSum;
    public static final String JSON_PROPERTY_REHYDRATED_INGESTED_BYTES_AGG_SUM = "rehydrated_ingested_bytes_agg_sum";
    private Long rehydratedIngestedBytesAggSum;
    public static final String JSON_PROPERTY_RUM_SESSION_COUNT_AGG_SUM = "rum_session_count_agg_sum";
    private Long rumSessionCountAggSum;
    public static final String JSON_PROPERTY_RUM_TOTAL_SESSION_COUNT_AGG_SUM = "rum_total_session_count_agg_sum";
    private Long rumTotalSessionCountAggSum;
    public static final String JSON_PROPERTY_START_DATE = "start_date";
    private OffsetDateTime startDate;
    public static final String JSON_PROPERTY_SYNTHETICS_BROWSER_CHECK_CALLS_COUNT_AGG_SUM = "synthetics_browser_check_calls_count_agg_sum";
    private Long syntheticsBrowserCheckCallsCountAggSum;
    public static final String JSON_PROPERTY_SYNTHETICS_CHECK_CALLS_COUNT_AGG_SUM = "synthetics_check_calls_count_agg_sum";
    private Long syntheticsCheckCallsCountAggSum;
    public static final String JSON_PROPERTY_TRACE_SEARCH_INDEXED_EVENTS_COUNT_AGG_SUM = "trace_search_indexed_events_count_agg_sum";
    private Long traceSearchIndexedEventsCountAggSum;
    public static final String JSON_PROPERTY_TWOL_INGESTED_EVENTS_BYTES_AGG_SUM = "twol_ingested_events_bytes_agg_sum";
    private Long twolIngestedEventsBytesAggSum;
    public static final String JSON_PROPERTY_USAGE = "usage";
    private List<UsageSummaryDate> usage = null;
    public static final String JSON_PROPERTY_VSPHERE_HOST_TOP99P_SUM = "vsphere_host_top99p_sum";
    private Long vsphereHostTop99pSum;

    public UsageSummaryResponse agentHostTop99pSum(Long agentHostTop99pSum) {
        this.agentHostTop99pSum = agentHostTop99pSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all agent hosts over all hours in the current months for all organizations.")
    @JsonProperty(value="agent_host_top99p_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAgentHostTop99pSum() {
        return this.agentHostTop99pSum;
    }

    public void setAgentHostTop99pSum(Long agentHostTop99pSum) {
        this.agentHostTop99pSum = agentHostTop99pSum;
    }

    public UsageSummaryResponse apmAzureAppServiceHostTop99pSum(Long apmAzureAppServiceHostTop99pSum) {
        this.apmAzureAppServiceHostTop99pSum = apmAzureAppServiceHostTop99pSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all Azure app services using APM over all hours in the current months all organizations.")
    @JsonProperty(value="apm_azure_app_service_host_top99p_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getApmAzureAppServiceHostTop99pSum() {
        return this.apmAzureAppServiceHostTop99pSum;
    }

    public void setApmAzureAppServiceHostTop99pSum(Long apmAzureAppServiceHostTop99pSum) {
        this.apmAzureAppServiceHostTop99pSum = apmAzureAppServiceHostTop99pSum;
    }

    public UsageSummaryResponse apmHostTop99pSum(Long apmHostTop99pSum) {
        this.apmHostTop99pSum = apmHostTop99pSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all distinct APM hosts over all hours in the current months for all organizations.")
    @JsonProperty(value="apm_host_top99p_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getApmHostTop99pSum() {
        return this.apmHostTop99pSum;
    }

    public void setApmHostTop99pSum(Long apmHostTop99pSum) {
        this.apmHostTop99pSum = apmHostTop99pSum;
    }

    public UsageSummaryResponse awsHostTop99pSum(Long awsHostTop99pSum) {
        this.awsHostTop99pSum = awsHostTop99pSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all AWS hosts over all hours in the current months for all organizations.")
    @JsonProperty(value="aws_host_top99p_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAwsHostTop99pSum() {
        return this.awsHostTop99pSum;
    }

    public void setAwsHostTop99pSum(Long awsHostTop99pSum) {
        this.awsHostTop99pSum = awsHostTop99pSum;
    }

    public UsageSummaryResponse awsLambdaFuncCount(Long awsLambdaFuncCount) {
        this.awsLambdaFuncCount = awsLambdaFuncCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the average of the number of functions that executed 1 or more times each hour in the current months for all organizations.")
    @JsonProperty(value="aws_lambda_func_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAwsLambdaFuncCount() {
        return this.awsLambdaFuncCount;
    }

    public void setAwsLambdaFuncCount(Long awsLambdaFuncCount) {
        this.awsLambdaFuncCount = awsLambdaFuncCount;
    }

    public UsageSummaryResponse awsLambdaInvocationsSum(Long awsLambdaInvocationsSum) {
        this.awsLambdaInvocationsSum = awsLambdaInvocationsSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all AWS Lambda invocations over all hours in the current months for all organizations.")
    @JsonProperty(value="aws_lambda_invocations_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAwsLambdaInvocationsSum() {
        return this.awsLambdaInvocationsSum;
    }

    public void setAwsLambdaInvocationsSum(Long awsLambdaInvocationsSum) {
        this.awsLambdaInvocationsSum = awsLambdaInvocationsSum;
    }

    public UsageSummaryResponse azureAppServiceTop99pSum(Long azureAppServiceTop99pSum) {
        this.azureAppServiceTop99pSum = azureAppServiceTop99pSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all Azure app services over all hours in the current months for all organizations.")
    @JsonProperty(value="azure_app_service_top99p_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAzureAppServiceTop99pSum() {
        return this.azureAppServiceTop99pSum;
    }

    public void setAzureAppServiceTop99pSum(Long azureAppServiceTop99pSum) {
        this.azureAppServiceTop99pSum = azureAppServiceTop99pSum;
    }

    public UsageSummaryResponse azureHostTop99pSum(Long azureHostTop99pSum) {
        this.azureHostTop99pSum = azureHostTop99pSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all Azure hosts over all hours in the current months for all organizations.")
    @JsonProperty(value="azure_host_top99p_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAzureHostTop99pSum() {
        return this.azureHostTop99pSum;
    }

    public void setAzureHostTop99pSum(Long azureHostTop99pSum) {
        this.azureHostTop99pSum = azureHostTop99pSum;
    }

    public UsageSummaryResponse billableIngestedBytesAggSum(Long billableIngestedBytesAggSum) {
        this.billableIngestedBytesAggSum = billableIngestedBytesAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all log bytes ingested over all hours in the current months for all organizations.")
    @JsonProperty(value="billable_ingested_bytes_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getBillableIngestedBytesAggSum() {
        return this.billableIngestedBytesAggSum;
    }

    public void setBillableIngestedBytesAggSum(Long billableIngestedBytesAggSum) {
        this.billableIngestedBytesAggSum = billableIngestedBytesAggSum;
    }

    public UsageSummaryResponse complianceContainerAggSum(Object complianceContainerAggSum) {
        this.complianceContainerAggSum = JsonNullable.of((Object)complianceContainerAggSum);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all compliance containers over all hours in the current months for all organizations.")
    @JsonIgnore
    public Object getComplianceContainerAggSum() {
        return this.complianceContainerAggSum.orElse(null);
    }

    @JsonProperty(value="compliance_container_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Object> getComplianceContainerAggSum_JsonNullable() {
        return this.complianceContainerAggSum;
    }

    @JsonProperty(value="compliance_container_agg_sum")
    public void setComplianceContainerAggSum_JsonNullable(JsonNullable<Object> complianceContainerAggSum) {
        this.complianceContainerAggSum = complianceContainerAggSum;
    }

    public void setComplianceContainerAggSum(Object complianceContainerAggSum) {
        this.complianceContainerAggSum = JsonNullable.of((Object)complianceContainerAggSum);
    }

    public UsageSummaryResponse complianceHostAggSum(Long complianceHostAggSum) {
        this.complianceHostAggSum = complianceHostAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all compliance hosts over all hours in the current months for all organizations.")
    @JsonProperty(value="compliance_host_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getComplianceHostAggSum() {
        return this.complianceHostAggSum;
    }

    public void setComplianceHostAggSum(Long complianceHostAggSum) {
        this.complianceHostAggSum = complianceHostAggSum;
    }

    public UsageSummaryResponse containerAvgSum(Long containerAvgSum) {
        this.containerAvgSum = containerAvgSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the average of all distinct containers over all hours in the current months for all organizations.")
    @JsonProperty(value="container_avg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getContainerAvgSum() {
        return this.containerAvgSum;
    }

    public void setContainerAvgSum(Long containerAvgSum) {
        this.containerAvgSum = containerAvgSum;
    }

    public UsageSummaryResponse containerHwmSum(Long containerHwmSum) {
        this.containerHwmSum = containerHwmSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of the high-water marks of all distinct containers over all hours in the current months for all organizations.")
    @JsonProperty(value="container_hwm_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getContainerHwmSum() {
        return this.containerHwmSum;
    }

    public void setContainerHwmSum(Long containerHwmSum) {
        this.containerHwmSum = containerHwmSum;
    }

    public UsageSummaryResponse customTsSum(Long customTsSum) {
        this.customTsSum = customTsSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the average number of distinct custom metrics over all hours in the current months for all organizations.")
    @JsonProperty(value="custom_ts_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCustomTsSum() {
        return this.customTsSum;
    }

    public void setCustomTsSum(Long customTsSum) {
        this.customTsSum = customTsSum;
    }

    public UsageSummaryResponse endDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the last date of usage in the current months for all organizations.")
    @JsonProperty(value="end_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public UsageSummaryResponse fargateTasksCountAvgSum(Long fargateTasksCountAvgSum) {
        this.fargateTasksCountAvgSum = fargateTasksCountAvgSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the average of all Fargate tasks over all hours in the current months for all organizations.")
    @JsonProperty(value="fargate_tasks_count_avg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getFargateTasksCountAvgSum() {
        return this.fargateTasksCountAvgSum;
    }

    public void setFargateTasksCountAvgSum(Long fargateTasksCountAvgSum) {
        this.fargateTasksCountAvgSum = fargateTasksCountAvgSum;
    }

    public UsageSummaryResponse fargateTasksCountHwmSum(Long fargateTasksCountHwmSum) {
        this.fargateTasksCountHwmSum = fargateTasksCountHwmSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of the high-water marks of all Fargate tasks over all hours in the current months for all organizations.")
    @JsonProperty(value="fargate_tasks_count_hwm_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getFargateTasksCountHwmSum() {
        return this.fargateTasksCountHwmSum;
    }

    public void setFargateTasksCountHwmSum(Long fargateTasksCountHwmSum) {
        this.fargateTasksCountHwmSum = fargateTasksCountHwmSum;
    }

    public UsageSummaryResponse gcpHostTop99pSum(Long gcpHostTop99pSum) {
        this.gcpHostTop99pSum = gcpHostTop99pSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all GCP hosts over all hours in the current months for all organizations.")
    @JsonProperty(value="gcp_host_top99p_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getGcpHostTop99pSum() {
        return this.gcpHostTop99pSum;
    }

    public void setGcpHostTop99pSum(Long gcpHostTop99pSum) {
        this.gcpHostTop99pSum = gcpHostTop99pSum;
    }

    public UsageSummaryResponse herokuHostTop99pSum(Long herokuHostTop99pSum) {
        this.herokuHostTop99pSum = herokuHostTop99pSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all Heroku dynos over all hours in the current months for all organizations.")
    @JsonProperty(value="heroku_host_top99p_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getHerokuHostTop99pSum() {
        return this.herokuHostTop99pSum;
    }

    public void setHerokuHostTop99pSum(Long herokuHostTop99pSum) {
        this.herokuHostTop99pSum = herokuHostTop99pSum;
    }

    public UsageSummaryResponse incidentManagementMonthlyActiveUsersHwmSum(Long incidentManagementMonthlyActiveUsersHwmSum) {
        this.incidentManagementMonthlyActiveUsersHwmSum = incidentManagementMonthlyActiveUsersHwmSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows sum of the the high-water marks of incident management monthly active users in the current months for all organizations.")
    @JsonProperty(value="incident_management_monthly_active_users_hwm_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getIncidentManagementMonthlyActiveUsersHwmSum() {
        return this.incidentManagementMonthlyActiveUsersHwmSum;
    }

    public void setIncidentManagementMonthlyActiveUsersHwmSum(Long incidentManagementMonthlyActiveUsersHwmSum) {
        this.incidentManagementMonthlyActiveUsersHwmSum = incidentManagementMonthlyActiveUsersHwmSum;
    }

    public UsageSummaryResponse indexedEventsCountAggSum(Long indexedEventsCountAggSum) {
        this.indexedEventsCountAggSum = indexedEventsCountAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all log events indexed over all hours in the current months for all organizations.")
    @JsonProperty(value="indexed_events_count_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getIndexedEventsCountAggSum() {
        return this.indexedEventsCountAggSum;
    }

    public void setIndexedEventsCountAggSum(Long indexedEventsCountAggSum) {
        this.indexedEventsCountAggSum = indexedEventsCountAggSum;
    }

    public UsageSummaryResponse infraHostTop99pSum(Long infraHostTop99pSum) {
        this.infraHostTop99pSum = infraHostTop99pSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all distinct infrastructure hosts over all hours in the current months for all organizations.")
    @JsonProperty(value="infra_host_top99p_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getInfraHostTop99pSum() {
        return this.infraHostTop99pSum;
    }

    public void setInfraHostTop99pSum(Long infraHostTop99pSum) {
        this.infraHostTop99pSum = infraHostTop99pSum;
    }

    public UsageSummaryResponse ingestedEventsBytesAggSum(Long ingestedEventsBytesAggSum) {
        this.ingestedEventsBytesAggSum = ingestedEventsBytesAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all log bytes ingested over all hours in the current months for all organizations.")
    @JsonProperty(value="ingested_events_bytes_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getIngestedEventsBytesAggSum() {
        return this.ingestedEventsBytesAggSum;
    }

    public void setIngestedEventsBytesAggSum(Long ingestedEventsBytesAggSum) {
        this.ingestedEventsBytesAggSum = ingestedEventsBytesAggSum;
    }

    public UsageSummaryResponse iotDeviceAggSum(Long iotDeviceAggSum) {
        this.iotDeviceAggSum = iotDeviceAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all IoT devices over all hours in the current months for all organizations.")
    @JsonProperty(value="iot_device_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getIotDeviceAggSum() {
        return this.iotDeviceAggSum;
    }

    public void setIotDeviceAggSum(Long iotDeviceAggSum) {
        this.iotDeviceAggSum = iotDeviceAggSum;
    }

    public UsageSummaryResponse iotDeviceTop99pSum(Long iotDeviceTop99pSum) {
        this.iotDeviceTop99pSum = iotDeviceTop99pSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all IoT devices over all hours in the current months of all organizations.")
    @JsonProperty(value="iot_device_top99p_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getIotDeviceTop99pSum() {
        return this.iotDeviceTop99pSum;
    }

    public void setIotDeviceTop99pSum(Long iotDeviceTop99pSum) {
        this.iotDeviceTop99pSum = iotDeviceTop99pSum;
    }

    public UsageSummaryResponse lastUpdated(OffsetDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the the most recent hour in the current months for all organizations for which all usages were calculated.")
    @JsonProperty(value="last_updated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(OffsetDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public UsageSummaryResponse liveIndexedEventsAggSum(Long liveIndexedEventsAggSum) {
        this.liveIndexedEventsAggSum = liveIndexedEventsAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all live logs indexed over all hours in the current months for all organizations (data available as of December 1, 2020).")
    @JsonProperty(value="live_indexed_events_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getLiveIndexedEventsAggSum() {
        return this.liveIndexedEventsAggSum;
    }

    public void setLiveIndexedEventsAggSum(Long liveIndexedEventsAggSum) {
        this.liveIndexedEventsAggSum = liveIndexedEventsAggSum;
    }

    public UsageSummaryResponse liveIngestedBytesAggSum(Long liveIngestedBytesAggSum) {
        this.liveIngestedBytesAggSum = liveIngestedBytesAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all live logs bytes ingested over all hours in the current months for all organizations (data available as of December 1, 2020).")
    @JsonProperty(value="live_ingested_bytes_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getLiveIngestedBytesAggSum() {
        return this.liveIngestedBytesAggSum;
    }

    public void setLiveIngestedBytesAggSum(Long liveIngestedBytesAggSum) {
        this.liveIngestedBytesAggSum = liveIngestedBytesAggSum;
    }

    public UsageSummaryResponse logsByRetention(LogsByRetention logsByRetention) {
        this.logsByRetention = logsByRetention;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="logs_by_retention")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsByRetention getLogsByRetention() {
        return this.logsByRetention;
    }

    public void setLogsByRetention(LogsByRetention logsByRetention) {
        this.logsByRetention = logsByRetention;
    }

    public UsageSummaryResponse mobileRumSessionCountAggSum(Long mobileRumSessionCountAggSum) {
        this.mobileRumSessionCountAggSum = mobileRumSessionCountAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all mobile RUM Sessions over all hours in the current months for all organizations.")
    @JsonProperty(value="mobile_rum_session_count_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMobileRumSessionCountAggSum() {
        return this.mobileRumSessionCountAggSum;
    }

    public void setMobileRumSessionCountAggSum(Long mobileRumSessionCountAggSum) {
        this.mobileRumSessionCountAggSum = mobileRumSessionCountAggSum;
    }

    public UsageSummaryResponse mobileRumSessionCountAndroidAggSum(Long mobileRumSessionCountAndroidAggSum) {
        this.mobileRumSessionCountAndroidAggSum = mobileRumSessionCountAndroidAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all mobile RUM Sessions on Android over all hours in the current months for all organizations.")
    @JsonProperty(value="mobile_rum_session_count_android_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMobileRumSessionCountAndroidAggSum() {
        return this.mobileRumSessionCountAndroidAggSum;
    }

    public void setMobileRumSessionCountAndroidAggSum(Long mobileRumSessionCountAndroidAggSum) {
        this.mobileRumSessionCountAndroidAggSum = mobileRumSessionCountAndroidAggSum;
    }

    public UsageSummaryResponse mobileRumSessionCountIosAggSum(Long mobileRumSessionCountIosAggSum) {
        this.mobileRumSessionCountIosAggSum = mobileRumSessionCountIosAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all mobile RUM Sessions on iOS over all hours in the current months for all organizations.")
    @JsonProperty(value="mobile_rum_session_count_ios_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMobileRumSessionCountIosAggSum() {
        return this.mobileRumSessionCountIosAggSum;
    }

    public void setMobileRumSessionCountIosAggSum(Long mobileRumSessionCountIosAggSum) {
        this.mobileRumSessionCountIosAggSum = mobileRumSessionCountIosAggSum;
    }

    public UsageSummaryResponse netflowIndexedEventsCountAggSum(Long netflowIndexedEventsCountAggSum) {
        this.netflowIndexedEventsCountAggSum = netflowIndexedEventsCountAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all Network flows indexed over all hours in the current months for all organizations.")
    @JsonProperty(value="netflow_indexed_events_count_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getNetflowIndexedEventsCountAggSum() {
        return this.netflowIndexedEventsCountAggSum;
    }

    public void setNetflowIndexedEventsCountAggSum(Long netflowIndexedEventsCountAggSum) {
        this.netflowIndexedEventsCountAggSum = netflowIndexedEventsCountAggSum;
    }

    public UsageSummaryResponse npmHostTop99pSum(Long npmHostTop99pSum) {
        this.npmHostTop99pSum = npmHostTop99pSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all distinct Networks hosts over all hours in the current months for all organizations.")
    @JsonProperty(value="npm_host_top99p_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getNpmHostTop99pSum() {
        return this.npmHostTop99pSum;
    }

    public void setNpmHostTop99pSum(Long npmHostTop99pSum) {
        this.npmHostTop99pSum = npmHostTop99pSum;
    }

    public UsageSummaryResponse opentelemetryHostTop99pSum(Long opentelemetryHostTop99pSum) {
        this.opentelemetryHostTop99pSum = opentelemetryHostTop99pSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all hosts reported by the Datadog exporter for the OpenTelemetry Collector over all hours in the current months for all organizations.")
    @JsonProperty(value="opentelemetry_host_top99p_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getOpentelemetryHostTop99pSum() {
        return this.opentelemetryHostTop99pSum;
    }

    public void setOpentelemetryHostTop99pSum(Long opentelemetryHostTop99pSum) {
        this.opentelemetryHostTop99pSum = opentelemetryHostTop99pSum;
    }

    public UsageSummaryResponse profilingContainerAgentCountAvg(Long profilingContainerAgentCountAvg) {
        this.profilingContainerAgentCountAvg = profilingContainerAgentCountAvg;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the average number of profiled containers over all hours in the current months for all organizations.")
    @JsonProperty(value="profiling_container_agent_count_avg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getProfilingContainerAgentCountAvg() {
        return this.profilingContainerAgentCountAvg;
    }

    public void setProfilingContainerAgentCountAvg(Long profilingContainerAgentCountAvg) {
        this.profilingContainerAgentCountAvg = profilingContainerAgentCountAvg;
    }

    public UsageSummaryResponse profilingHostCountTop99pSum(Long profilingHostCountTop99pSum) {
        this.profilingHostCountTop99pSum = profilingHostCountTop99pSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all profiled hosts over all hours in the current months for all organizations.")
    @JsonProperty(value="profiling_host_count_top99p_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getProfilingHostCountTop99pSum() {
        return this.profilingHostCountTop99pSum;
    }

    public void setProfilingHostCountTop99pSum(Long profilingHostCountTop99pSum) {
        this.profilingHostCountTop99pSum = profilingHostCountTop99pSum;
    }

    public UsageSummaryResponse rehydratedIndexedEventsAggSum(Long rehydratedIndexedEventsAggSum) {
        this.rehydratedIndexedEventsAggSum = rehydratedIndexedEventsAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all rehydrated logs indexed over all hours in the current months for all organizations (data available as of December 1, 2020).")
    @JsonProperty(value="rehydrated_indexed_events_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getRehydratedIndexedEventsAggSum() {
        return this.rehydratedIndexedEventsAggSum;
    }

    public void setRehydratedIndexedEventsAggSum(Long rehydratedIndexedEventsAggSum) {
        this.rehydratedIndexedEventsAggSum = rehydratedIndexedEventsAggSum;
    }

    public UsageSummaryResponse rehydratedIngestedBytesAggSum(Long rehydratedIngestedBytesAggSum) {
        this.rehydratedIngestedBytesAggSum = rehydratedIngestedBytesAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all rehydrated logs bytes ingested over all hours in the current months for all organizations (data available as of December 1, 2020).")
    @JsonProperty(value="rehydrated_ingested_bytes_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getRehydratedIngestedBytesAggSum() {
        return this.rehydratedIngestedBytesAggSum;
    }

    public void setRehydratedIngestedBytesAggSum(Long rehydratedIngestedBytesAggSum) {
        this.rehydratedIngestedBytesAggSum = rehydratedIngestedBytesAggSum;
    }

    public UsageSummaryResponse rumSessionCountAggSum(Long rumSessionCountAggSum) {
        this.rumSessionCountAggSum = rumSessionCountAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all browser RUM Sessions over all hours in the current months for all organizations.")
    @JsonProperty(value="rum_session_count_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getRumSessionCountAggSum() {
        return this.rumSessionCountAggSum;
    }

    public void setRumSessionCountAggSum(Long rumSessionCountAggSum) {
        this.rumSessionCountAggSum = rumSessionCountAggSum;
    }

    public UsageSummaryResponse rumTotalSessionCountAggSum(Long rumTotalSessionCountAggSum) {
        this.rumTotalSessionCountAggSum = rumTotalSessionCountAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of RUM Sessions (browser and mobile) over all hours in the current months for all organizations.")
    @JsonProperty(value="rum_total_session_count_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getRumTotalSessionCountAggSum() {
        return this.rumTotalSessionCountAggSum;
    }

    public void setRumTotalSessionCountAggSum(Long rumTotalSessionCountAggSum) {
        this.rumTotalSessionCountAggSum = rumTotalSessionCountAggSum;
    }

    public UsageSummaryResponse startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the first date of usage in the current months for all organizations.")
    @JsonProperty(value="start_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public UsageSummaryResponse syntheticsBrowserCheckCallsCountAggSum(Long syntheticsBrowserCheckCallsCountAggSum) {
        this.syntheticsBrowserCheckCallsCountAggSum = syntheticsBrowserCheckCallsCountAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all Synthetic browser tests over all hours in the current months for all organizations.")
    @JsonProperty(value="synthetics_browser_check_calls_count_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getSyntheticsBrowserCheckCallsCountAggSum() {
        return this.syntheticsBrowserCheckCallsCountAggSum;
    }

    public void setSyntheticsBrowserCheckCallsCountAggSum(Long syntheticsBrowserCheckCallsCountAggSum) {
        this.syntheticsBrowserCheckCallsCountAggSum = syntheticsBrowserCheckCallsCountAggSum;
    }

    public UsageSummaryResponse syntheticsCheckCallsCountAggSum(Long syntheticsCheckCallsCountAggSum) {
        this.syntheticsCheckCallsCountAggSum = syntheticsCheckCallsCountAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all Synthetic API tests over all hours in the current months for all organizations.")
    @JsonProperty(value="synthetics_check_calls_count_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getSyntheticsCheckCallsCountAggSum() {
        return this.syntheticsCheckCallsCountAggSum;
    }

    public void setSyntheticsCheckCallsCountAggSum(Long syntheticsCheckCallsCountAggSum) {
        this.syntheticsCheckCallsCountAggSum = syntheticsCheckCallsCountAggSum;
    }

    public UsageSummaryResponse traceSearchIndexedEventsCountAggSum(Long traceSearchIndexedEventsCountAggSum) {
        this.traceSearchIndexedEventsCountAggSum = traceSearchIndexedEventsCountAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all Indexed Spans indexed over all hours in the current months for all organizations.")
    @JsonProperty(value="trace_search_indexed_events_count_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTraceSearchIndexedEventsCountAggSum() {
        return this.traceSearchIndexedEventsCountAggSum;
    }

    public void setTraceSearchIndexedEventsCountAggSum(Long traceSearchIndexedEventsCountAggSum) {
        this.traceSearchIndexedEventsCountAggSum = traceSearchIndexedEventsCountAggSum;
    }

    public UsageSummaryResponse twolIngestedEventsBytesAggSum(Long twolIngestedEventsBytesAggSum) {
        this.twolIngestedEventsBytesAggSum = twolIngestedEventsBytesAggSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the sum of all tracing without limits bytes ingested over all hours in the current months for all organizations.")
    @JsonProperty(value="twol_ingested_events_bytes_agg_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTwolIngestedEventsBytesAggSum() {
        return this.twolIngestedEventsBytesAggSum;
    }

    public void setTwolIngestedEventsBytesAggSum(Long twolIngestedEventsBytesAggSum) {
        this.twolIngestedEventsBytesAggSum = twolIngestedEventsBytesAggSum;
    }

    public UsageSummaryResponse usage(List<UsageSummaryDate> usage) {
        this.usage = usage;
        return this;
    }

    public UsageSummaryResponse addUsageItem(UsageSummaryDate usageItem) {
        if (this.usage == null) {
            this.usage = new ArrayList<UsageSummaryDate>();
        }
        this.usage.add(usageItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of objects regarding hourly usage.")
    @JsonProperty(value="usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UsageSummaryDate> getUsage() {
        return this.usage;
    }

    public void setUsage(List<UsageSummaryDate> usage) {
        this.usage = usage;
    }

    public UsageSummaryResponse vsphereHostTop99pSum(Long vsphereHostTop99pSum) {
        this.vsphereHostTop99pSum = vsphereHostTop99pSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the 99th percentile of all vSphere hosts over all hours in the current months for all organizations.")
    @JsonProperty(value="vsphere_host_top99p_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVsphereHostTop99pSum() {
        return this.vsphereHostTop99pSum;
    }

    public void setVsphereHostTop99pSum(Long vsphereHostTop99pSum) {
        this.vsphereHostTop99pSum = vsphereHostTop99pSum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageSummaryResponse usageSummaryResponse = (UsageSummaryResponse)o;
        return Objects.equals(this.agentHostTop99pSum, usageSummaryResponse.agentHostTop99pSum) && Objects.equals(this.apmAzureAppServiceHostTop99pSum, usageSummaryResponse.apmAzureAppServiceHostTop99pSum) && Objects.equals(this.apmHostTop99pSum, usageSummaryResponse.apmHostTop99pSum) && Objects.equals(this.awsHostTop99pSum, usageSummaryResponse.awsHostTop99pSum) && Objects.equals(this.awsLambdaFuncCount, usageSummaryResponse.awsLambdaFuncCount) && Objects.equals(this.awsLambdaInvocationsSum, usageSummaryResponse.awsLambdaInvocationsSum) && Objects.equals(this.azureAppServiceTop99pSum, usageSummaryResponse.azureAppServiceTop99pSum) && Objects.equals(this.azureHostTop99pSum, usageSummaryResponse.azureHostTop99pSum) && Objects.equals(this.billableIngestedBytesAggSum, usageSummaryResponse.billableIngestedBytesAggSum) && Objects.equals(this.complianceContainerAggSum, usageSummaryResponse.complianceContainerAggSum) && Objects.equals(this.complianceHostAggSum, usageSummaryResponse.complianceHostAggSum) && Objects.equals(this.containerAvgSum, usageSummaryResponse.containerAvgSum) && Objects.equals(this.containerHwmSum, usageSummaryResponse.containerHwmSum) && Objects.equals(this.customTsSum, usageSummaryResponse.customTsSum) && Objects.equals(this.endDate, usageSummaryResponse.endDate) && Objects.equals(this.fargateTasksCountAvgSum, usageSummaryResponse.fargateTasksCountAvgSum) && Objects.equals(this.fargateTasksCountHwmSum, usageSummaryResponse.fargateTasksCountHwmSum) && Objects.equals(this.gcpHostTop99pSum, usageSummaryResponse.gcpHostTop99pSum) && Objects.equals(this.herokuHostTop99pSum, usageSummaryResponse.herokuHostTop99pSum) && Objects.equals(this.incidentManagementMonthlyActiveUsersHwmSum, usageSummaryResponse.incidentManagementMonthlyActiveUsersHwmSum) && Objects.equals(this.indexedEventsCountAggSum, usageSummaryResponse.indexedEventsCountAggSum) && Objects.equals(this.infraHostTop99pSum, usageSummaryResponse.infraHostTop99pSum) && Objects.equals(this.ingestedEventsBytesAggSum, usageSummaryResponse.ingestedEventsBytesAggSum) && Objects.equals(this.iotDeviceAggSum, usageSummaryResponse.iotDeviceAggSum) && Objects.equals(this.iotDeviceTop99pSum, usageSummaryResponse.iotDeviceTop99pSum) && Objects.equals(this.lastUpdated, usageSummaryResponse.lastUpdated) && Objects.equals(this.liveIndexedEventsAggSum, usageSummaryResponse.liveIndexedEventsAggSum) && Objects.equals(this.liveIngestedBytesAggSum, usageSummaryResponse.liveIngestedBytesAggSum) && Objects.equals(this.logsByRetention, usageSummaryResponse.logsByRetention) && Objects.equals(this.mobileRumSessionCountAggSum, usageSummaryResponse.mobileRumSessionCountAggSum) && Objects.equals(this.mobileRumSessionCountAndroidAggSum, usageSummaryResponse.mobileRumSessionCountAndroidAggSum) && Objects.equals(this.mobileRumSessionCountIosAggSum, usageSummaryResponse.mobileRumSessionCountIosAggSum) && Objects.equals(this.netflowIndexedEventsCountAggSum, usageSummaryResponse.netflowIndexedEventsCountAggSum) && Objects.equals(this.npmHostTop99pSum, usageSummaryResponse.npmHostTop99pSum) && Objects.equals(this.opentelemetryHostTop99pSum, usageSummaryResponse.opentelemetryHostTop99pSum) && Objects.equals(this.profilingContainerAgentCountAvg, usageSummaryResponse.profilingContainerAgentCountAvg) && Objects.equals(this.profilingHostCountTop99pSum, usageSummaryResponse.profilingHostCountTop99pSum) && Objects.equals(this.rehydratedIndexedEventsAggSum, usageSummaryResponse.rehydratedIndexedEventsAggSum) && Objects.equals(this.rehydratedIngestedBytesAggSum, usageSummaryResponse.rehydratedIngestedBytesAggSum) && Objects.equals(this.rumSessionCountAggSum, usageSummaryResponse.rumSessionCountAggSum) && Objects.equals(this.rumTotalSessionCountAggSum, usageSummaryResponse.rumTotalSessionCountAggSum) && Objects.equals(this.startDate, usageSummaryResponse.startDate) && Objects.equals(this.syntheticsBrowserCheckCallsCountAggSum, usageSummaryResponse.syntheticsBrowserCheckCallsCountAggSum) && Objects.equals(this.syntheticsCheckCallsCountAggSum, usageSummaryResponse.syntheticsCheckCallsCountAggSum) && Objects.equals(this.traceSearchIndexedEventsCountAggSum, usageSummaryResponse.traceSearchIndexedEventsCountAggSum) && Objects.equals(this.twolIngestedEventsBytesAggSum, usageSummaryResponse.twolIngestedEventsBytesAggSum) && Objects.equals(this.usage, usageSummaryResponse.usage) && Objects.equals(this.vsphereHostTop99pSum, usageSummaryResponse.vsphereHostTop99pSum);
    }

    public int hashCode() {
        return Objects.hash(this.agentHostTop99pSum, this.apmAzureAppServiceHostTop99pSum, this.apmHostTop99pSum, this.awsHostTop99pSum, this.awsLambdaFuncCount, this.awsLambdaInvocationsSum, this.azureAppServiceTop99pSum, this.azureHostTop99pSum, this.billableIngestedBytesAggSum, this.complianceContainerAggSum, this.complianceHostAggSum, this.containerAvgSum, this.containerHwmSum, this.customTsSum, this.endDate, this.fargateTasksCountAvgSum, this.fargateTasksCountHwmSum, this.gcpHostTop99pSum, this.herokuHostTop99pSum, this.incidentManagementMonthlyActiveUsersHwmSum, this.indexedEventsCountAggSum, this.infraHostTop99pSum, this.ingestedEventsBytesAggSum, this.iotDeviceAggSum, this.iotDeviceTop99pSum, this.lastUpdated, this.liveIndexedEventsAggSum, this.liveIngestedBytesAggSum, this.logsByRetention, this.mobileRumSessionCountAggSum, this.mobileRumSessionCountAndroidAggSum, this.mobileRumSessionCountIosAggSum, this.netflowIndexedEventsCountAggSum, this.npmHostTop99pSum, this.opentelemetryHostTop99pSum, this.profilingContainerAgentCountAvg, this.profilingHostCountTop99pSum, this.rehydratedIndexedEventsAggSum, this.rehydratedIngestedBytesAggSum, this.rumSessionCountAggSum, this.rumTotalSessionCountAggSum, this.startDate, this.syntheticsBrowserCheckCallsCountAggSum, this.syntheticsCheckCallsCountAggSum, this.traceSearchIndexedEventsCountAggSum, this.twolIngestedEventsBytesAggSum, this.usage, this.vsphereHostTop99pSum);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageSummaryResponse {\n");
        sb.append("    agentHostTop99pSum: ").append(this.toIndentedString(this.agentHostTop99pSum)).append("\n");
        sb.append("    apmAzureAppServiceHostTop99pSum: ").append(this.toIndentedString(this.apmAzureAppServiceHostTop99pSum)).append("\n");
        sb.append("    apmHostTop99pSum: ").append(this.toIndentedString(this.apmHostTop99pSum)).append("\n");
        sb.append("    awsHostTop99pSum: ").append(this.toIndentedString(this.awsHostTop99pSum)).append("\n");
        sb.append("    awsLambdaFuncCount: ").append(this.toIndentedString(this.awsLambdaFuncCount)).append("\n");
        sb.append("    awsLambdaInvocationsSum: ").append(this.toIndentedString(this.awsLambdaInvocationsSum)).append("\n");
        sb.append("    azureAppServiceTop99pSum: ").append(this.toIndentedString(this.azureAppServiceTop99pSum)).append("\n");
        sb.append("    azureHostTop99pSum: ").append(this.toIndentedString(this.azureHostTop99pSum)).append("\n");
        sb.append("    billableIngestedBytesAggSum: ").append(this.toIndentedString(this.billableIngestedBytesAggSum)).append("\n");
        sb.append("    complianceContainerAggSum: ").append(this.toIndentedString(this.complianceContainerAggSum)).append("\n");
        sb.append("    complianceHostAggSum: ").append(this.toIndentedString(this.complianceHostAggSum)).append("\n");
        sb.append("    containerAvgSum: ").append(this.toIndentedString(this.containerAvgSum)).append("\n");
        sb.append("    containerHwmSum: ").append(this.toIndentedString(this.containerHwmSum)).append("\n");
        sb.append("    customTsSum: ").append(this.toIndentedString(this.customTsSum)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    fargateTasksCountAvgSum: ").append(this.toIndentedString(this.fargateTasksCountAvgSum)).append("\n");
        sb.append("    fargateTasksCountHwmSum: ").append(this.toIndentedString(this.fargateTasksCountHwmSum)).append("\n");
        sb.append("    gcpHostTop99pSum: ").append(this.toIndentedString(this.gcpHostTop99pSum)).append("\n");
        sb.append("    herokuHostTop99pSum: ").append(this.toIndentedString(this.herokuHostTop99pSum)).append("\n");
        sb.append("    incidentManagementMonthlyActiveUsersHwmSum: ").append(this.toIndentedString(this.incidentManagementMonthlyActiveUsersHwmSum)).append("\n");
        sb.append("    indexedEventsCountAggSum: ").append(this.toIndentedString(this.indexedEventsCountAggSum)).append("\n");
        sb.append("    infraHostTop99pSum: ").append(this.toIndentedString(this.infraHostTop99pSum)).append("\n");
        sb.append("    ingestedEventsBytesAggSum: ").append(this.toIndentedString(this.ingestedEventsBytesAggSum)).append("\n");
        sb.append("    iotDeviceAggSum: ").append(this.toIndentedString(this.iotDeviceAggSum)).append("\n");
        sb.append("    iotDeviceTop99pSum: ").append(this.toIndentedString(this.iotDeviceTop99pSum)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    liveIndexedEventsAggSum: ").append(this.toIndentedString(this.liveIndexedEventsAggSum)).append("\n");
        sb.append("    liveIngestedBytesAggSum: ").append(this.toIndentedString(this.liveIngestedBytesAggSum)).append("\n");
        sb.append("    logsByRetention: ").append(this.toIndentedString(this.logsByRetention)).append("\n");
        sb.append("    mobileRumSessionCountAggSum: ").append(this.toIndentedString(this.mobileRumSessionCountAggSum)).append("\n");
        sb.append("    mobileRumSessionCountAndroidAggSum: ").append(this.toIndentedString(this.mobileRumSessionCountAndroidAggSum)).append("\n");
        sb.append("    mobileRumSessionCountIosAggSum: ").append(this.toIndentedString(this.mobileRumSessionCountIosAggSum)).append("\n");
        sb.append("    netflowIndexedEventsCountAggSum: ").append(this.toIndentedString(this.netflowIndexedEventsCountAggSum)).append("\n");
        sb.append("    npmHostTop99pSum: ").append(this.toIndentedString(this.npmHostTop99pSum)).append("\n");
        sb.append("    opentelemetryHostTop99pSum: ").append(this.toIndentedString(this.opentelemetryHostTop99pSum)).append("\n");
        sb.append("    profilingContainerAgentCountAvg: ").append(this.toIndentedString(this.profilingContainerAgentCountAvg)).append("\n");
        sb.append("    profilingHostCountTop99pSum: ").append(this.toIndentedString(this.profilingHostCountTop99pSum)).append("\n");
        sb.append("    rehydratedIndexedEventsAggSum: ").append(this.toIndentedString(this.rehydratedIndexedEventsAggSum)).append("\n");
        sb.append("    rehydratedIngestedBytesAggSum: ").append(this.toIndentedString(this.rehydratedIngestedBytesAggSum)).append("\n");
        sb.append("    rumSessionCountAggSum: ").append(this.toIndentedString(this.rumSessionCountAggSum)).append("\n");
        sb.append("    rumTotalSessionCountAggSum: ").append(this.toIndentedString(this.rumTotalSessionCountAggSum)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    syntheticsBrowserCheckCallsCountAggSum: ").append(this.toIndentedString(this.syntheticsBrowserCheckCallsCountAggSum)).append("\n");
        sb.append("    syntheticsCheckCallsCountAggSum: ").append(this.toIndentedString(this.syntheticsCheckCallsCountAggSum)).append("\n");
        sb.append("    traceSearchIndexedEventsCountAggSum: ").append(this.toIndentedString(this.traceSearchIndexedEventsCountAggSum)).append("\n");
        sb.append("    twolIngestedEventsBytesAggSum: ").append(this.toIndentedString(this.twolIngestedEventsBytesAggSum)).append("\n");
        sb.append("    usage: ").append(this.toIndentedString(this.usage)).append("\n");
        sb.append("    vsphereHostTop99pSum: ").append(this.toIndentedString(this.vsphereHostTop99pSum)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

