/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SyntheticsAPIStepSubtype;
import com.datadog.api.v1.client.model.SyntheticsAssertion;
import com.datadog.api.v1.client.model.SyntheticsParsingOptions;
import com.datadog.api.v1.client.model.SyntheticsTestRequest;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The steps used in a Synthetics multistep API test.")
@JsonPropertyOrder(value={"allowFailure", "assertions", "extractedValues", "isCritical", "name", "request", "subtype"})
public class SyntheticsAPIStep {
    public static final String JSON_PROPERTY_ALLOW_FAILURE = "allowFailure";
    private Boolean allowFailure;
    public static final String JSON_PROPERTY_ASSERTIONS = "assertions";
    private List<SyntheticsAssertion> assertions = null;
    public static final String JSON_PROPERTY_EXTRACTED_VALUES = "extractedValues";
    private List<SyntheticsParsingOptions> extractedValues = null;
    public static final String JSON_PROPERTY_IS_CRITICAL = "isCritical";
    private Boolean isCritical;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_REQUEST = "request";
    private SyntheticsTestRequest request;
    public static final String JSON_PROPERTY_SUBTYPE = "subtype";
    private SyntheticsAPIStepSubtype subtype;

    public SyntheticsAPIStep allowFailure(Boolean allowFailure) {
        this.allowFailure = allowFailure;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Determines whether or not to continue with test if this step fails.")
    @JsonProperty(value="allowFailure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowFailure() {
        return this.allowFailure;
    }

    public void setAllowFailure(Boolean allowFailure) {
        this.allowFailure = allowFailure;
    }

    public SyntheticsAPIStep assertions(List<SyntheticsAssertion> assertions) {
        this.assertions = assertions;
        return this;
    }

    public SyntheticsAPIStep addAssertionsItem(SyntheticsAssertion assertionsItem) {
        if (this.assertions == null) {
            this.assertions = new ArrayList<SyntheticsAssertion>();
        }
        this.assertions.add(assertionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[]", value="Array of assertions used for the test.")
    @JsonProperty(value="assertions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsAssertion> getAssertions() {
        return this.assertions;
    }

    public void setAssertions(List<SyntheticsAssertion> assertions) {
        this.assertions = assertions;
    }

    public SyntheticsAPIStep extractedValues(List<SyntheticsParsingOptions> extractedValues) {
        this.extractedValues = extractedValues;
        return this;
    }

    public SyntheticsAPIStep addExtractedValuesItem(SyntheticsParsingOptions extractedValuesItem) {
        if (this.extractedValues == null) {
            this.extractedValues = new ArrayList<SyntheticsParsingOptions>();
        }
        this.extractedValues.add(extractedValuesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of values to parse and save as variables from the response.")
    @JsonProperty(value="extractedValues")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsParsingOptions> getExtractedValues() {
        return this.extractedValues;
    }

    public void setExtractedValues(List<SyntheticsParsingOptions> extractedValues) {
        this.extractedValues = extractedValues;
    }

    public SyntheticsAPIStep isCritical(Boolean isCritical) {
        this.isCritical = isCritical;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Determines whether or not to consider the entire test as failed if this step fails. Can be used only if `allowFailure` is `true`.")
    @JsonProperty(value="isCritical")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsCritical() {
        return this.isCritical;
    }

    public void setIsCritical(Boolean isCritical) {
        this.isCritical = isCritical;
    }

    public SyntheticsAPIStep name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the step.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SyntheticsAPIStep request(SyntheticsTestRequest request) {
        this.request = request;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="request")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestRequest getRequest() {
        return this.request;
    }

    public void setRequest(SyntheticsTestRequest request) {
        this.request = request;
    }

    public SyntheticsAPIStep subtype(SyntheticsAPIStepSubtype subtype) {
        this.subtype = subtype;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="subtype")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsAPIStepSubtype getSubtype() {
        return this.subtype;
    }

    public void setSubtype(SyntheticsAPIStepSubtype subtype) {
        this.subtype = subtype;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsAPIStep syntheticsAPIStep = (SyntheticsAPIStep)o;
        return Objects.equals(this.allowFailure, syntheticsAPIStep.allowFailure) && Objects.equals(this.assertions, syntheticsAPIStep.assertions) && Objects.equals(this.extractedValues, syntheticsAPIStep.extractedValues) && Objects.equals(this.isCritical, syntheticsAPIStep.isCritical) && Objects.equals(this.name, syntheticsAPIStep.name) && Objects.equals(this.request, syntheticsAPIStep.request) && Objects.equals((Object)this.subtype, (Object)syntheticsAPIStep.subtype);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowFailure, this.assertions, this.extractedValues, this.isCritical, this.name, this.request, this.subtype});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsAPIStep {\n");
        sb.append("    allowFailure: ").append(this.toIndentedString(this.allowFailure)).append("\n");
        sb.append("    assertions: ").append(this.toIndentedString(this.assertions)).append("\n");
        sb.append("    extractedValues: ").append(this.toIndentedString(this.extractedValues)).append("\n");
        sb.append("    isCritical: ").append(this.toIndentedString(this.isCritical)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("    subtype: ").append(this.toIndentedString((Object)this.subtype)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

