/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The list of current AWS services for which Datadog offers automatic log collection.")
@JsonPropertyOrder(value={"id", "label"})
public class AWSLogsListServicesResponse {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;

    public AWSLogsListServicesResponse id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="s3", value="Key value in returned object.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AWSLogsListServicesResponse label(String label) {
        this.label = label;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="S3 Access Logs", value="Name of service available for configuration with Datadog logs.")
    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSLogsListServicesResponse awSLogsListServicesResponse = (AWSLogsListServicesResponse)o;
        return Objects.equals(this.id, awSLogsListServicesResponse.id) && Objects.equals(this.label, awSLogsListServicesResponse.label);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.label);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AWSLogsListServicesResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

