/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.IncidentFieldAttributes;
import com.datadog.api.v2.client.model.IncidentTimelineCellCreateAttributes;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The incident's attributes for a create request.")
@JsonPropertyOrder(value={"customer_impacted", "fields", "initial_timeline_cells", "notification_handles", "title"})
public class IncidentCreateAttributes {
    public static final String JSON_PROPERTY_CUSTOMER_IMPACTED = "customer_impacted";
    private Boolean customerImpacted;
    public static final String JSON_PROPERTY_FIELDS = "fields";
    private Map<String, IncidentFieldAttributes> fields = null;
    public static final String JSON_PROPERTY_INITIAL_TIMELINE_CELLS = "initial_timeline_cells";
    private List<IncidentTimelineCellCreateAttributes> initialTimelineCells = null;
    public static final String JSON_PROPERTY_NOTIFICATION_HANDLES = "notification_handles";
    private List<String> notificationHandles = null;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;

    public IncidentCreateAttributes customerImpacted(Boolean customerImpacted) {
        this.customerImpacted = customerImpacted;
        return this;
    }

    @ApiModelProperty(example="false", required=true, value="A flag indicating whether the incident caused customer impact.")
    @JsonProperty(value="customer_impacted")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCustomerImpacted() {
        return this.customerImpacted;
    }

    public void setCustomerImpacted(Boolean customerImpacted) {
        this.customerImpacted = customerImpacted;
    }

    public IncidentCreateAttributes fields(Map<String, IncidentFieldAttributes> fields) {
        this.fields = fields;
        return this;
    }

    public IncidentCreateAttributes putFieldsItem(String key, IncidentFieldAttributes fieldsItem) {
        if (this.fields == null) {
            this.fields = new HashMap<String, IncidentFieldAttributes>();
        }
        this.fields.put(key, fieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"severity\":{\"type\":\"dropdown\",\"value\":\"SEV-5\"}}", value="A condensed view of the user-defined fields for which to create initial selections.")
    @JsonProperty(value="fields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, IncidentFieldAttributes> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, IncidentFieldAttributes> fields) {
        this.fields = fields;
    }

    public IncidentCreateAttributes initialTimelineCells(List<IncidentTimelineCellCreateAttributes> initialTimelineCells) {
        this.initialTimelineCells = initialTimelineCells;
        return this;
    }

    public IncidentCreateAttributes addInitialTimelineCellsItem(IncidentTimelineCellCreateAttributes initialTimelineCellsItem) {
        if (this.initialTimelineCells == null) {
            this.initialTimelineCells = new ArrayList<IncidentTimelineCellCreateAttributes>();
        }
        this.initialTimelineCells.add(initialTimelineCellsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of initial timeline cells to be placed at the beginning of the incident timeline.")
    @JsonProperty(value="initial_timeline_cells")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IncidentTimelineCellCreateAttributes> getInitialTimelineCells() {
        return this.initialTimelineCells;
    }

    public void setInitialTimelineCells(List<IncidentTimelineCellCreateAttributes> initialTimelineCells) {
        this.initialTimelineCells = initialTimelineCells;
    }

    public IncidentCreateAttributes notificationHandles(List<String> notificationHandles) {
        this.notificationHandles = notificationHandles;
        return this;
    }

    public IncidentCreateAttributes addNotificationHandlesItem(String notificationHandlesItem) {
        if (this.notificationHandles == null) {
            this.notificationHandles = new ArrayList<String>();
        }
        this.notificationHandles.add(notificationHandlesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Notification handles that will be notified of the incident at creation.")
    @JsonProperty(value="notification_handles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getNotificationHandles() {
        return this.notificationHandles;
    }

    public void setNotificationHandles(List<String> notificationHandles) {
        this.notificationHandles = notificationHandles;
    }

    public IncidentCreateAttributes title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="A test incident title", required=true, value="The title of the incident, which summarizes what happened.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentCreateAttributes incidentCreateAttributes = (IncidentCreateAttributes)o;
        return Objects.equals(this.customerImpacted, incidentCreateAttributes.customerImpacted) && Objects.equals(this.fields, incidentCreateAttributes.fields) && Objects.equals(this.initialTimelineCells, incidentCreateAttributes.initialTimelineCells) && Objects.equals(this.notificationHandles, incidentCreateAttributes.notificationHandles) && Objects.equals(this.title, incidentCreateAttributes.title);
    }

    public int hashCode() {
        return Objects.hash(this.customerImpacted, this.fields, this.initialTimelineCells, this.notificationHandles, this.title);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncidentCreateAttributes {\n");
        sb.append("    customerImpacted: ").append(this.toIndentedString(this.customerImpacted)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("    initialTimelineCells: ").append(this.toIndentedString(this.initialTimelineCells)).append("\n");
        sb.append("    notificationHandles: ").append(this.toIndentedString(this.notificationHandles)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

