/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Number of RUM Sessions recorded for each hour for a given organization.")
@JsonPropertyOrder(value={"hour", "session_count", "session_count_android", "session_count_ios"})
public class UsageRumSessionsHour {
    public static final String JSON_PROPERTY_HOUR = "hour";
    private OffsetDateTime hour;
    public static final String JSON_PROPERTY_SESSION_COUNT = "session_count";
    private Long sessionCount;
    public static final String JSON_PROPERTY_SESSION_COUNT_ANDROID = "session_count_android";
    private Long sessionCountAndroid;
    public static final String JSON_PROPERTY_SESSION_COUNT_IOS = "session_count_ios";
    private Long sessionCountIos;

    public UsageRumSessionsHour hour(OffsetDateTime hour) {
        this.hour = hour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hour for the usage.")
    @JsonProperty(value="hour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getHour() {
        return this.hour;
    }

    public void setHour(OffsetDateTime hour) {
        this.hour = hour;
    }

    public UsageRumSessionsHour sessionCount(Long sessionCount) {
        this.sessionCount = sessionCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the number of RUM Sessions.")
    @JsonProperty(value="session_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getSessionCount() {
        return this.sessionCount;
    }

    public void setSessionCount(Long sessionCount) {
        this.sessionCount = sessionCount;
    }

    public UsageRumSessionsHour sessionCountAndroid(Long sessionCountAndroid) {
        this.sessionCountAndroid = sessionCountAndroid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the number of mobile RUM Sessions on Android (data available beginning December 1, 2020).")
    @JsonProperty(value="session_count_android")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getSessionCountAndroid() {
        return this.sessionCountAndroid;
    }

    public void setSessionCountAndroid(Long sessionCountAndroid) {
        this.sessionCountAndroid = sessionCountAndroid;
    }

    public UsageRumSessionsHour sessionCountIos(Long sessionCountIos) {
        this.sessionCountIos = sessionCountIos;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the number of mobile RUM Sessions on iOS (data available beginning December 1, 2020).")
    @JsonProperty(value="session_count_ios")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getSessionCountIos() {
        return this.sessionCountIos;
    }

    public void setSessionCountIos(Long sessionCountIos) {
        this.sessionCountIos = sessionCountIos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageRumSessionsHour usageRumSessionsHour = (UsageRumSessionsHour)o;
        return Objects.equals(this.hour, usageRumSessionsHour.hour) && Objects.equals(this.sessionCount, usageRumSessionsHour.sessionCount) && Objects.equals(this.sessionCountAndroid, usageRumSessionsHour.sessionCountAndroid) && Objects.equals(this.sessionCountIos, usageRumSessionsHour.sessionCountIos);
    }

    public int hashCode() {
        return Objects.hash(this.hour, this.sessionCount, this.sessionCountAndroid, this.sessionCountIos);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageRumSessionsHour {\n");
        sb.append("    hour: ").append(this.toIndentedString(this.hour)).append("\n");
        sb.append("    sessionCount: ").append(this.toIndentedString(this.sessionCount)).append("\n");
        sb.append("    sessionCountAndroid: ").append(this.toIndentedString(this.sessionCountAndroid)).append("\n");
        sb.append("    sessionCountIos: ").append(this.toIndentedString(this.sessionCountIos)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

