/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.UsageAttributionBody;
import com.datadog.api.v1.client.model.UsageAttributionMetadata;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Response containing the Usage Summary by tag(s).")
@JsonPropertyOrder(value={"metadata", "usage"})
public class UsageAttributionResponse {
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private UsageAttributionMetadata metadata;
    public static final String JSON_PROPERTY_USAGE = "usage";
    private List<UsageAttributionBody> usage = null;

    public UsageAttributionResponse metadata(UsageAttributionMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UsageAttributionMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(UsageAttributionMetadata metadata) {
        this.metadata = metadata;
    }

    public UsageAttributionResponse usage(List<UsageAttributionBody> usage) {
        this.usage = usage;
        return this;
    }

    public UsageAttributionResponse addUsageItem(UsageAttributionBody usageItem) {
        if (this.usage == null) {
            this.usage = new ArrayList<UsageAttributionBody>();
        }
        this.usage.add(usageItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Get Usage Summary by tag(s).")
    @JsonProperty(value="usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UsageAttributionBody> getUsage() {
        return this.usage;
    }

    public void setUsage(List<UsageAttributionBody> usage) {
        this.usage = usage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageAttributionResponse usageAttributionResponse = (UsageAttributionResponse)o;
        return Objects.equals(this.metadata, usageAttributionResponse.metadata) && Objects.equals(this.usage, usageAttributionResponse.usage);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.usage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageAttributionResponse {\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    usage: ").append(this.toIndentedString(this.usage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

