/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.CheckCanDeleteSLOResponse;
import com.datadog.api.v1.client.model.SLOBulkDeleteResponse;
import com.datadog.api.v1.client.model.SLODeleteResponse;
import com.datadog.api.v1.client.model.SLOHistoryResponse;
import com.datadog.api.v1.client.model.SLOListResponse;
import com.datadog.api.v1.client.model.SLOResponse;
import com.datadog.api.v1.client.model.SLOTimeframe;
import com.datadog.api.v1.client.model.ServiceLevelObjective;
import com.datadog.api.v1.client.model.ServiceLevelObjectiveRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;

public class ServiceLevelObjectivesApi {
    private ApiClient apiClient;

    public ServiceLevelObjectivesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ServiceLevelObjectivesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CheckCanDeleteSLOResponse checkCanDeleteSLO(String ids) throws ApiException {
        return this.checkCanDeleteSLOWithHttpInfo(ids).getData();
    }

    public ApiResponse<CheckCanDeleteSLOResponse> checkCanDeleteSLOWithHttpInfo(String ids) throws ApiException {
        Object localVarPostBody = null;
        if (ids == null) {
            throw new ApiException(400, "Missing the required parameter 'ids' when calling checkCanDeleteSLO");
        }
        String localVarPath = "/api/v1/slo/can_delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ids", ids));
        localVarHeaderParams.put("DD-OPERATION-ID", "checkCanDeleteSLO");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<CheckCanDeleteSLOResponse> localVarReturnType = new GenericType<CheckCanDeleteSLOResponse>(){};
        return this.apiClient.invokeAPI("ServiceLevelObjectivesApi.checkCanDeleteSLO", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SLOListResponse createSLO(ServiceLevelObjectiveRequest body) throws ApiException {
        return this.createSLOWithHttpInfo(body).getData();
    }

    public ApiResponse<SLOListResponse> createSLOWithHttpInfo(ServiceLevelObjectiveRequest body) throws ApiException {
        ServiceLevelObjectiveRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSLO");
        }
        String localVarPath = "/api/v1/slo";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createSLO");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SLOListResponse> localVarReturnType = new GenericType<SLOListResponse>(){};
        return this.apiClient.invokeAPI("ServiceLevelObjectivesApi.createSLO", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SLODeleteResponse deleteSLO(String sloId) throws ApiException {
        return this.deleteSLOWithHttpInfo(sloId, new DeleteSLOOptionalParameters()).getData();
    }

    public SLODeleteResponse deleteSLO(String sloId, DeleteSLOOptionalParameters parameters) throws ApiException {
        return this.deleteSLOWithHttpInfo(sloId, parameters).getData();
    }

    public ApiResponse<SLODeleteResponse> deleteSLOWithHttpInfo(String sloId, DeleteSLOOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (sloId == null) {
            throw new ApiException(400, "Missing the required parameter 'sloId' when calling deleteSLO");
        }
        String force = parameters.force;
        String localVarPath = "/api/v1/slo/{slo_id}".replaceAll("\\{slo_id\\}", this.apiClient.escapeString(sloId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "force", force));
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteSLO");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SLODeleteResponse> localVarReturnType = new GenericType<SLODeleteResponse>(){};
        return this.apiClient.invokeAPI("ServiceLevelObjectivesApi.deleteSLO", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SLOBulkDeleteResponse deleteSLOTimeframeInBulk(Map<String, List<SLOTimeframe>> body) throws ApiException {
        return this.deleteSLOTimeframeInBulkWithHttpInfo(body).getData();
    }

    public ApiResponse<SLOBulkDeleteResponse> deleteSLOTimeframeInBulkWithHttpInfo(Map<String, List<SLOTimeframe>> body) throws ApiException {
        Map<String, List<SLOTimeframe>> localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteSLOTimeframeInBulk");
        }
        String localVarPath = "/api/v1/slo/bulk_delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteSLOTimeframeInBulk");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SLOBulkDeleteResponse> localVarReturnType = new GenericType<SLOBulkDeleteResponse>(){};
        return this.apiClient.invokeAPI("ServiceLevelObjectivesApi.deleteSLOTimeframeInBulk", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SLOResponse getSLO(String sloId) throws ApiException {
        return this.getSLOWithHttpInfo(sloId).getData();
    }

    public ApiResponse<SLOResponse> getSLOWithHttpInfo(String sloId) throws ApiException {
        Object localVarPostBody = null;
        if (sloId == null) {
            throw new ApiException(400, "Missing the required parameter 'sloId' when calling getSLO");
        }
        String localVarPath = "/api/v1/slo/{slo_id}".replaceAll("\\{slo_id\\}", this.apiClient.escapeString(sloId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getSLO");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SLOResponse> localVarReturnType = new GenericType<SLOResponse>(){};
        return this.apiClient.invokeAPI("ServiceLevelObjectivesApi.getSLO", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SLOHistoryResponse getSLOHistory(String sloId, Long fromTs, Long toTs) throws ApiException {
        return this.getSLOHistoryWithHttpInfo(sloId, fromTs, toTs, new GetSLOHistoryOptionalParameters()).getData();
    }

    public SLOHistoryResponse getSLOHistory(String sloId, Long fromTs, Long toTs, GetSLOHistoryOptionalParameters parameters) throws ApiException {
        return this.getSLOHistoryWithHttpInfo(sloId, fromTs, toTs, parameters).getData();
    }

    public ApiResponse<SLOHistoryResponse> getSLOHistoryWithHttpInfo(String sloId, Long fromTs, Long toTs, GetSLOHistoryOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (sloId == null) {
            throw new ApiException(400, "Missing the required parameter 'sloId' when calling getSLOHistory");
        }
        if (fromTs == null) {
            throw new ApiException(400, "Missing the required parameter 'fromTs' when calling getSLOHistory");
        }
        if (toTs == null) {
            throw new ApiException(400, "Missing the required parameter 'toTs' when calling getSLOHistory");
        }
        Double target = parameters.target;
        String localVarPath = "/api/v1/slo/{slo_id}/history".replaceAll("\\{slo_id\\}", this.apiClient.escapeString(sloId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from_ts", fromTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to_ts", toTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "target", target));
        localVarHeaderParams.put("DD-OPERATION-ID", "getSLOHistory");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SLOHistoryResponse> localVarReturnType = new GenericType<SLOHistoryResponse>(){};
        return this.apiClient.invokeAPI("ServiceLevelObjectivesApi.getSLOHistory", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SLOListResponse listSLOs() throws ApiException {
        return this.listSLOsWithHttpInfo(new ListSLOsOptionalParameters()).getData();
    }

    public SLOListResponse listSLOs(ListSLOsOptionalParameters parameters) throws ApiException {
        return this.listSLOsWithHttpInfo(parameters).getData();
    }

    public ApiResponse<SLOListResponse> listSLOsWithHttpInfo(ListSLOsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String ids = parameters.ids;
        String query = parameters.query;
        String tagsQuery = parameters.tagsQuery;
        String metricsQuery = parameters.metricsQuery;
        String localVarPath = "/api/v1/slo";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ids", ids));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tags_query", tagsQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "metrics_query", metricsQuery));
        localVarHeaderParams.put("DD-OPERATION-ID", "listSLOs");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SLOListResponse> localVarReturnType = new GenericType<SLOListResponse>(){};
        return this.apiClient.invokeAPI("ServiceLevelObjectivesApi.listSLOs", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SLOListResponse updateSLO(String sloId, ServiceLevelObjective body) throws ApiException {
        return this.updateSLOWithHttpInfo(sloId, body).getData();
    }

    public ApiResponse<SLOListResponse> updateSLOWithHttpInfo(String sloId, ServiceLevelObjective body) throws ApiException {
        ServiceLevelObjective localVarPostBody = body;
        if (sloId == null) {
            throw new ApiException(400, "Missing the required parameter 'sloId' when calling updateSLO");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateSLO");
        }
        String localVarPath = "/api/v1/slo/{slo_id}".replaceAll("\\{slo_id\\}", this.apiClient.escapeString(sloId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateSLO");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SLOListResponse> localVarReturnType = new GenericType<SLOListResponse>(){};
        return this.apiClient.invokeAPI("ServiceLevelObjectivesApi.updateSLO", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public static class ListSLOsOptionalParameters {
        private String ids;
        private String query;
        private String tagsQuery;
        private String metricsQuery;

        public ListSLOsOptionalParameters ids(String ids) {
            this.ids = ids;
            return this;
        }

        public ListSLOsOptionalParameters query(String query) {
            this.query = query;
            return this;
        }

        public ListSLOsOptionalParameters tagsQuery(String tagsQuery) {
            this.tagsQuery = tagsQuery;
            return this;
        }

        public ListSLOsOptionalParameters metricsQuery(String metricsQuery) {
            this.metricsQuery = metricsQuery;
            return this;
        }
    }

    public static class GetSLOHistoryOptionalParameters {
        private Double target;

        public GetSLOHistoryOptionalParameters target(Double target) {
            this.target = target;
            return this;
        }
    }

    public static class DeleteSLOOptionalParameters {
        private String force;

        public DeleteSLOOptionalParameters force(String force) {
            this.force = force;
            return this;
        }
    }
}

