/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.Dashboard;
import com.datadog.api.v1.client.model.DashboardDeleteResponse;
import com.datadog.api.v1.client.model.DashboardSummary;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class DashboardsApi {
    private ApiClient apiClient;

    public DashboardsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DashboardsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Dashboard createDashboard(Dashboard body) throws ApiException {
        return this.createDashboardWithHttpInfo(body).getData();
    }

    public ApiResponse<Dashboard> createDashboardWithHttpInfo(Dashboard body) throws ApiException {
        Dashboard localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDashboard");
        }
        String localVarPath = "/api/v1/dashboard";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createDashboard");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Dashboard> localVarReturnType = new GenericType<Dashboard>(){};
        return this.apiClient.invokeAPI("DashboardsApi.createDashboard", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public DashboardDeleteResponse deleteDashboard(String dashboardId) throws ApiException {
        return this.deleteDashboardWithHttpInfo(dashboardId).getData();
    }

    public ApiResponse<DashboardDeleteResponse> deleteDashboardWithHttpInfo(String dashboardId) throws ApiException {
        Object localVarPostBody = null;
        if (dashboardId == null) {
            throw new ApiException(400, "Missing the required parameter 'dashboardId' when calling deleteDashboard");
        }
        String localVarPath = "/api/v1/dashboard/{dashboard_id}".replaceAll("\\{dashboard_id\\}", this.apiClient.escapeString(dashboardId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteDashboard");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<DashboardDeleteResponse> localVarReturnType = new GenericType<DashboardDeleteResponse>(){};
        return this.apiClient.invokeAPI("DashboardsApi.deleteDashboard", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public Dashboard getDashboard(String dashboardId) throws ApiException {
        return this.getDashboardWithHttpInfo(dashboardId).getData();
    }

    public ApiResponse<Dashboard> getDashboardWithHttpInfo(String dashboardId) throws ApiException {
        Object localVarPostBody = null;
        if (dashboardId == null) {
            throw new ApiException(400, "Missing the required parameter 'dashboardId' when calling getDashboard");
        }
        String localVarPath = "/api/v1/dashboard/{dashboard_id}".replaceAll("\\{dashboard_id\\}", this.apiClient.escapeString(dashboardId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getDashboard");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Dashboard> localVarReturnType = new GenericType<Dashboard>(){};
        return this.apiClient.invokeAPI("DashboardsApi.getDashboard", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public DashboardSummary listDashboards() throws ApiException {
        return this.listDashboardsWithHttpInfo().getData();
    }

    public ApiResponse<DashboardSummary> listDashboardsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/dashboard";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listDashboards");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<DashboardSummary> localVarReturnType = new GenericType<DashboardSummary>(){};
        return this.apiClient.invokeAPI("DashboardsApi.listDashboards", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public Dashboard updateDashboard(String dashboardId, Dashboard body) throws ApiException {
        return this.updateDashboardWithHttpInfo(dashboardId, body).getData();
    }

    public ApiResponse<Dashboard> updateDashboardWithHttpInfo(String dashboardId, Dashboard body) throws ApiException {
        Dashboard localVarPostBody = body;
        if (dashboardId == null) {
            throw new ApiException(400, "Missing the required parameter 'dashboardId' when calling updateDashboard");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateDashboard");
        }
        String localVarPath = "/api/v1/dashboard/{dashboard_id}".replaceAll("\\{dashboard_id\\}", this.apiClient.escapeString(dashboardId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateDashboard");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Dashboard> localVarReturnType = new GenericType<Dashboard>(){};
        return this.apiClient.invokeAPI("DashboardsApi.updateDashboard", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }
}

