/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A warning message indicating something that went wrong with the query")
@JsonPropertyOrder(value={"code", "detail", "title"})
public class LogsWarning {
    public static final String JSON_PROPERTY_CODE = "code";
    private String code;
    public static final String JSON_PROPERTY_DETAIL = "detail";
    private String detail;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;

    public LogsWarning code(String code) {
        this.code = code;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="unknown_index", value="A unique code for this type of warning")
    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public LogsWarning detail(String detail) {
        this.detail = detail;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="indexes: foo, bar", value="A detailed explanation of this specific warning")
    @JsonProperty(value="detail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public LogsWarning title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="One or several indexes are missing or invalid, results hold data from the other indexes", value="A short human-readable summary of the warning")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsWarning logsWarning = (LogsWarning)o;
        return Objects.equals(this.code, logsWarning.code) && Objects.equals(this.detail, logsWarning.detail) && Objects.equals(this.title, logsWarning.title);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.detail, this.title);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsWarning {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    detail: ").append(this.toIndentedString(this.detail)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

