/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The incident team's attributes from a response.")
@JsonPropertyOrder(value={"created", "modified", "name"})
public class IncidentTeamResponseAttributes {
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_MODIFIED = "modified";
    private OffsetDateTime modified;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    @Nullable
    @ApiModelProperty(value="Timestamp of when the incident team was created.")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp of when the incident team was modified.")
    @JsonProperty(value="modified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getModified() {
        return this.modified;
    }

    public IncidentTeamResponseAttributes name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="team name", value="Name of the incident team.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentTeamResponseAttributes incidentTeamResponseAttributes = (IncidentTeamResponseAttributes)o;
        return Objects.equals(this.created, incidentTeamResponseAttributes.created) && Objects.equals(this.modified, incidentTeamResponseAttributes.modified) && Objects.equals(this.name, incidentTeamResponseAttributes.name);
    }

    public int hashCode() {
        return Objects.hash(this.created, this.modified, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncidentTeamResponseAttributes {\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

