/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.PermissionsResponse;
import com.datadog.api.v2.client.model.RelationshipToPermission;
import com.datadog.api.v2.client.model.RelationshipToUser;
import com.datadog.api.v2.client.model.RoleCreateRequest;
import com.datadog.api.v2.client.model.RoleCreateResponse;
import com.datadog.api.v2.client.model.RoleResponse;
import com.datadog.api.v2.client.model.RoleUpdateRequest;
import com.datadog.api.v2.client.model.RoleUpdateResponse;
import com.datadog.api.v2.client.model.RolesResponse;
import com.datadog.api.v2.client.model.RolesSort;
import com.datadog.api.v2.client.model.UsersResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class RolesApi {
    private ApiClient apiClient;

    public RolesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RolesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<PermissionsResponse> addPermissionToRoleWithHttpInfo(String roleId, RelationshipToPermission body) throws ApiException {
        RelationshipToPermission localVarPostBody = body;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling addPermissionToRole");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling addPermissionToRole");
        }
        String localVarPath = "/api/v2/roles/{role_id}/permissions".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "addPermissionToRole");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<PermissionsResponse> localVarReturnType = new GenericType<PermissionsResponse>(){};
        return this.apiClient.invokeAPI("RolesApi.addPermissionToRole", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIaddPermissionToRoleRequest addPermissionToRole(String roleId) throws ApiException {
        return new APIaddPermissionToRoleRequest(roleId);
    }

    private ApiResponse<UsersResponse> addUserToRoleWithHttpInfo(String roleId, RelationshipToUser body) throws ApiException {
        RelationshipToUser localVarPostBody = body;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling addUserToRole");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling addUserToRole");
        }
        String localVarPath = "/api/v2/roles/{role_id}/users".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "addUserToRole");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsersResponse> localVarReturnType = new GenericType<UsersResponse>(){};
        return this.apiClient.invokeAPI("RolesApi.addUserToRole", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIaddUserToRoleRequest addUserToRole(String roleId) throws ApiException {
        return new APIaddUserToRoleRequest(roleId);
    }

    private ApiResponse<RoleCreateResponse> createRoleWithHttpInfo(RoleCreateRequest body) throws ApiException {
        RoleCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createRole");
        }
        String localVarPath = "/api/v2/roles";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createRole");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<RoleCreateResponse> localVarReturnType = new GenericType<RoleCreateResponse>(){};
        return this.apiClient.invokeAPI("RolesApi.createRole", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIcreateRoleRequest createRole() throws ApiException {
        return new APIcreateRoleRequest();
    }

    private ApiResponse<Void> deleteRoleWithHttpInfo(String roleId) throws ApiException {
        Object localVarPostBody = null;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling deleteRole");
        }
        String localVarPath = "/api/v2/roles/{role_id}".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteRole");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("RolesApi.deleteRole", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public APIdeleteRoleRequest deleteRole(String roleId) throws ApiException {
        return new APIdeleteRoleRequest(roleId);
    }

    private ApiResponse<RoleResponse> getRoleWithHttpInfo(String roleId) throws ApiException {
        Object localVarPostBody = null;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling getRole");
        }
        String localVarPath = "/api/v2/roles/{role_id}".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getRole");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<RoleResponse> localVarReturnType = new GenericType<RoleResponse>(){};
        return this.apiClient.invokeAPI("RolesApi.getRole", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetRoleRequest getRole(String roleId) throws ApiException {
        return new APIgetRoleRequest(roleId);
    }

    private ApiResponse<PermissionsResponse> listPermissionsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/permissions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listPermissions");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<PermissionsResponse> localVarReturnType = new GenericType<PermissionsResponse>(){};
        return this.apiClient.invokeAPI("RolesApi.listPermissions", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistPermissionsRequest listPermissions() throws ApiException {
        return new APIlistPermissionsRequest();
    }

    private ApiResponse<PermissionsResponse> listRolePermissionsWithHttpInfo(String roleId) throws ApiException {
        Object localVarPostBody = null;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling listRolePermissions");
        }
        String localVarPath = "/api/v2/roles/{role_id}/permissions".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listRolePermissions");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<PermissionsResponse> localVarReturnType = new GenericType<PermissionsResponse>(){};
        return this.apiClient.invokeAPI("RolesApi.listRolePermissions", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistRolePermissionsRequest listRolePermissions(String roleId) throws ApiException {
        return new APIlistRolePermissionsRequest(roleId);
    }

    private ApiResponse<UsersResponse> listRoleUsersWithHttpInfo(String roleId, Long pageSize, Long pageNumber, String sort, String filter) throws ApiException {
        Object localVarPostBody = null;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling listRoleUsers");
        }
        String localVarPath = "/api/v2/roles/{role_id}/users".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarHeaderParams.put("DD-OPERATION-ID", "listRoleUsers");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsersResponse> localVarReturnType = new GenericType<UsersResponse>(){};
        return this.apiClient.invokeAPI("RolesApi.listRoleUsers", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistRoleUsersRequest listRoleUsers(String roleId) throws ApiException {
        return new APIlistRoleUsersRequest(roleId);
    }

    private ApiResponse<RolesResponse> listRolesWithHttpInfo(Long pageSize, Long pageNumber, RolesSort sort, String filter) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/roles";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", (Object)sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarHeaderParams.put("DD-OPERATION-ID", "listRoles");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<RolesResponse> localVarReturnType = new GenericType<RolesResponse>(){};
        return this.apiClient.invokeAPI("RolesApi.listRoles", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistRolesRequest listRoles() throws ApiException {
        return new APIlistRolesRequest();
    }

    private ApiResponse<PermissionsResponse> removePermissionFromRoleWithHttpInfo(String roleId, RelationshipToPermission body) throws ApiException {
        RelationshipToPermission localVarPostBody = body;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling removePermissionFromRole");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling removePermissionFromRole");
        }
        String localVarPath = "/api/v2/roles/{role_id}/permissions".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "removePermissionFromRole");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<PermissionsResponse> localVarReturnType = new GenericType<PermissionsResponse>(){};
        return this.apiClient.invokeAPI("RolesApi.removePermissionFromRole", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIremovePermissionFromRoleRequest removePermissionFromRole(String roleId) throws ApiException {
        return new APIremovePermissionFromRoleRequest(roleId);
    }

    private ApiResponse<UsersResponse> removeUserFromRoleWithHttpInfo(String roleId, RelationshipToUser body) throws ApiException {
        RelationshipToUser localVarPostBody = body;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling removeUserFromRole");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling removeUserFromRole");
        }
        String localVarPath = "/api/v2/roles/{role_id}/users".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "removeUserFromRole");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsersResponse> localVarReturnType = new GenericType<UsersResponse>(){};
        return this.apiClient.invokeAPI("RolesApi.removeUserFromRole", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIremoveUserFromRoleRequest removeUserFromRole(String roleId) throws ApiException {
        return new APIremoveUserFromRoleRequest(roleId);
    }

    private ApiResponse<RoleUpdateResponse> updateRoleWithHttpInfo(String roleId, RoleUpdateRequest body) throws ApiException {
        RoleUpdateRequest localVarPostBody = body;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling updateRole");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateRole");
        }
        String localVarPath = "/api/v2/roles/{role_id}".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateRole");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<RoleUpdateResponse> localVarReturnType = new GenericType<RoleUpdateResponse>(){};
        return this.apiClient.invokeAPI("RolesApi.updateRole", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIupdateRoleRequest updateRole(String roleId) throws ApiException {
        return new APIupdateRoleRequest(roleId);
    }

    public class APIupdateRoleRequest {
        private String roleId;
        private RoleUpdateRequest body;

        private APIupdateRoleRequest(String roleId) {
            this.roleId = roleId;
        }

        public APIupdateRoleRequest body(RoleUpdateRequest body) {
            this.body = body;
            return this;
        }

        public RoleUpdateResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<RoleUpdateResponse> executeWithHttpInfo() throws ApiException {
            return RolesApi.this.updateRoleWithHttpInfo(this.roleId, this.body);
        }
    }

    public class APIremoveUserFromRoleRequest {
        private String roleId;
        private RelationshipToUser body;

        private APIremoveUserFromRoleRequest(String roleId) {
            this.roleId = roleId;
        }

        public APIremoveUserFromRoleRequest body(RelationshipToUser body) {
            this.body = body;
            return this;
        }

        public UsersResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsersResponse> executeWithHttpInfo() throws ApiException {
            return RolesApi.this.removeUserFromRoleWithHttpInfo(this.roleId, this.body);
        }
    }

    public class APIremovePermissionFromRoleRequest {
        private String roleId;
        private RelationshipToPermission body;

        private APIremovePermissionFromRoleRequest(String roleId) {
            this.roleId = roleId;
        }

        public APIremovePermissionFromRoleRequest body(RelationshipToPermission body) {
            this.body = body;
            return this;
        }

        public PermissionsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<PermissionsResponse> executeWithHttpInfo() throws ApiException {
            return RolesApi.this.removePermissionFromRoleWithHttpInfo(this.roleId, this.body);
        }
    }

    public class APIlistRolesRequest {
        private Long pageSize;
        private Long pageNumber;
        private RolesSort sort;
        private String filter;

        private APIlistRolesRequest() {
        }

        public APIlistRolesRequest pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public APIlistRolesRequest pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public APIlistRolesRequest sort(RolesSort sort) {
            this.sort = sort;
            return this;
        }

        public APIlistRolesRequest filter(String filter) {
            this.filter = filter;
            return this;
        }

        public RolesResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<RolesResponse> executeWithHttpInfo() throws ApiException {
            return RolesApi.this.listRolesWithHttpInfo(this.pageSize, this.pageNumber, this.sort, this.filter);
        }
    }

    public class APIlistRoleUsersRequest {
        private String roleId;
        private Long pageSize;
        private Long pageNumber;
        private String sort;
        private String filter;

        private APIlistRoleUsersRequest(String roleId) {
            this.roleId = roleId;
        }

        public APIlistRoleUsersRequest pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public APIlistRoleUsersRequest pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public APIlistRoleUsersRequest sort(String sort) {
            this.sort = sort;
            return this;
        }

        public APIlistRoleUsersRequest filter(String filter) {
            this.filter = filter;
            return this;
        }

        public UsersResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsersResponse> executeWithHttpInfo() throws ApiException {
            return RolesApi.this.listRoleUsersWithHttpInfo(this.roleId, this.pageSize, this.pageNumber, this.sort, this.filter);
        }
    }

    public class APIlistRolePermissionsRequest {
        private String roleId;

        private APIlistRolePermissionsRequest(String roleId) {
            this.roleId = roleId;
        }

        public PermissionsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<PermissionsResponse> executeWithHttpInfo() throws ApiException {
            return RolesApi.this.listRolePermissionsWithHttpInfo(this.roleId);
        }
    }

    public class APIlistPermissionsRequest {
        private APIlistPermissionsRequest() {
        }

        public PermissionsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<PermissionsResponse> executeWithHttpInfo() throws ApiException {
            return RolesApi.this.listPermissionsWithHttpInfo();
        }
    }

    public class APIgetRoleRequest {
        private String roleId;

        private APIgetRoleRequest(String roleId) {
            this.roleId = roleId;
        }

        public RoleResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<RoleResponse> executeWithHttpInfo() throws ApiException {
            return RolesApi.this.getRoleWithHttpInfo(this.roleId);
        }
    }

    public class APIdeleteRoleRequest {
        private String roleId;

        private APIdeleteRoleRequest(String roleId) {
            this.roleId = roleId;
        }

        public void execute() throws ApiException {
            this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return RolesApi.this.deleteRoleWithHttpInfo(this.roleId);
        }
    }

    public class APIcreateRoleRequest {
        private RoleCreateRequest body;

        private APIcreateRoleRequest() {
        }

        public APIcreateRoleRequest body(RoleCreateRequest body) {
            this.body = body;
            return this;
        }

        public RoleCreateResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<RoleCreateResponse> executeWithHttpInfo() throws ApiException {
            return RolesApi.this.createRoleWithHttpInfo(this.body);
        }
    }

    public class APIaddUserToRoleRequest {
        private String roleId;
        private RelationshipToUser body;

        private APIaddUserToRoleRequest(String roleId) {
            this.roleId = roleId;
        }

        public APIaddUserToRoleRequest body(RelationshipToUser body) {
            this.body = body;
            return this;
        }

        public UsersResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsersResponse> executeWithHttpInfo() throws ApiException {
            return RolesApi.this.addUserToRoleWithHttpInfo(this.roleId, this.body);
        }
    }

    public class APIaddPermissionToRoleRequest {
        private String roleId;
        private RelationshipToPermission body;

        private APIaddPermissionToRoleRequest(String roleId) {
            this.roleId = roleId;
        }

        public APIaddPermissionToRoleRequest body(RelationshipToPermission body) {
            this.body = body;
            return this;
        }

        public PermissionsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<PermissionsResponse> executeWithHttpInfo() throws ApiException {
            return RolesApi.this.addPermissionToRoleWithHttpInfo(this.roleId, this.body);
        }
    }
}

