/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.LogsArchive;
import com.datadog.api.v2.client.model.LogsArchiveCreateRequest;
import com.datadog.api.v2.client.model.LogsArchiveOrder;
import com.datadog.api.v2.client.model.LogsArchives;
import com.datadog.api.v2.client.model.RelationshipToRole;
import com.datadog.api.v2.client.model.RolesResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class LogsArchivesApi {
    private ApiClient apiClient;

    public LogsArchivesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LogsArchivesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<Void> addReadRoleToArchiveWithHttpInfo(String archiveId, RelationshipToRole body) throws ApiException {
        RelationshipToRole localVarPostBody = body;
        if (archiveId == null) {
            throw new ApiException(400, "Missing the required parameter 'archiveId' when calling addReadRoleToArchive");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling addReadRoleToArchive");
        }
        String localVarPath = "/api/v2/logs/config/archives/{archive_id}/readers".replaceAll("\\{archive_id\\}", this.apiClient.escapeString(archiveId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "addReadRoleToArchive");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("LogsArchivesApi.addReadRoleToArchive", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public APIaddReadRoleToArchiveRequest addReadRoleToArchive(String archiveId) throws ApiException {
        String operationId = "addReadRoleToArchive";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIaddReadRoleToArchiveRequest(archiveId);
    }

    private ApiResponse<LogsArchive> createLogsArchiveWithHttpInfo(LogsArchiveCreateRequest body) throws ApiException {
        LogsArchiveCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createLogsArchive");
        }
        String localVarPath = "/api/v2/logs/config/archives";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createLogsArchive");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsArchive> localVarReturnType = new GenericType<LogsArchive>(){};
        return this.apiClient.invokeAPI("LogsArchivesApi.createLogsArchive", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIcreateLogsArchiveRequest createLogsArchive() throws ApiException {
        return new APIcreateLogsArchiveRequest();
    }

    private ApiResponse<Void> deleteLogsArchiveWithHttpInfo(String archiveId) throws ApiException {
        Object localVarPostBody = null;
        if (archiveId == null) {
            throw new ApiException(400, "Missing the required parameter 'archiveId' when calling deleteLogsArchive");
        }
        String localVarPath = "/api/v2/logs/config/archives/{archive_id}".replaceAll("\\{archive_id\\}", this.apiClient.escapeString(archiveId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteLogsArchive");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("LogsArchivesApi.deleteLogsArchive", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public APIdeleteLogsArchiveRequest deleteLogsArchive(String archiveId) throws ApiException {
        return new APIdeleteLogsArchiveRequest(archiveId);
    }

    private ApiResponse<LogsArchive> getLogsArchiveWithHttpInfo(String archiveId) throws ApiException {
        Object localVarPostBody = null;
        if (archiveId == null) {
            throw new ApiException(400, "Missing the required parameter 'archiveId' when calling getLogsArchive");
        }
        String localVarPath = "/api/v2/logs/config/archives/{archive_id}".replaceAll("\\{archive_id\\}", this.apiClient.escapeString(archiveId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getLogsArchive");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsArchive> localVarReturnType = new GenericType<LogsArchive>(){};
        return this.apiClient.invokeAPI("LogsArchivesApi.getLogsArchive", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetLogsArchiveRequest getLogsArchive(String archiveId) throws ApiException {
        return new APIgetLogsArchiveRequest(archiveId);
    }

    private ApiResponse<LogsArchiveOrder> getLogsArchiveOrderWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/logs/config/archive-order";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getLogsArchiveOrder");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsArchiveOrder> localVarReturnType = new GenericType<LogsArchiveOrder>(){};
        return this.apiClient.invokeAPI("LogsArchivesApi.getLogsArchiveOrder", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetLogsArchiveOrderRequest getLogsArchiveOrder() throws ApiException {
        return new APIgetLogsArchiveOrderRequest();
    }

    private ApiResponse<RolesResponse> listArchiveReadRolesWithHttpInfo(String archiveId) throws ApiException {
        Object localVarPostBody = null;
        if (archiveId == null) {
            throw new ApiException(400, "Missing the required parameter 'archiveId' when calling listArchiveReadRoles");
        }
        String localVarPath = "/api/v2/logs/config/archives/{archive_id}/readers".replaceAll("\\{archive_id\\}", this.apiClient.escapeString(archiveId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listArchiveReadRoles");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<RolesResponse> localVarReturnType = new GenericType<RolesResponse>(){};
        return this.apiClient.invokeAPI("LogsArchivesApi.listArchiveReadRoles", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistArchiveReadRolesRequest listArchiveReadRoles(String archiveId) throws ApiException {
        String operationId = "listArchiveReadRoles";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIlistArchiveReadRolesRequest(archiveId);
    }

    private ApiResponse<LogsArchives> listLogsArchivesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/logs/config/archives";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listLogsArchives");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsArchives> localVarReturnType = new GenericType<LogsArchives>(){};
        return this.apiClient.invokeAPI("LogsArchivesApi.listLogsArchives", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistLogsArchivesRequest listLogsArchives() throws ApiException {
        return new APIlistLogsArchivesRequest();
    }

    private ApiResponse<Void> removeRoleFromArchiveWithHttpInfo(String archiveId, RelationshipToRole body) throws ApiException {
        RelationshipToRole localVarPostBody = body;
        if (archiveId == null) {
            throw new ApiException(400, "Missing the required parameter 'archiveId' when calling removeRoleFromArchive");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling removeRoleFromArchive");
        }
        String localVarPath = "/api/v2/logs/config/archives/{archive_id}/readers".replaceAll("\\{archive_id\\}", this.apiClient.escapeString(archiveId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "removeRoleFromArchive");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("LogsArchivesApi.removeRoleFromArchive", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public APIremoveRoleFromArchiveRequest removeRoleFromArchive(String archiveId) throws ApiException {
        String operationId = "removeRoleFromArchive";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIremoveRoleFromArchiveRequest(archiveId);
    }

    private ApiResponse<LogsArchive> updateLogsArchiveWithHttpInfo(String archiveId, LogsArchiveCreateRequest body) throws ApiException {
        LogsArchiveCreateRequest localVarPostBody = body;
        if (archiveId == null) {
            throw new ApiException(400, "Missing the required parameter 'archiveId' when calling updateLogsArchive");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateLogsArchive");
        }
        String localVarPath = "/api/v2/logs/config/archives/{archive_id}".replaceAll("\\{archive_id\\}", this.apiClient.escapeString(archiveId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateLogsArchive");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsArchive> localVarReturnType = new GenericType<LogsArchive>(){};
        return this.apiClient.invokeAPI("LogsArchivesApi.updateLogsArchive", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIupdateLogsArchiveRequest updateLogsArchive(String archiveId) throws ApiException {
        return new APIupdateLogsArchiveRequest(archiveId);
    }

    private ApiResponse<LogsArchiveOrder> updateLogsArchiveOrderWithHttpInfo(LogsArchiveOrder body) throws ApiException {
        LogsArchiveOrder localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateLogsArchiveOrder");
        }
        String localVarPath = "/api/v2/logs/config/archive-order";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateLogsArchiveOrder");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsArchiveOrder> localVarReturnType = new GenericType<LogsArchiveOrder>(){};
        return this.apiClient.invokeAPI("LogsArchivesApi.updateLogsArchiveOrder", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIupdateLogsArchiveOrderRequest updateLogsArchiveOrder() throws ApiException {
        return new APIupdateLogsArchiveOrderRequest();
    }

    public class APIupdateLogsArchiveOrderRequest {
        private LogsArchiveOrder body;

        private APIupdateLogsArchiveOrderRequest() {
        }

        public APIupdateLogsArchiveOrderRequest body(LogsArchiveOrder body) {
            this.body = body;
            return this;
        }

        public LogsArchiveOrder execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<LogsArchiveOrder> executeWithHttpInfo() throws ApiException {
            return LogsArchivesApi.this.updateLogsArchiveOrderWithHttpInfo(this.body);
        }
    }

    public class APIupdateLogsArchiveRequest {
        private String archiveId;
        private LogsArchiveCreateRequest body;

        private APIupdateLogsArchiveRequest(String archiveId) {
            this.archiveId = archiveId;
        }

        public APIupdateLogsArchiveRequest body(LogsArchiveCreateRequest body) {
            this.body = body;
            return this;
        }

        public LogsArchive execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<LogsArchive> executeWithHttpInfo() throws ApiException {
            return LogsArchivesApi.this.updateLogsArchiveWithHttpInfo(this.archiveId, this.body);
        }
    }

    public class APIremoveRoleFromArchiveRequest {
        private String archiveId;
        private RelationshipToRole body;

        private APIremoveRoleFromArchiveRequest(String archiveId) {
            this.archiveId = archiveId;
        }

        public APIremoveRoleFromArchiveRequest body(RelationshipToRole body) {
            this.body = body;
            return this;
        }

        public void execute() throws ApiException {
            this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return LogsArchivesApi.this.removeRoleFromArchiveWithHttpInfo(this.archiveId, this.body);
        }
    }

    public class APIlistLogsArchivesRequest {
        private APIlistLogsArchivesRequest() {
        }

        public LogsArchives execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<LogsArchives> executeWithHttpInfo() throws ApiException {
            return LogsArchivesApi.this.listLogsArchivesWithHttpInfo();
        }
    }

    public class APIlistArchiveReadRolesRequest {
        private String archiveId;

        private APIlistArchiveReadRolesRequest(String archiveId) {
            this.archiveId = archiveId;
        }

        public RolesResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<RolesResponse> executeWithHttpInfo() throws ApiException {
            return LogsArchivesApi.this.listArchiveReadRolesWithHttpInfo(this.archiveId);
        }
    }

    public class APIgetLogsArchiveOrderRequest {
        private APIgetLogsArchiveOrderRequest() {
        }

        public LogsArchiveOrder execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<LogsArchiveOrder> executeWithHttpInfo() throws ApiException {
            return LogsArchivesApi.this.getLogsArchiveOrderWithHttpInfo();
        }
    }

    public class APIgetLogsArchiveRequest {
        private String archiveId;

        private APIgetLogsArchiveRequest(String archiveId) {
            this.archiveId = archiveId;
        }

        public LogsArchive execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<LogsArchive> executeWithHttpInfo() throws ApiException {
            return LogsArchivesApi.this.getLogsArchiveWithHttpInfo(this.archiveId);
        }
    }

    public class APIdeleteLogsArchiveRequest {
        private String archiveId;

        private APIdeleteLogsArchiveRequest(String archiveId) {
            this.archiveId = archiveId;
        }

        public void execute() throws ApiException {
            this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return LogsArchivesApi.this.deleteLogsArchiveWithHttpInfo(this.archiveId);
        }
    }

    public class APIcreateLogsArchiveRequest {
        private LogsArchiveCreateRequest body;

        private APIcreateLogsArchiveRequest() {
        }

        public APIcreateLogsArchiveRequest body(LogsArchiveCreateRequest body) {
            this.body = body;
            return this;
        }

        public LogsArchive execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<LogsArchive> executeWithHttpInfo() throws ApiException {
            return LogsArchivesApi.this.createLogsArchiveWithHttpInfo(this.body);
        }
    }

    public class APIaddReadRoleToArchiveRequest {
        private String archiveId;
        private RelationshipToRole body;

        private APIaddReadRoleToArchiveRequest(String archiveId) {
            this.archiveId = archiveId;
        }

        public APIaddReadRoleToArchiveRequest body(RelationshipToRole body) {
            this.body = body;
            return this;
        }

        public void execute() throws ApiException {
            this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return LogsArchivesApi.this.addReadRoleToArchiveWithHttpInfo(this.archiveId, this.body);
        }
    }
}

