/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.APIKeyCreateRequest;
import com.datadog.api.v2.client.model.APIKeyResponse;
import com.datadog.api.v2.client.model.APIKeyUpdateRequest;
import com.datadog.api.v2.client.model.APIKeysResponse;
import com.datadog.api.v2.client.model.APIKeysSort;
import com.datadog.api.v2.client.model.ApplicationKeyCreateRequest;
import com.datadog.api.v2.client.model.ApplicationKeyResponse;
import com.datadog.api.v2.client.model.ApplicationKeyUpdateRequest;
import com.datadog.api.v2.client.model.ApplicationKeysSort;
import com.datadog.api.v2.client.model.ListApplicationKeysResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class KeyManagementApi {
    private ApiClient apiClient;

    public KeyManagementApi() {
        this(Configuration.getDefaultApiClient());
    }

    public KeyManagementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<APIKeyResponse> createAPIKeyWithHttpInfo(APIKeyCreateRequest body) throws ApiException {
        APIKeyCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createAPIKey");
        }
        String localVarPath = "/api/v2/api_keys";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createAPIKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<APIKeyResponse> localVarReturnType = new GenericType<APIKeyResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.createAPIKey", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIcreateAPIKeyRequest createAPIKey() throws ApiException {
        return new APIcreateAPIKeyRequest();
    }

    private ApiResponse<ApplicationKeyResponse> createCurrentUserApplicationKeyWithHttpInfo(ApplicationKeyCreateRequest body) throws ApiException {
        ApplicationKeyCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCurrentUserApplicationKey");
        }
        String localVarPath = "/api/v2/current_user/application_keys";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createCurrentUserApplicationKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ApplicationKeyResponse> localVarReturnType = new GenericType<ApplicationKeyResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.createCurrentUserApplicationKey", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIcreateCurrentUserApplicationKeyRequest createCurrentUserApplicationKey() throws ApiException {
        return new APIcreateCurrentUserApplicationKeyRequest();
    }

    private ApiResponse<Void> deleteAPIKeyWithHttpInfo(String apiKeyId) throws ApiException {
        Object localVarPostBody = null;
        if (apiKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'apiKeyId' when calling deleteAPIKey");
        }
        String localVarPath = "/api/v2/api_keys/{api_key_id}".replaceAll("\\{api_key_id\\}", this.apiClient.escapeString(apiKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteAPIKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("KeyManagementApi.deleteAPIKey", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public APIdeleteAPIKeyRequest deleteAPIKey(String apiKeyId) throws ApiException {
        return new APIdeleteAPIKeyRequest(apiKeyId);
    }

    private ApiResponse<Void> deleteApplicationKeyWithHttpInfo(String appKeyId) throws ApiException {
        Object localVarPostBody = null;
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling deleteApplicationKey");
        }
        String localVarPath = "/api/v2/application_keys/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteApplicationKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("KeyManagementApi.deleteApplicationKey", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public APIdeleteApplicationKeyRequest deleteApplicationKey(String appKeyId) throws ApiException {
        return new APIdeleteApplicationKeyRequest(appKeyId);
    }

    private ApiResponse<Void> deleteCurrentUserApplicationKeyWithHttpInfo(String appKeyId) throws ApiException {
        Object localVarPostBody = null;
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling deleteCurrentUserApplicationKey");
        }
        String localVarPath = "/api/v2/current_user/application_keys/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteCurrentUserApplicationKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("KeyManagementApi.deleteCurrentUserApplicationKey", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public APIdeleteCurrentUserApplicationKeyRequest deleteCurrentUserApplicationKey(String appKeyId) throws ApiException {
        return new APIdeleteCurrentUserApplicationKeyRequest(appKeyId);
    }

    private ApiResponse<APIKeyResponse> getAPIKeyWithHttpInfo(String apiKeyId, String include) throws ApiException {
        Object localVarPostBody = null;
        if (apiKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'apiKeyId' when calling getAPIKey");
        }
        String localVarPath = "/api/v2/api_keys/{api_key_id}".replaceAll("\\{api_key_id\\}", this.apiClient.escapeString(apiKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarHeaderParams.put("DD-OPERATION-ID", "getAPIKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<APIKeyResponse> localVarReturnType = new GenericType<APIKeyResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.getAPIKey", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetAPIKeyRequest getAPIKey(String apiKeyId) throws ApiException {
        return new APIgetAPIKeyRequest(apiKeyId);
    }

    private ApiResponse<ApplicationKeyResponse> getCurrentUserApplicationKeyWithHttpInfo(String appKeyId) throws ApiException {
        Object localVarPostBody = null;
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling getCurrentUserApplicationKey");
        }
        String localVarPath = "/api/v2/current_user/application_keys/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getCurrentUserApplicationKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ApplicationKeyResponse> localVarReturnType = new GenericType<ApplicationKeyResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.getCurrentUserApplicationKey", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetCurrentUserApplicationKeyRequest getCurrentUserApplicationKey(String appKeyId) throws ApiException {
        return new APIgetCurrentUserApplicationKeyRequest(appKeyId);
    }

    private ApiResponse<APIKeysResponse> listAPIKeysWithHttpInfo(Long pageSize, Long pageNumber, APIKeysSort sort, String filter, String filterCreatedAtStart, String filterCreatedAtEnd, String filterModifiedAtStart, String filterModifiedAtEnd, String include) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/api_keys";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", (Object)sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][start]", filterCreatedAtStart));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][end]", filterCreatedAtEnd));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[modified_at][start]", filterModifiedAtStart));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[modified_at][end]", filterModifiedAtEnd));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarHeaderParams.put("DD-OPERATION-ID", "listAPIKeys");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<APIKeysResponse> localVarReturnType = new GenericType<APIKeysResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.listAPIKeys", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistAPIKeysRequest listAPIKeys() throws ApiException {
        return new APIlistAPIKeysRequest();
    }

    private ApiResponse<ListApplicationKeysResponse> listApplicationKeysWithHttpInfo(Long pageSize, Long pageNumber, ApplicationKeysSort sort, String filter, String filterCreatedAtStart, String filterCreatedAtEnd) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/application_keys";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", (Object)sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][start]", filterCreatedAtStart));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][end]", filterCreatedAtEnd));
        localVarHeaderParams.put("DD-OPERATION-ID", "listApplicationKeys");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ListApplicationKeysResponse> localVarReturnType = new GenericType<ListApplicationKeysResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.listApplicationKeys", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistApplicationKeysRequest listApplicationKeys() throws ApiException {
        return new APIlistApplicationKeysRequest();
    }

    private ApiResponse<ListApplicationKeysResponse> listCurrentUserApplicationKeysWithHttpInfo(Long pageSize, Long pageNumber, ApplicationKeysSort sort, String filter, String filterCreatedAtStart, String filterCreatedAtEnd) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/current_user/application_keys";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", (Object)sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][start]", filterCreatedAtStart));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][end]", filterCreatedAtEnd));
        localVarHeaderParams.put("DD-OPERATION-ID", "listCurrentUserApplicationKeys");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ListApplicationKeysResponse> localVarReturnType = new GenericType<ListApplicationKeysResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.listCurrentUserApplicationKeys", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistCurrentUserApplicationKeysRequest listCurrentUserApplicationKeys() throws ApiException {
        return new APIlistCurrentUserApplicationKeysRequest();
    }

    private ApiResponse<APIKeyResponse> updateAPIKeyWithHttpInfo(String apiKeyId, APIKeyUpdateRequest body) throws ApiException {
        APIKeyUpdateRequest localVarPostBody = body;
        if (apiKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'apiKeyId' when calling updateAPIKey");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateAPIKey");
        }
        String localVarPath = "/api/v2/api_keys/{api_key_id}".replaceAll("\\{api_key_id\\}", this.apiClient.escapeString(apiKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateAPIKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<APIKeyResponse> localVarReturnType = new GenericType<APIKeyResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.updateAPIKey", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIupdateAPIKeyRequest updateAPIKey(String apiKeyId) throws ApiException {
        return new APIupdateAPIKeyRequest(apiKeyId);
    }

    private ApiResponse<ApplicationKeyResponse> updateApplicationKeyWithHttpInfo(String appKeyId, ApplicationKeyUpdateRequest body) throws ApiException {
        ApplicationKeyUpdateRequest localVarPostBody = body;
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling updateApplicationKey");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateApplicationKey");
        }
        String localVarPath = "/api/v2/application_keys/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateApplicationKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ApplicationKeyResponse> localVarReturnType = new GenericType<ApplicationKeyResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.updateApplicationKey", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIupdateApplicationKeyRequest updateApplicationKey(String appKeyId) throws ApiException {
        return new APIupdateApplicationKeyRequest(appKeyId);
    }

    private ApiResponse<ApplicationKeyResponse> updateCurrentUserApplicationKeyWithHttpInfo(String appKeyId, ApplicationKeyUpdateRequest body) throws ApiException {
        ApplicationKeyUpdateRequest localVarPostBody = body;
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling updateCurrentUserApplicationKey");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCurrentUserApplicationKey");
        }
        String localVarPath = "/api/v2/current_user/application_keys/{app_key_id}".replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateCurrentUserApplicationKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ApplicationKeyResponse> localVarReturnType = new GenericType<ApplicationKeyResponse>(){};
        return this.apiClient.invokeAPI("KeyManagementApi.updateCurrentUserApplicationKey", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIupdateCurrentUserApplicationKeyRequest updateCurrentUserApplicationKey(String appKeyId) throws ApiException {
        return new APIupdateCurrentUserApplicationKeyRequest(appKeyId);
    }

    public class APIupdateCurrentUserApplicationKeyRequest {
        private String appKeyId;
        private ApplicationKeyUpdateRequest body;

        private APIupdateCurrentUserApplicationKeyRequest(String appKeyId) {
            this.appKeyId = appKeyId;
        }

        public APIupdateCurrentUserApplicationKeyRequest body(ApplicationKeyUpdateRequest body) {
            this.body = body;
            return this;
        }

        public ApplicationKeyResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<ApplicationKeyResponse> executeWithHttpInfo() throws ApiException {
            return KeyManagementApi.this.updateCurrentUserApplicationKeyWithHttpInfo(this.appKeyId, this.body);
        }
    }

    public class APIupdateApplicationKeyRequest {
        private String appKeyId;
        private ApplicationKeyUpdateRequest body;

        private APIupdateApplicationKeyRequest(String appKeyId) {
            this.appKeyId = appKeyId;
        }

        public APIupdateApplicationKeyRequest body(ApplicationKeyUpdateRequest body) {
            this.body = body;
            return this;
        }

        public ApplicationKeyResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<ApplicationKeyResponse> executeWithHttpInfo() throws ApiException {
            return KeyManagementApi.this.updateApplicationKeyWithHttpInfo(this.appKeyId, this.body);
        }
    }

    public class APIupdateAPIKeyRequest {
        private String apiKeyId;
        private APIKeyUpdateRequest body;

        private APIupdateAPIKeyRequest(String apiKeyId) {
            this.apiKeyId = apiKeyId;
        }

        public APIupdateAPIKeyRequest body(APIKeyUpdateRequest body) {
            this.body = body;
            return this;
        }

        public APIKeyResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<APIKeyResponse> executeWithHttpInfo() throws ApiException {
            return KeyManagementApi.this.updateAPIKeyWithHttpInfo(this.apiKeyId, this.body);
        }
    }

    public class APIlistCurrentUserApplicationKeysRequest {
        private Long pageSize;
        private Long pageNumber;
        private ApplicationKeysSort sort;
        private String filter;
        private String filterCreatedAtStart;
        private String filterCreatedAtEnd;

        private APIlistCurrentUserApplicationKeysRequest() {
        }

        public APIlistCurrentUserApplicationKeysRequest pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public APIlistCurrentUserApplicationKeysRequest pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public APIlistCurrentUserApplicationKeysRequest sort(ApplicationKeysSort sort) {
            this.sort = sort;
            return this;
        }

        public APIlistCurrentUserApplicationKeysRequest filter(String filter) {
            this.filter = filter;
            return this;
        }

        public APIlistCurrentUserApplicationKeysRequest filterCreatedAtStart(String filterCreatedAtStart) {
            this.filterCreatedAtStart = filterCreatedAtStart;
            return this;
        }

        public APIlistCurrentUserApplicationKeysRequest filterCreatedAtEnd(String filterCreatedAtEnd) {
            this.filterCreatedAtEnd = filterCreatedAtEnd;
            return this;
        }

        public ListApplicationKeysResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<ListApplicationKeysResponse> executeWithHttpInfo() throws ApiException {
            return KeyManagementApi.this.listCurrentUserApplicationKeysWithHttpInfo(this.pageSize, this.pageNumber, this.sort, this.filter, this.filterCreatedAtStart, this.filterCreatedAtEnd);
        }
    }

    public class APIlistApplicationKeysRequest {
        private Long pageSize;
        private Long pageNumber;
        private ApplicationKeysSort sort;
        private String filter;
        private String filterCreatedAtStart;
        private String filterCreatedAtEnd;

        private APIlistApplicationKeysRequest() {
        }

        public APIlistApplicationKeysRequest pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public APIlistApplicationKeysRequest pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public APIlistApplicationKeysRequest sort(ApplicationKeysSort sort) {
            this.sort = sort;
            return this;
        }

        public APIlistApplicationKeysRequest filter(String filter) {
            this.filter = filter;
            return this;
        }

        public APIlistApplicationKeysRequest filterCreatedAtStart(String filterCreatedAtStart) {
            this.filterCreatedAtStart = filterCreatedAtStart;
            return this;
        }

        public APIlistApplicationKeysRequest filterCreatedAtEnd(String filterCreatedAtEnd) {
            this.filterCreatedAtEnd = filterCreatedAtEnd;
            return this;
        }

        public ListApplicationKeysResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<ListApplicationKeysResponse> executeWithHttpInfo() throws ApiException {
            return KeyManagementApi.this.listApplicationKeysWithHttpInfo(this.pageSize, this.pageNumber, this.sort, this.filter, this.filterCreatedAtStart, this.filterCreatedAtEnd);
        }
    }

    public class APIlistAPIKeysRequest {
        private Long pageSize;
        private Long pageNumber;
        private APIKeysSort sort;
        private String filter;
        private String filterCreatedAtStart;
        private String filterCreatedAtEnd;
        private String filterModifiedAtStart;
        private String filterModifiedAtEnd;
        private String include;

        private APIlistAPIKeysRequest() {
        }

        public APIlistAPIKeysRequest pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public APIlistAPIKeysRequest pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public APIlistAPIKeysRequest sort(APIKeysSort sort) {
            this.sort = sort;
            return this;
        }

        public APIlistAPIKeysRequest filter(String filter) {
            this.filter = filter;
            return this;
        }

        public APIlistAPIKeysRequest filterCreatedAtStart(String filterCreatedAtStart) {
            this.filterCreatedAtStart = filterCreatedAtStart;
            return this;
        }

        public APIlistAPIKeysRequest filterCreatedAtEnd(String filterCreatedAtEnd) {
            this.filterCreatedAtEnd = filterCreatedAtEnd;
            return this;
        }

        public APIlistAPIKeysRequest filterModifiedAtStart(String filterModifiedAtStart) {
            this.filterModifiedAtStart = filterModifiedAtStart;
            return this;
        }

        public APIlistAPIKeysRequest filterModifiedAtEnd(String filterModifiedAtEnd) {
            this.filterModifiedAtEnd = filterModifiedAtEnd;
            return this;
        }

        public APIlistAPIKeysRequest include(String include) {
            this.include = include;
            return this;
        }

        public APIKeysResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<APIKeysResponse> executeWithHttpInfo() throws ApiException {
            return KeyManagementApi.this.listAPIKeysWithHttpInfo(this.pageSize, this.pageNumber, this.sort, this.filter, this.filterCreatedAtStart, this.filterCreatedAtEnd, this.filterModifiedAtStart, this.filterModifiedAtEnd, this.include);
        }
    }

    public class APIgetCurrentUserApplicationKeyRequest {
        private String appKeyId;

        private APIgetCurrentUserApplicationKeyRequest(String appKeyId) {
            this.appKeyId = appKeyId;
        }

        public ApplicationKeyResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<ApplicationKeyResponse> executeWithHttpInfo() throws ApiException {
            return KeyManagementApi.this.getCurrentUserApplicationKeyWithHttpInfo(this.appKeyId);
        }
    }

    public class APIgetAPIKeyRequest {
        private String apiKeyId;
        private String include;

        private APIgetAPIKeyRequest(String apiKeyId) {
            this.apiKeyId = apiKeyId;
        }

        public APIgetAPIKeyRequest include(String include) {
            this.include = include;
            return this;
        }

        public APIKeyResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<APIKeyResponse> executeWithHttpInfo() throws ApiException {
            return KeyManagementApi.this.getAPIKeyWithHttpInfo(this.apiKeyId, this.include);
        }
    }

    public class APIdeleteCurrentUserApplicationKeyRequest {
        private String appKeyId;

        private APIdeleteCurrentUserApplicationKeyRequest(String appKeyId) {
            this.appKeyId = appKeyId;
        }

        public void execute() throws ApiException {
            this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return KeyManagementApi.this.deleteCurrentUserApplicationKeyWithHttpInfo(this.appKeyId);
        }
    }

    public class APIdeleteApplicationKeyRequest {
        private String appKeyId;

        private APIdeleteApplicationKeyRequest(String appKeyId) {
            this.appKeyId = appKeyId;
        }

        public void execute() throws ApiException {
            this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return KeyManagementApi.this.deleteApplicationKeyWithHttpInfo(this.appKeyId);
        }
    }

    public class APIdeleteAPIKeyRequest {
        private String apiKeyId;

        private APIdeleteAPIKeyRequest(String apiKeyId) {
            this.apiKeyId = apiKeyId;
        }

        public void execute() throws ApiException {
            this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return KeyManagementApi.this.deleteAPIKeyWithHttpInfo(this.apiKeyId);
        }
    }

    public class APIcreateCurrentUserApplicationKeyRequest {
        private ApplicationKeyCreateRequest body;

        private APIcreateCurrentUserApplicationKeyRequest() {
        }

        public APIcreateCurrentUserApplicationKeyRequest body(ApplicationKeyCreateRequest body) {
            this.body = body;
            return this;
        }

        public ApplicationKeyResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<ApplicationKeyResponse> executeWithHttpInfo() throws ApiException {
            return KeyManagementApi.this.createCurrentUserApplicationKeyWithHttpInfo(this.body);
        }
    }

    public class APIcreateAPIKeyRequest {
        private APIKeyCreateRequest body;

        private APIcreateAPIKeyRequest() {
        }

        public APIcreateAPIKeyRequest body(APIKeyCreateRequest body) {
            this.body = body;
            return this;
        }

        public APIKeyResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<APIKeyResponse> executeWithHttpInfo() throws ApiException {
            return KeyManagementApi.this.createAPIKeyWithHttpInfo(this.body);
        }
    }
}

