/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.IncidentRelatedObject;
import com.datadog.api.v2.client.model.IncidentTeamCreateRequest;
import com.datadog.api.v2.client.model.IncidentTeamResponse;
import com.datadog.api.v2.client.model.IncidentTeamUpdateRequest;
import com.datadog.api.v2.client.model.IncidentTeamsResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class IncidentTeamsApi {
    private ApiClient apiClient;

    public IncidentTeamsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IncidentTeamsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<IncidentTeamResponse> createIncidentTeamWithHttpInfo(IncidentTeamCreateRequest body) throws ApiException {
        IncidentTeamCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createIncidentTeam");
        }
        String localVarPath = "/api/v2/teams";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createIncidentTeam");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<IncidentTeamResponse> localVarReturnType = new GenericType<IncidentTeamResponse>(){};
        return this.apiClient.invokeAPI("IncidentTeamsApi.createIncidentTeam", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIcreateIncidentTeamRequest createIncidentTeam() throws ApiException {
        String operationId = "createIncidentTeam";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIcreateIncidentTeamRequest();
    }

    private ApiResponse<Void> deleteIncidentTeamWithHttpInfo(String teamId) throws ApiException {
        Object localVarPostBody = null;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling deleteIncidentTeam");
        }
        String localVarPath = "/api/v2/teams/{team_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteIncidentTeam");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("IncidentTeamsApi.deleteIncidentTeam", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public APIdeleteIncidentTeamRequest deleteIncidentTeam(String teamId) throws ApiException {
        String operationId = "deleteIncidentTeam";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIdeleteIncidentTeamRequest(teamId);
    }

    private ApiResponse<IncidentTeamResponse> getIncidentTeamWithHttpInfo(String teamId, IncidentRelatedObject include) throws ApiException {
        Object localVarPostBody = null;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling getIncidentTeam");
        }
        String localVarPath = "/api/v2/teams/{team_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", (Object)include));
        localVarHeaderParams.put("DD-OPERATION-ID", "getIncidentTeam");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<IncidentTeamResponse> localVarReturnType = new GenericType<IncidentTeamResponse>(){};
        return this.apiClient.invokeAPI("IncidentTeamsApi.getIncidentTeam", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetIncidentTeamRequest getIncidentTeam(String teamId) throws ApiException {
        String operationId = "getIncidentTeam";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIgetIncidentTeamRequest(teamId);
    }

    private ApiResponse<IncidentTeamsResponse> listIncidentTeamsWithHttpInfo(IncidentRelatedObject include, Long pageSize, Long pageOffset, String filter) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/teams";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", (Object)include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarHeaderParams.put("DD-OPERATION-ID", "listIncidentTeams");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<IncidentTeamsResponse> localVarReturnType = new GenericType<IncidentTeamsResponse>(){};
        return this.apiClient.invokeAPI("IncidentTeamsApi.listIncidentTeams", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistIncidentTeamsRequest listIncidentTeams() throws ApiException {
        String operationId = "listIncidentTeams";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIlistIncidentTeamsRequest();
    }

    private ApiResponse<IncidentTeamResponse> updateIncidentTeamWithHttpInfo(String teamId, IncidentTeamUpdateRequest body) throws ApiException {
        IncidentTeamUpdateRequest localVarPostBody = body;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling updateIncidentTeam");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateIncidentTeam");
        }
        String localVarPath = "/api/v2/teams/{team_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateIncidentTeam");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<IncidentTeamResponse> localVarReturnType = new GenericType<IncidentTeamResponse>(){};
        return this.apiClient.invokeAPI("IncidentTeamsApi.updateIncidentTeam", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIupdateIncidentTeamRequest updateIncidentTeam(String teamId) throws ApiException {
        String operationId = "updateIncidentTeam";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIupdateIncidentTeamRequest(teamId);
    }

    public class APIupdateIncidentTeamRequest {
        private String teamId;
        private IncidentTeamUpdateRequest body;

        private APIupdateIncidentTeamRequest(String teamId) {
            this.teamId = teamId;
        }

        public APIupdateIncidentTeamRequest body(IncidentTeamUpdateRequest body) {
            this.body = body;
            return this;
        }

        public IncidentTeamResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<IncidentTeamResponse> executeWithHttpInfo() throws ApiException {
            return IncidentTeamsApi.this.updateIncidentTeamWithHttpInfo(this.teamId, this.body);
        }
    }

    public class APIlistIncidentTeamsRequest {
        private IncidentRelatedObject include;
        private Long pageSize;
        private Long pageOffset;
        private String filter;

        private APIlistIncidentTeamsRequest() {
        }

        public APIlistIncidentTeamsRequest include(IncidentRelatedObject include) {
            this.include = include;
            return this;
        }

        public APIlistIncidentTeamsRequest pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public APIlistIncidentTeamsRequest pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }

        public APIlistIncidentTeamsRequest filter(String filter) {
            this.filter = filter;
            return this;
        }

        public IncidentTeamsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<IncidentTeamsResponse> executeWithHttpInfo() throws ApiException {
            return IncidentTeamsApi.this.listIncidentTeamsWithHttpInfo(this.include, this.pageSize, this.pageOffset, this.filter);
        }
    }

    public class APIgetIncidentTeamRequest {
        private String teamId;
        private IncidentRelatedObject include;

        private APIgetIncidentTeamRequest(String teamId) {
            this.teamId = teamId;
        }

        public APIgetIncidentTeamRequest include(IncidentRelatedObject include) {
            this.include = include;
            return this;
        }

        public IncidentTeamResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<IncidentTeamResponse> executeWithHttpInfo() throws ApiException {
            return IncidentTeamsApi.this.getIncidentTeamWithHttpInfo(this.teamId, this.include);
        }
    }

    public class APIdeleteIncidentTeamRequest {
        private String teamId;

        private APIdeleteIncidentTeamRequest(String teamId) {
            this.teamId = teamId;
        }

        public void execute() throws ApiException {
            this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return IncidentTeamsApi.this.deleteIncidentTeamWithHttpInfo(this.teamId);
        }
    }

    public class APIcreateIncidentTeamRequest {
        private IncidentTeamCreateRequest body;

        private APIcreateIncidentTeamRequest() {
        }

        public APIcreateIncidentTeamRequest body(IncidentTeamCreateRequest body) {
            this.body = body;
            return this;
        }

        public IncidentTeamResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<IncidentTeamResponse> executeWithHttpInfo() throws ApiException {
            return IncidentTeamsApi.this.createIncidentTeamWithHttpInfo(this.body);
        }
    }
}

