/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SLOCorrectionCategory;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The attribute object associated with the SLO correction to be created")
@JsonPropertyOrder(value={"category", "description", "end", "slo_id", "start", "timezone"})
public class SLOCorrectionCreateRequestAttributes {
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private SLOCorrectionCategory category;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_END = "end";
    private Long end;
    public static final String JSON_PROPERTY_SLO_ID = "slo_id";
    private String sloId;
    public static final String JSON_PROPERTY_START = "start";
    private Long start;
    public static final String JSON_PROPERTY_TIMEZONE = "timezone";
    private String timezone;

    public SLOCorrectionCreateRequestAttributes category(SLOCorrectionCategory category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SLOCorrectionCategory getCategory() {
        return this.category;
    }

    public void setCategory(SLOCorrectionCategory category) {
        this.category = category;
    }

    public SLOCorrectionCreateRequestAttributes description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Description of the correction being made.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SLOCorrectionCreateRequestAttributes end(Long end) {
        this.end = end;
        return this;
    }

    @ApiModelProperty(example="1600000000", required=true, value="Ending time of the correction in epoch seconds")
    @JsonProperty(value="end")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getEnd() {
        return this.end;
    }

    public void setEnd(Long end) {
        this.end = end;
    }

    public SLOCorrectionCreateRequestAttributes sloId(String sloId) {
        this.sloId = sloId;
        return this;
    }

    @ApiModelProperty(example="sloId", required=true, value="ID of the SLO that this correction will be applied to")
    @JsonProperty(value="slo_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSloId() {
        return this.sloId;
    }

    public void setSloId(String sloId) {
        this.sloId = sloId;
    }

    public SLOCorrectionCreateRequestAttributes start(Long start) {
        this.start = start;
        return this;
    }

    @ApiModelProperty(example="1600000000", required=true, value="Starting time of the correction in epoch seconds")
    @JsonProperty(value="start")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getStart() {
        return this.start;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    public SLOCorrectionCreateRequestAttributes timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="UTC", value="The timezone to display in the UI for the correction times (defaults to \"UTC\")")
    @JsonProperty(value="timezone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOCorrectionCreateRequestAttributes slOCorrectionCreateRequestAttributes = (SLOCorrectionCreateRequestAttributes)o;
        return Objects.equals((Object)this.category, (Object)slOCorrectionCreateRequestAttributes.category) && Objects.equals(this.description, slOCorrectionCreateRequestAttributes.description) && Objects.equals(this.end, slOCorrectionCreateRequestAttributes.end) && Objects.equals(this.sloId, slOCorrectionCreateRequestAttributes.sloId) && Objects.equals(this.start, slOCorrectionCreateRequestAttributes.start) && Objects.equals(this.timezone, slOCorrectionCreateRequestAttributes.timezone);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.category, this.description, this.end, this.sloId, this.start, this.timezone});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOCorrectionCreateRequestAttributes {\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    end: ").append(this.toIndentedString(this.end)).append("\n");
        sb.append("    sloId: ").append(this.toIndentedString(this.sloId)).append("\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

