/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Define computation for a log query.")
@JsonPropertyOrder(value={"aggregation", "facet", "interval"})
public class LogsQueryCompute {
    public static final String JSON_PROPERTY_AGGREGATION = "aggregation";
    private String aggregation;
    public static final String JSON_PROPERTY_FACET = "facet";
    private String facet;
    public static final String JSON_PROPERTY_INTERVAL = "interval";
    private Long interval;

    public LogsQueryCompute aggregation(String aggregation) {
        this.aggregation = aggregation;
        return this;
    }

    @ApiModelProperty(example="avg", required=true, value="The aggregation method.")
    @JsonProperty(value="aggregation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(String aggregation) {
        this.aggregation = aggregation;
    }

    public LogsQueryCompute facet(String facet) {
        this.facet = facet;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="@duration", value="Facet name.")
    @JsonProperty(value="facet")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFacet() {
        return this.facet;
    }

    public void setFacet(String facet) {
        this.facet = facet;
    }

    public LogsQueryCompute interval(Long interval) {
        this.interval = interval;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5000", value="Define a time interval in seconds.")
    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getInterval() {
        return this.interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsQueryCompute logsQueryCompute = (LogsQueryCompute)o;
        return Objects.equals(this.aggregation, logsQueryCompute.aggregation) && Objects.equals(this.facet, logsQueryCompute.facet) && Objects.equals(this.interval, logsQueryCompute.interval);
    }

    public int hashCode() {
        return Objects.hash(this.aggregation, this.facet, this.interval);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsQueryCompute {\n");
        sb.append("    aggregation: ").append(this.toIndentedString(this.aggregation)).append("\n");
        sb.append("    facet: ").append(this.toIndentedString(this.facet)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

