/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.LogsFilter;
import com.datadog.api.v1.client.model.LogsProcessor;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Pipelines and processors operate on incoming logs, parsing and transforming them into structured attributes for easier querying.  **Note**: These endpoints are only available for admin users. Make sure to use an application key created by an admin.")
@JsonPropertyOrder(value={"filter", "id", "is_enabled", "is_read_only", "name", "processors", "type"})
public class LogsPipeline {
    public static final String JSON_PROPERTY_FILTER = "filter";
    private LogsFilter filter;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled;
    public static final String JSON_PROPERTY_IS_READ_ONLY = "is_read_only";
    private Boolean isReadOnly;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PROCESSORS = "processors";
    private List<LogsProcessor> processors = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public LogsPipeline filter(LogsFilter filter) {
        this.filter = filter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsFilter getFilter() {
        return this.filter;
    }

    public void setFilter(LogsFilter filter) {
        this.filter = filter;
    }

    @Nullable
    @ApiModelProperty(value="ID of the pipeline.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public LogsPipeline isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the pipeline is enabled.")
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the pipeline can be edited.")
    @JsonProperty(value="is_read_only")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsReadOnly() {
        return this.isReadOnly;
    }

    public LogsPipeline name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="", required=true, value="Name of the pipeline.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsPipeline processors(List<LogsProcessor> processors) {
        this.processors = processors;
        return this;
    }

    public LogsPipeline addProcessorsItem(LogsProcessor processorsItem) {
        if (this.processors == null) {
            this.processors = new ArrayList<LogsProcessor>();
        }
        this.processors.add(processorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Ordered list of processors in this pipeline.")
    @JsonProperty(value="processors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LogsProcessor> getProcessors() {
        return this.processors;
    }

    public void setProcessors(List<LogsProcessor> processors) {
        this.processors = processors;
    }

    @Nullable
    @ApiModelProperty(example="pipeline", value="Type of pipeline.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsPipeline logsPipeline = (LogsPipeline)o;
        return Objects.equals(this.filter, logsPipeline.filter) && Objects.equals(this.id, logsPipeline.id) && Objects.equals(this.isEnabled, logsPipeline.isEnabled) && Objects.equals(this.isReadOnly, logsPipeline.isReadOnly) && Objects.equals(this.name, logsPipeline.name) && Objects.equals(this.processors, logsPipeline.processors) && Objects.equals(this.type, logsPipeline.type);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.id, this.isEnabled, this.isReadOnly, this.name, this.processors, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsPipeline {\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    isReadOnly: ").append(this.toIndentedString(this.isReadOnly)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    processors: ").append(this.toIndentedString(this.processors)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

