/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.LogsAttributeRemapperType;
import com.datadog.api.v1.client.model.TargetFormatType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The remapper processor remaps any source attribute(s) or tag to another target attribute or tag. Constraints on the tag/attribute name are explained in the [Tag Best Practice documentation](https://docs.datadoghq.com/logs/guide/log-parsing-best-practice). Some additional constraints are applied as `:` or `,` are not allowed in the target tag/attribute name.")
@JsonPropertyOrder(value={"is_enabled", "name", "override_on_conflict", "preserve_source", "source_type", "sources", "target", "target_format", "target_type", "type"})
public class LogsAttributeRemapper {
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OVERRIDE_ON_CONFLICT = "override_on_conflict";
    private Boolean overrideOnConflict = false;
    public static final String JSON_PROPERTY_PRESERVE_SOURCE = "preserve_source";
    private Boolean preserveSource = false;
    public static final String JSON_PROPERTY_SOURCE_TYPE = "source_type";
    private String sourceType = "attribute";
    public static final String JSON_PROPERTY_SOURCES = "sources";
    private List<String> sources = new ArrayList<String>();
    public static final String JSON_PROPERTY_TARGET = "target";
    private String target;
    public static final String JSON_PROPERTY_TARGET_FORMAT = "target_format";
    private TargetFormatType targetFormat;
    public static final String JSON_PROPERTY_TARGET_TYPE = "target_type";
    private String targetType = "attribute";
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogsAttributeRemapperType type = LogsAttributeRemapperType.ATTRIBUTE_REMAPPER;

    public LogsAttributeRemapper isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the processor is enabled.")
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public LogsAttributeRemapper name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the processor.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsAttributeRemapper overrideOnConflict(Boolean overrideOnConflict) {
        this.overrideOnConflict = overrideOnConflict;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Override or not the target element if already set,")
    @JsonProperty(value="override_on_conflict")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getOverrideOnConflict() {
        return this.overrideOnConflict;
    }

    public void setOverrideOnConflict(Boolean overrideOnConflict) {
        this.overrideOnConflict = overrideOnConflict;
    }

    public LogsAttributeRemapper preserveSource(Boolean preserveSource) {
        this.preserveSource = preserveSource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Remove or preserve the remapped source element.")
    @JsonProperty(value="preserve_source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPreserveSource() {
        return this.preserveSource;
    }

    public void setPreserveSource(Boolean preserveSource) {
        this.preserveSource = preserveSource;
    }

    public LogsAttributeRemapper sourceType(String sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Defines if the sources are from log `attribute` or `tag`.")
    @JsonProperty(value="source_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public LogsAttributeRemapper sources(List<String> sources) {
        this.sources = sources;
        return this;
    }

    public LogsAttributeRemapper addSourcesItem(String sourcesItem) {
        this.sources.add(sourcesItem);
        return this;
    }

    @ApiModelProperty(example="[\"web\",\"gateway\"]", required=true, value="Array of source attributes.")
    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getSources() {
        return this.sources;
    }

    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    public LogsAttributeRemapper target(String target) {
        this.target = target;
        return this;
    }

    @ApiModelProperty(example="operation_id", required=true, value="Final attribute or tag name to remap the sources to.")
    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public LogsAttributeRemapper targetFormat(TargetFormatType targetFormat) {
        this.targetFormat = targetFormat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="target_format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TargetFormatType getTargetFormat() {
        return this.targetFormat;
    }

    public void setTargetFormat(TargetFormatType targetFormat) {
        this.targetFormat = targetFormat;
    }

    public LogsAttributeRemapper targetType(String targetType) {
        this.targetType = targetType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Defines if the final attribute or tag name is from log `attribute` or `tag`.")
    @JsonProperty(value="target_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public LogsAttributeRemapper type(LogsAttributeRemapperType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsAttributeRemapperType getType() {
        return this.type;
    }

    public void setType(LogsAttributeRemapperType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsAttributeRemapper logsAttributeRemapper = (LogsAttributeRemapper)o;
        return Objects.equals(this.isEnabled, logsAttributeRemapper.isEnabled) && Objects.equals(this.name, logsAttributeRemapper.name) && Objects.equals(this.overrideOnConflict, logsAttributeRemapper.overrideOnConflict) && Objects.equals(this.preserveSource, logsAttributeRemapper.preserveSource) && Objects.equals(this.sourceType, logsAttributeRemapper.sourceType) && Objects.equals(this.sources, logsAttributeRemapper.sources) && Objects.equals(this.target, logsAttributeRemapper.target) && Objects.equals((Object)this.targetFormat, (Object)logsAttributeRemapper.targetFormat) && Objects.equals(this.targetType, logsAttributeRemapper.targetType) && Objects.equals((Object)this.type, (Object)logsAttributeRemapper.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isEnabled, this.name, this.overrideOnConflict, this.preserveSource, this.sourceType, this.sources, this.target, this.targetFormat, this.targetType, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsAttributeRemapper {\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    overrideOnConflict: ").append(this.toIndentedString(this.overrideOnConflict)).append("\n");
        sb.append("    preserveSource: ").append(this.toIndentedString(this.preserveSource)).append("\n");
        sb.append("    sourceType: ").append(this.toIndentedString(this.sourceType)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    targetFormat: ").append(this.toIndentedString((Object)this.targetFormat)).append("\n");
        sb.append("    targetType: ").append(this.toIndentedString(this.targetType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

