/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.MetricMetadata;
import com.datadog.api.v1.client.model.MetricSearchResponse;
import com.datadog.api.v1.client.model.MetricsListResponse;
import com.datadog.api.v1.client.model.MetricsQueryResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class MetricsApi {
    private ApiClient apiClient;

    public MetricsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MetricsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<MetricMetadata> getMetricMetadataWithHttpInfo(String metricName) throws ApiException {
        Object localVarPostBody = null;
        if (metricName == null) {
            throw new ApiException(400, "Missing the required parameter 'metricName' when calling getMetricMetadata");
        }
        String localVarPath = "/api/v1/metrics/{metric_name}".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getMetricMetadata");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<MetricMetadata> localVarReturnType = new GenericType<MetricMetadata>(){};
        return this.apiClient.invokeAPI("MetricsApi.getMetricMetadata", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetMetricMetadataRequest getMetricMetadata(String metricName) throws ApiException {
        return new APIgetMetricMetadataRequest(metricName);
    }

    private ApiResponse<MetricsListResponse> listActiveMetricsWithHttpInfo(Long from, String host) throws ApiException {
        Object localVarPostBody = null;
        if (from == null) {
            throw new ApiException(400, "Missing the required parameter 'from' when calling listActiveMetrics");
        }
        String localVarPath = "/api/v1/metrics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from", from));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "host", host));
        localVarHeaderParams.put("DD-OPERATION-ID", "listActiveMetrics");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<MetricsListResponse> localVarReturnType = new GenericType<MetricsListResponse>(){};
        return this.apiClient.invokeAPI("MetricsApi.listActiveMetrics", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistActiveMetricsRequest listActiveMetrics() throws ApiException {
        return new APIlistActiveMetricsRequest();
    }

    private ApiResponse<MetricSearchResponse> listMetricsWithHttpInfo(String q) throws ApiException {
        Object localVarPostBody = null;
        if (q == null) {
            throw new ApiException(400, "Missing the required parameter 'q' when calling listMetrics");
        }
        String localVarPath = "/api/v1/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "q", q));
        localVarHeaderParams.put("DD-OPERATION-ID", "listMetrics");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<MetricSearchResponse> localVarReturnType = new GenericType<MetricSearchResponse>(){};
        return this.apiClient.invokeAPI("MetricsApi.listMetrics", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistMetricsRequest listMetrics() throws ApiException {
        return new APIlistMetricsRequest();
    }

    private ApiResponse<MetricsQueryResponse> queryMetricsWithHttpInfo(Long from, Long to, String query) throws ApiException {
        Object localVarPostBody = null;
        if (from == null) {
            throw new ApiException(400, "Missing the required parameter 'from' when calling queryMetrics");
        }
        if (to == null) {
            throw new ApiException(400, "Missing the required parameter 'to' when calling queryMetrics");
        }
        if (query == null) {
            throw new ApiException(400, "Missing the required parameter 'query' when calling queryMetrics");
        }
        String localVarPath = "/api/v1/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from", from));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to", to));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarHeaderParams.put("DD-OPERATION-ID", "queryMetrics");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<MetricsQueryResponse> localVarReturnType = new GenericType<MetricsQueryResponse>(){};
        return this.apiClient.invokeAPI("MetricsApi.queryMetrics", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIqueryMetricsRequest queryMetrics() throws ApiException {
        return new APIqueryMetricsRequest();
    }

    private ApiResponse<MetricMetadata> updateMetricMetadataWithHttpInfo(String metricName, MetricMetadata body) throws ApiException {
        MetricMetadata localVarPostBody = body;
        if (metricName == null) {
            throw new ApiException(400, "Missing the required parameter 'metricName' when calling updateMetricMetadata");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateMetricMetadata");
        }
        String localVarPath = "/api/v1/metrics/{metric_name}".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateMetricMetadata");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<MetricMetadata> localVarReturnType = new GenericType<MetricMetadata>(){};
        return this.apiClient.invokeAPI("MetricsApi.updateMetricMetadata", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIupdateMetricMetadataRequest updateMetricMetadata(String metricName) throws ApiException {
        return new APIupdateMetricMetadataRequest(metricName);
    }

    public class APIupdateMetricMetadataRequest {
        private String metricName;
        private MetricMetadata body;

        private APIupdateMetricMetadataRequest(String metricName) {
            this.metricName = metricName;
        }

        public APIupdateMetricMetadataRequest body(MetricMetadata body) {
            this.body = body;
            return this;
        }

        public MetricMetadata execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<MetricMetadata> executeWithHttpInfo() throws ApiException {
            return MetricsApi.this.updateMetricMetadataWithHttpInfo(this.metricName, this.body);
        }
    }

    public class APIqueryMetricsRequest {
        private Long from;
        private Long to;
        private String query;

        private APIqueryMetricsRequest() {
        }

        public APIqueryMetricsRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIqueryMetricsRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIqueryMetricsRequest query(String query) {
            this.query = query;
            return this;
        }

        public MetricsQueryResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<MetricsQueryResponse> executeWithHttpInfo() throws ApiException {
            return MetricsApi.this.queryMetricsWithHttpInfo(this.from, this.to, this.query);
        }
    }

    public class APIlistMetricsRequest {
        private String q;

        private APIlistMetricsRequest() {
        }

        public APIlistMetricsRequest q(String q) {
            this.q = q;
            return this;
        }

        public MetricSearchResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<MetricSearchResponse> executeWithHttpInfo() throws ApiException {
            return MetricsApi.this.listMetricsWithHttpInfo(this.q);
        }
    }

    public class APIlistActiveMetricsRequest {
        private Long from;
        private String host;

        private APIlistActiveMetricsRequest() {
        }

        public APIlistActiveMetricsRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistActiveMetricsRequest host(String host) {
            this.host = host;
            return this;
        }

        public MetricsListResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<MetricsListResponse> executeWithHttpInfo() throws ApiException {
            return MetricsApi.this.listActiveMetricsWithHttpInfo(this.from, this.host);
        }
    }

    public class APIgetMetricMetadataRequest {
        private String metricName;

        private APIgetMetricMetadataRequest(String metricName) {
            this.metricName = metricName;
        }

        public MetricMetadata execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<MetricMetadata> executeWithHttpInfo() throws ApiException {
            return MetricsApi.this.getMetricMetadataWithHttpInfo(this.metricName);
        }
    }
}

