/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.CancelDowntimesByScopeRequest;
import com.datadog.api.v1.client.model.CanceledDowntimesIds;
import com.datadog.api.v1.client.model.Downtime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class DowntimesApi {
    private ApiClient apiClient;

    public DowntimesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DowntimesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<Void> cancelDowntimeWithHttpInfo(Long downtimeId) throws ApiException {
        Object localVarPostBody = null;
        if (downtimeId == null) {
            throw new ApiException(400, "Missing the required parameter 'downtimeId' when calling cancelDowntime");
        }
        String localVarPath = "/api/v1/downtime/{downtime_id}".replaceAll("\\{downtime_id\\}", this.apiClient.escapeString(downtimeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "cancelDowntime");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("DowntimesApi.cancelDowntime", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public APIcancelDowntimeRequest cancelDowntime(Long downtimeId) throws ApiException {
        return new APIcancelDowntimeRequest(downtimeId);
    }

    private ApiResponse<CanceledDowntimesIds> cancelDowntimesByScopeWithHttpInfo(CancelDowntimesByScopeRequest body) throws ApiException {
        CancelDowntimesByScopeRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling cancelDowntimesByScope");
        }
        String localVarPath = "/api/v1/downtime/cancel/by_scope";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "cancelDowntimesByScope");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<CanceledDowntimesIds> localVarReturnType = new GenericType<CanceledDowntimesIds>(){};
        return this.apiClient.invokeAPI("DowntimesApi.cancelDowntimesByScope", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIcancelDowntimesByScopeRequest cancelDowntimesByScope() throws ApiException {
        return new APIcancelDowntimesByScopeRequest();
    }

    private ApiResponse<Downtime> createDowntimeWithHttpInfo(Downtime body) throws ApiException {
        Downtime localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDowntime");
        }
        String localVarPath = "/api/v1/downtime";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createDowntime");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Downtime> localVarReturnType = new GenericType<Downtime>(){};
        return this.apiClient.invokeAPI("DowntimesApi.createDowntime", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIcreateDowntimeRequest createDowntime() throws ApiException {
        return new APIcreateDowntimeRequest();
    }

    private ApiResponse<Downtime> getDowntimeWithHttpInfo(Long downtimeId) throws ApiException {
        Object localVarPostBody = null;
        if (downtimeId == null) {
            throw new ApiException(400, "Missing the required parameter 'downtimeId' when calling getDowntime");
        }
        String localVarPath = "/api/v1/downtime/{downtime_id}".replaceAll("\\{downtime_id\\}", this.apiClient.escapeString(downtimeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getDowntime");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Downtime> localVarReturnType = new GenericType<Downtime>(){};
        return this.apiClient.invokeAPI("DowntimesApi.getDowntime", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetDowntimeRequest getDowntime(Long downtimeId) throws ApiException {
        return new APIgetDowntimeRequest(downtimeId);
    }

    private ApiResponse<List<Downtime>> listDowntimesWithHttpInfo(Boolean currentOnly) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/downtime";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "current_only", currentOnly));
        localVarHeaderParams.put("DD-OPERATION-ID", "listDowntimes");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<List<Downtime>> localVarReturnType = new GenericType<List<Downtime>>(){};
        return this.apiClient.invokeAPI("DowntimesApi.listDowntimes", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistDowntimesRequest listDowntimes() throws ApiException {
        return new APIlistDowntimesRequest();
    }

    private ApiResponse<Downtime> updateDowntimeWithHttpInfo(Long downtimeId, Downtime body) throws ApiException {
        Downtime localVarPostBody = body;
        if (downtimeId == null) {
            throw new ApiException(400, "Missing the required parameter 'downtimeId' when calling updateDowntime");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateDowntime");
        }
        String localVarPath = "/api/v1/downtime/{downtime_id}".replaceAll("\\{downtime_id\\}", this.apiClient.escapeString(downtimeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateDowntime");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Downtime> localVarReturnType = new GenericType<Downtime>(){};
        return this.apiClient.invokeAPI("DowntimesApi.updateDowntime", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIupdateDowntimeRequest updateDowntime(Long downtimeId) throws ApiException {
        return new APIupdateDowntimeRequest(downtimeId);
    }

    public class APIupdateDowntimeRequest {
        private Long downtimeId;
        private Downtime body;

        private APIupdateDowntimeRequest(Long downtimeId) {
            this.downtimeId = downtimeId;
        }

        public APIupdateDowntimeRequest body(Downtime body) {
            this.body = body;
            return this;
        }

        public Downtime execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Downtime> executeWithHttpInfo() throws ApiException {
            return DowntimesApi.this.updateDowntimeWithHttpInfo(this.downtimeId, this.body);
        }
    }

    public class APIlistDowntimesRequest {
        private Boolean currentOnly;

        private APIlistDowntimesRequest() {
        }

        public APIlistDowntimesRequest currentOnly(Boolean currentOnly) {
            this.currentOnly = currentOnly;
            return this;
        }

        public List<Downtime> execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<List<Downtime>> executeWithHttpInfo() throws ApiException {
            return DowntimesApi.this.listDowntimesWithHttpInfo(this.currentOnly);
        }
    }

    public class APIgetDowntimeRequest {
        private Long downtimeId;

        private APIgetDowntimeRequest(Long downtimeId) {
            this.downtimeId = downtimeId;
        }

        public Downtime execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Downtime> executeWithHttpInfo() throws ApiException {
            return DowntimesApi.this.getDowntimeWithHttpInfo(this.downtimeId);
        }
    }

    public class APIcreateDowntimeRequest {
        private Downtime body;

        private APIcreateDowntimeRequest() {
        }

        public APIcreateDowntimeRequest body(Downtime body) {
            this.body = body;
            return this;
        }

        public Downtime execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Downtime> executeWithHttpInfo() throws ApiException {
            return DowntimesApi.this.createDowntimeWithHttpInfo(this.body);
        }
    }

    public class APIcancelDowntimesByScopeRequest {
        private CancelDowntimesByScopeRequest body;

        private APIcancelDowntimesByScopeRequest() {
        }

        public APIcancelDowntimesByScopeRequest body(CancelDowntimesByScopeRequest body) {
            this.body = body;
            return this;
        }

        public CanceledDowntimesIds execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<CanceledDowntimesIds> executeWithHttpInfo() throws ApiException {
            return DowntimesApi.this.cancelDowntimesByScopeWithHttpInfo(this.body);
        }
    }

    public class APIcancelDowntimeRequest {
        private Long downtimeId;

        private APIcancelDowntimeRequest(Long downtimeId) {
            this.downtimeId = downtimeId;
        }

        public void execute() throws ApiException {
            this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return DowntimesApi.this.cancelDowntimeWithHttpInfo(this.downtimeId);
        }
    }
}

