/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.Log;
import com.datadog.api.v2.client.model.LogsListResponseLinks;
import com.datadog.api.v2.client.model.LogsListResponseMeta;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Response object with all logs matching the request and pagination information.")
@JsonPropertyOrder(value={"data", "links", "meta"})
public class LogsListResponse {
    public static final String JSON_PROPERTY_DATA = "data";
    private List<Log> data = null;
    public static final String JSON_PROPERTY_LINKS = "links";
    private LogsListResponseLinks links;
    public static final String JSON_PROPERTY_META = "meta";
    private LogsListResponseMeta meta;

    public LogsListResponse data(List<Log> data) {
        this.data = data;
        return this;
    }

    public LogsListResponse addDataItem(Log dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<Log>();
        }
        this.data.add(dataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of logs matching the request.")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Log> getData() {
        return this.data;
    }

    public void setData(List<Log> data) {
        this.data = data;
    }

    public LogsListResponse links(LogsListResponseLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsListResponseLinks getLinks() {
        return this.links;
    }

    public void setLinks(LogsListResponseLinks links) {
        this.links = links;
    }

    public LogsListResponse meta(LogsListResponseMeta meta) {
        this.meta = meta;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsListResponseMeta getMeta() {
        return this.meta;
    }

    public void setMeta(LogsListResponseMeta meta) {
        this.meta = meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsListResponse logsListResponse = (LogsListResponse)o;
        return Objects.equals(this.data, logsListResponse.data) && Objects.equals(this.links, logsListResponse.links) && Objects.equals(this.meta, logsListResponse.meta);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.links, this.meta);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsListResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

