/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.JSON;
import com.datadog.api.v2.client.model.AbstractOpenApiSchema;
import com.datadog.api.v2.client.model.LogsArchiveDestinationAzure;
import com.datadog.api.v2.client.model.LogsArchiveDestinationGCS;
import com.datadog.api.v2.client.model.LogsArchiveDestinationS3;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;

@JsonDeserialize(using=LogsArchiveDestinationDeserializer.class)
@JsonSerialize(using=LogsArchiveDestinationSerializer.class)
public class LogsArchiveDestination
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(LogsArchiveDestination.class.getName());
    public static final Map<String, GenericType> schemas = new HashMap<String, GenericType>();

    public LogsArchiveDestination() {
        super("oneOf", Boolean.TRUE);
    }

    public LogsArchiveDestination(LogsArchiveDestinationAzure o) {
        super("oneOf", Boolean.TRUE);
        this.setActualInstance(o);
    }

    public LogsArchiveDestination(LogsArchiveDestinationGCS o) {
        super("oneOf", Boolean.TRUE);
        this.setActualInstance(o);
    }

    public LogsArchiveDestination(LogsArchiveDestinationS3 o) {
        super("oneOf", Boolean.TRUE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, GenericType> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (instance == null) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(LogsArchiveDestinationAzure.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(LogsArchiveDestinationGCS.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(LogsArchiveDestinationS3.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be LogsArchiveDestinationAzure, LogsArchiveDestinationGCS, LogsArchiveDestinationS3");
    }

    static {
        schemas.put("LogsArchiveDestinationAzure", (GenericType)new GenericType<LogsArchiveDestinationAzure>(){});
        schemas.put("LogsArchiveDestinationGCS", (GenericType)new GenericType<LogsArchiveDestinationGCS>(){});
        schemas.put("LogsArchiveDestinationS3", (GenericType)new GenericType<LogsArchiveDestinationS3>(){});
        JSON.registerDescendants(LogsArchiveDestination.class, Collections.unmodifiableMap(schemas));
    }

    public static class LogsArchiveDestinationDeserializer
    extends StdDeserializer<LogsArchiveDestination> {
        public LogsArchiveDestinationDeserializer() {
            this(LogsArchiveDestination.class);
        }

        public LogsArchiveDestinationDeserializer(Class<?> vc) {
            super(vc);
        }

        public LogsArchiveDestination deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            Object deserialized = null;
            int match = 0;
            try {
                deserialized = tree.traverse(jp.getCodec()).readValueAs(LogsArchiveDestinationAzure.class);
                ++match;
                log.log(Level.FINER, "Input data matches schema 'LogsArchiveDestinationAzure'");
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'LogsArchiveDestinationAzure'", e);
            }
            try {
                deserialized = tree.traverse(jp.getCodec()).readValueAs(LogsArchiveDestinationGCS.class);
                ++match;
                log.log(Level.FINER, "Input data matches schema 'LogsArchiveDestinationGCS'");
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'LogsArchiveDestinationGCS'", e);
            }
            try {
                deserialized = tree.traverse(jp.getCodec()).readValueAs(LogsArchiveDestinationS3.class);
                ++match;
                log.log(Level.FINER, "Input data matches schema 'LogsArchiveDestinationS3'");
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'LogsArchiveDestinationS3'", e);
            }
            if (match == 1) {
                LogsArchiveDestination ret = new LogsArchiveDestination();
                ret.setActualInstance(deserialized);
                return ret;
            }
            throw new IOException(String.format("Failed deserialization for LogsArchiveDestination: %d classes match result, expected 1", match));
        }

        public LogsArchiveDestination getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            return null;
        }
    }

    public static class LogsArchiveDestinationSerializer
    extends StdSerializer<LogsArchiveDestination> {
        public LogsArchiveDestinationSerializer(Class<LogsArchiveDestination> t) {
            super(t);
        }

        public LogsArchiveDestinationSerializer() {
            this(null);
        }

        public void serialize(LogsArchiveDestination value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getActualInstance());
        }
    }
}

