/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.LogsListRequest;
import com.datadog.api.v2.client.model.LogsListResponse;
import com.datadog.api.v2.client.model.LogsSort;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class LogsApi {
    private ApiClient apiClient;

    public LogsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LogsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<LogsListResponse> listLogsWithHttpInfo(LogsListRequest body) throws ApiException {
        LogsListRequest localVarPostBody = body;
        String localVarPath = "/api/v2/logs/events/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listLogs");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsListResponse> localVarReturnType = new GenericType<LogsListResponse>(){};
        return this.apiClient.invokeAPI("LogsApi.listLogs", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIlistLogsRequest listLogs() throws ApiException {
        String operationId = "listLogs";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIlistLogsRequest();
    }

    private ApiResponse<LogsListResponse> listLogsGetWithHttpInfo(String filterQuery, String filterIndex, OffsetDateTime filterFrom, OffsetDateTime filterTo, LogsSort sort, String pageCursor, Integer pageLimit) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/logs/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[index]", filterIndex));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", (Object)sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarHeaderParams.put("DD-OPERATION-ID", "listLogsGet");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsListResponse> localVarReturnType = new GenericType<LogsListResponse>(){};
        return this.apiClient.invokeAPI("LogsApi.listLogsGet", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIlistLogsGetRequest listLogsGet() throws ApiException {
        String operationId = "listLogsGet";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIlistLogsGetRequest();
    }

    public class APIlistLogsGetRequest {
        private String filterQuery;
        private String filterIndex;
        private OffsetDateTime filterFrom;
        private OffsetDateTime filterTo;
        private LogsSort sort;
        private String pageCursor;
        private Integer pageLimit;

        private APIlistLogsGetRequest() {
        }

        public APIlistLogsGetRequest filterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
            return this;
        }

        public APIlistLogsGetRequest filterIndex(String filterIndex) {
            this.filterIndex = filterIndex;
            return this;
        }

        public APIlistLogsGetRequest filterFrom(OffsetDateTime filterFrom) {
            this.filterFrom = filterFrom;
            return this;
        }

        public APIlistLogsGetRequest filterTo(OffsetDateTime filterTo) {
            this.filterTo = filterTo;
            return this;
        }

        public APIlistLogsGetRequest sort(LogsSort sort) {
            this.sort = sort;
            return this;
        }

        public APIlistLogsGetRequest pageCursor(String pageCursor) {
            this.pageCursor = pageCursor;
            return this;
        }

        public APIlistLogsGetRequest pageLimit(Integer pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }

        public LogsListResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<LogsListResponse> executeWithHttpInfo() throws ApiException {
            return LogsApi.this.listLogsGetWithHttpInfo(this.filterQuery, this.filterIndex, this.filterFrom, this.filterTo, this.sort, this.pageCursor, this.pageLimit);
        }
    }

    public class APIlistLogsRequest {
        private LogsListRequest body;

        private APIlistLogsRequest() {
        }

        public APIlistLogsRequest body(LogsListRequest body) {
            this.body = body;
            return this;
        }

        public LogsListResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<LogsListResponse> executeWithHttpInfo() throws ApiException {
            return LogsApi.this.listLogsWithHttpInfo(this.body);
        }
    }
}

