/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.DashboardListAddItemsRequest;
import com.datadog.api.v2.client.model.DashboardListAddItemsResponse;
import com.datadog.api.v2.client.model.DashboardListDeleteItemsRequest;
import com.datadog.api.v2.client.model.DashboardListDeleteItemsResponse;
import com.datadog.api.v2.client.model.DashboardListItems;
import com.datadog.api.v2.client.model.DashboardListUpdateItemsRequest;
import com.datadog.api.v2.client.model.DashboardListUpdateItemsResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class DashboardListsApi {
    private ApiClient apiClient;

    public DashboardListsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DashboardListsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<DashboardListAddItemsResponse> createDashboardListItemsWithHttpInfo(Long dashboardListId, DashboardListAddItemsRequest body) throws ApiException {
        DashboardListAddItemsRequest localVarPostBody = body;
        if (dashboardListId == null) {
            throw new ApiException(400, "Missing the required parameter 'dashboardListId' when calling createDashboardListItems");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDashboardListItems");
        }
        String localVarPath = "/api/v2/dashboard/lists/manual/{dashboard_list_id}/dashboards".replaceAll("\\{dashboard_list_id\\}", this.apiClient.escapeString(dashboardListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createDashboardListItems");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<DashboardListAddItemsResponse> localVarReturnType = new GenericType<DashboardListAddItemsResponse>(){};
        return this.apiClient.invokeAPI("DashboardListsApi.createDashboardListItems", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIcreateDashboardListItemsRequest createDashboardListItems(Long dashboardListId) throws ApiException {
        return new APIcreateDashboardListItemsRequest(dashboardListId);
    }

    private ApiResponse<DashboardListDeleteItemsResponse> deleteDashboardListItemsWithHttpInfo(Long dashboardListId, DashboardListDeleteItemsRequest body) throws ApiException {
        DashboardListDeleteItemsRequest localVarPostBody = body;
        if (dashboardListId == null) {
            throw new ApiException(400, "Missing the required parameter 'dashboardListId' when calling deleteDashboardListItems");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteDashboardListItems");
        }
        String localVarPath = "/api/v2/dashboard/lists/manual/{dashboard_list_id}/dashboards".replaceAll("\\{dashboard_list_id\\}", this.apiClient.escapeString(dashboardListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteDashboardListItems");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<DashboardListDeleteItemsResponse> localVarReturnType = new GenericType<DashboardListDeleteItemsResponse>(){};
        return this.apiClient.invokeAPI("DashboardListsApi.deleteDashboardListItems", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIdeleteDashboardListItemsRequest deleteDashboardListItems(Long dashboardListId) throws ApiException {
        return new APIdeleteDashboardListItemsRequest(dashboardListId);
    }

    private ApiResponse<DashboardListItems> getDashboardListItemsWithHttpInfo(Long dashboardListId) throws ApiException {
        Object localVarPostBody = null;
        if (dashboardListId == null) {
            throw new ApiException(400, "Missing the required parameter 'dashboardListId' when calling getDashboardListItems");
        }
        String localVarPath = "/api/v2/dashboard/lists/manual/{dashboard_list_id}/dashboards".replaceAll("\\{dashboard_list_id\\}", this.apiClient.escapeString(dashboardListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getDashboardListItems");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<DashboardListItems> localVarReturnType = new GenericType<DashboardListItems>(){};
        return this.apiClient.invokeAPI("DashboardListsApi.getDashboardListItems", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIgetDashboardListItemsRequest getDashboardListItems(Long dashboardListId) throws ApiException {
        return new APIgetDashboardListItemsRequest(dashboardListId);
    }

    private ApiResponse<DashboardListUpdateItemsResponse> updateDashboardListItemsWithHttpInfo(Long dashboardListId, DashboardListUpdateItemsRequest body) throws ApiException {
        DashboardListUpdateItemsRequest localVarPostBody = body;
        if (dashboardListId == null) {
            throw new ApiException(400, "Missing the required parameter 'dashboardListId' when calling updateDashboardListItems");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateDashboardListItems");
        }
        String localVarPath = "/api/v2/dashboard/lists/manual/{dashboard_list_id}/dashboards".replaceAll("\\{dashboard_list_id\\}", this.apiClient.escapeString(dashboardListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateDashboardListItems");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<DashboardListUpdateItemsResponse> localVarReturnType = new GenericType<DashboardListUpdateItemsResponse>(){};
        return this.apiClient.invokeAPI("DashboardListsApi.updateDashboardListItems", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public APIupdateDashboardListItemsRequest updateDashboardListItems(Long dashboardListId) throws ApiException {
        return new APIupdateDashboardListItemsRequest(dashboardListId);
    }

    public class APIupdateDashboardListItemsRequest {
        private Long dashboardListId;
        private DashboardListUpdateItemsRequest body;

        private APIupdateDashboardListItemsRequest(Long dashboardListId) {
            this.dashboardListId = dashboardListId;
        }

        public APIupdateDashboardListItemsRequest body(DashboardListUpdateItemsRequest body) {
            this.body = body;
            return this;
        }

        public DashboardListUpdateItemsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<DashboardListUpdateItemsResponse> executeWithHttpInfo() throws ApiException {
            return DashboardListsApi.this.updateDashboardListItemsWithHttpInfo(this.dashboardListId, this.body);
        }
    }

    public class APIgetDashboardListItemsRequest {
        private Long dashboardListId;

        private APIgetDashboardListItemsRequest(Long dashboardListId) {
            this.dashboardListId = dashboardListId;
        }

        public DashboardListItems execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<DashboardListItems> executeWithHttpInfo() throws ApiException {
            return DashboardListsApi.this.getDashboardListItemsWithHttpInfo(this.dashboardListId);
        }
    }

    public class APIdeleteDashboardListItemsRequest {
        private Long dashboardListId;
        private DashboardListDeleteItemsRequest body;

        private APIdeleteDashboardListItemsRequest(Long dashboardListId) {
            this.dashboardListId = dashboardListId;
        }

        public APIdeleteDashboardListItemsRequest body(DashboardListDeleteItemsRequest body) {
            this.body = body;
            return this;
        }

        public DashboardListDeleteItemsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<DashboardListDeleteItemsResponse> executeWithHttpInfo() throws ApiException {
            return DashboardListsApi.this.deleteDashboardListItemsWithHttpInfo(this.dashboardListId, this.body);
        }
    }

    public class APIcreateDashboardListItemsRequest {
        private Long dashboardListId;
        private DashboardListAddItemsRequest body;

        private APIcreateDashboardListItemsRequest(Long dashboardListId) {
            this.dashboardListId = dashboardListId;
        }

        public APIcreateDashboardListItemsRequest body(DashboardListAddItemsRequest body) {
            this.body = body;
            return this;
        }

        public DashboardListAddItemsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<DashboardListAddItemsResponse> executeWithHttpInfo() throws ApiException {
            return DashboardListsApi.this.createDashboardListItemsWithHttpInfo(this.dashboardListId, this.body);
        }
    }
}

