/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The hours of trace usage.")
@JsonPropertyOrder(value={"hour", "indexed_events_count"})
public class UsageTraceHour {
    public static final String JSON_PROPERTY_HOUR = "hour";
    private OffsetDateTime hour;
    public static final String JSON_PROPERTY_INDEXED_EVENTS_COUNT = "indexed_events_count";
    private Long indexedEventsCount;

    public UsageTraceHour hour(OffsetDateTime hour) {
        this.hour = hour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hour for the usage.")
    @JsonProperty(value="hour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getHour() {
        return this.hour;
    }

    public void setHour(OffsetDateTime hour) {
        this.hour = hour;
    }

    public UsageTraceHour indexedEventsCount(Long indexedEventsCount) {
        this.indexedEventsCount = indexedEventsCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the number of Analyzed Spans indexed.")
    @JsonProperty(value="indexed_events_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getIndexedEventsCount() {
        return this.indexedEventsCount;
    }

    public void setIndexedEventsCount(Long indexedEventsCount) {
        this.indexedEventsCount = indexedEventsCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageTraceHour usageTraceHour = (UsageTraceHour)o;
        return Objects.equals(this.hour, usageTraceHour.hour) && Objects.equals(this.indexedEventsCount, usageTraceHour.indexedEventsCount);
    }

    public int hashCode() {
        return Objects.hash(this.hour, this.indexedEventsCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageTraceHour {\n");
        sb.append("    hour: ").append(this.toIndentedString(this.hour)).append("\n");
        sb.append("    indexedEventsCount: ").append(this.toIndentedString(this.indexedEventsCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

