/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.TimeseriesWidgetDefinitionType;
import com.datadog.api.v1.client.model.TimeseriesWidgetRequest;
import com.datadog.api.v1.client.model.WidgetAxis;
import com.datadog.api.v1.client.model.WidgetEvent;
import com.datadog.api.v1.client.model.WidgetLegendSize;
import com.datadog.api.v1.client.model.WidgetMarker;
import com.datadog.api.v1.client.model.WidgetTextAlign;
import com.datadog.api.v1.client.model.WidgetTime;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The timeseries visualization allows you to display the evolution of one or more metrics, log events, or Analyzed Spans over time.")
@JsonPropertyOrder(value={"events", "legend_size", "markers", "requests", "show_legend", "time", "title", "title_align", "title_size", "type", "yaxis"})
public class TimeseriesWidgetDefinition {
    public static final String JSON_PROPERTY_EVENTS = "events";
    private List<WidgetEvent> events = null;
    public static final String JSON_PROPERTY_LEGEND_SIZE = "legend_size";
    private WidgetLegendSize legendSize;
    public static final String JSON_PROPERTY_MARKERS = "markers";
    private List<WidgetMarker> markers = null;
    public static final String JSON_PROPERTY_REQUESTS = "requests";
    private List<TimeseriesWidgetRequest> requests = new ArrayList<TimeseriesWidgetRequest>();
    public static final String JSON_PROPERTY_SHOW_LEGEND = "show_legend";
    private Boolean showLegend;
    public static final String JSON_PROPERTY_TIME = "time";
    private WidgetTime time;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
    private WidgetTextAlign titleAlign;
    public static final String JSON_PROPERTY_TITLE_SIZE = "title_size";
    private String titleSize;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TimeseriesWidgetDefinitionType type = TimeseriesWidgetDefinitionType.TIMESERIES;
    public static final String JSON_PROPERTY_YAXIS = "yaxis";
    private WidgetAxis yaxis;

    public TimeseriesWidgetDefinition events(List<WidgetEvent> events) {
        this.events = events;
        return this;
    }

    public TimeseriesWidgetDefinition addEventsItem(WidgetEvent eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<WidgetEvent>();
        }
        this.events.add(eventsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of widget events.")
    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<WidgetEvent> events) {
        this.events = events;
    }

    public TimeseriesWidgetDefinition legendSize(WidgetLegendSize legendSize) {
        this.legendSize = legendSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="legend_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetLegendSize getLegendSize() {
        return this.legendSize;
    }

    public void setLegendSize(WidgetLegendSize legendSize) {
        this.legendSize = legendSize;
    }

    public TimeseriesWidgetDefinition markers(List<WidgetMarker> markers) {
        this.markers = markers;
        return this;
    }

    public TimeseriesWidgetDefinition addMarkersItem(WidgetMarker markersItem) {
        if (this.markers == null) {
            this.markers = new ArrayList<WidgetMarker>();
        }
        this.markers.add(markersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of markers.")
    @JsonProperty(value="markers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetMarker> getMarkers() {
        return this.markers;
    }

    public void setMarkers(List<WidgetMarker> markers) {
        this.markers = markers;
    }

    public TimeseriesWidgetDefinition requests(List<TimeseriesWidgetRequest> requests) {
        this.requests = requests;
        return this;
    }

    public TimeseriesWidgetDefinition addRequestsItem(TimeseriesWidgetRequest requestsItem) {
        this.requests.add(requestsItem);
        return this;
    }

    @ApiModelProperty(example="[{\"q/apm_query/log_query\":\"<METRIC_1>{<SCOPE_1>}\"}]", required=true, value="List of timeseries widget requests.")
    @JsonProperty(value="requests")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<TimeseriesWidgetRequest> getRequests() {
        return this.requests;
    }

    public void setRequests(List<TimeseriesWidgetRequest> requests) {
        this.requests = requests;
    }

    public TimeseriesWidgetDefinition showLegend(Boolean showLegend) {
        this.showLegend = showLegend;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="(screenboard only) Show the legend for this widget.")
    @JsonProperty(value="show_legend")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(Boolean showLegend) {
        this.showLegend = showLegend;
    }

    public TimeseriesWidgetDefinition time(WidgetTime time) {
        this.time = time;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTime getTime() {
        return this.time;
    }

    public void setTime(WidgetTime time) {
        this.time = time;
    }

    public TimeseriesWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Title of your widget.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public TimeseriesWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="title_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
    }

    public TimeseriesWidgetDefinition titleSize(String titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Size of the title.")
    @JsonProperty(value="title_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(String titleSize) {
        this.titleSize = titleSize;
    }

    public TimeseriesWidgetDefinition type(TimeseriesWidgetDefinitionType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TimeseriesWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(TimeseriesWidgetDefinitionType type) {
        this.type = type;
    }

    public TimeseriesWidgetDefinition yaxis(WidgetAxis yaxis) {
        this.yaxis = yaxis;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="yaxis")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetAxis getYaxis() {
        return this.yaxis;
    }

    public void setYaxis(WidgetAxis yaxis) {
        this.yaxis = yaxis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeseriesWidgetDefinition timeseriesWidgetDefinition = (TimeseriesWidgetDefinition)o;
        return Objects.equals(this.events, timeseriesWidgetDefinition.events) && Objects.equals((Object)this.legendSize, (Object)timeseriesWidgetDefinition.legendSize) && Objects.equals(this.markers, timeseriesWidgetDefinition.markers) && Objects.equals(this.requests, timeseriesWidgetDefinition.requests) && Objects.equals(this.showLegend, timeseriesWidgetDefinition.showLegend) && Objects.equals(this.time, timeseriesWidgetDefinition.time) && Objects.equals(this.title, timeseriesWidgetDefinition.title) && Objects.equals((Object)this.titleAlign, (Object)timeseriesWidgetDefinition.titleAlign) && Objects.equals(this.titleSize, timeseriesWidgetDefinition.titleSize) && Objects.equals((Object)this.type, (Object)timeseriesWidgetDefinition.type) && Objects.equals(this.yaxis, timeseriesWidgetDefinition.yaxis);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.events, this.legendSize, this.markers, this.requests, this.showLegend, this.time, this.title, this.titleAlign, this.titleSize, this.type, this.yaxis});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimeseriesWidgetDefinition {\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    legendSize: ").append(this.toIndentedString((Object)this.legendSize)).append("\n");
        sb.append("    markers: ").append(this.toIndentedString(this.markers)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("    showLegend: ").append(this.toIndentedString(this.showLegend)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleAlign: ").append(this.toIndentedString((Object)this.titleAlign)).append("\n");
        sb.append("    titleSize: ").append(this.toIndentedString(this.titleSize)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    yaxis: ").append(this.toIndentedString(this.yaxis)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

