/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SyntheticsAssertionOperator;
import com.datadog.api.v1.client.model.SyntheticsAssertionType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object describing the assertions type, their associated operator, which property they apply , and upon which target.")
@JsonPropertyOrder(value={"operator", "property", "target", "type"})
public class SyntheticsAssertion {
    public static final String JSON_PROPERTY_OPERATOR = "operator";
    private SyntheticsAssertionOperator operator;
    public static final String JSON_PROPERTY_PROPERTY = "property";
    private String property;
    public static final String JSON_PROPERTY_TARGET = "target";
    private Object target;
    public static final String JSON_PROPERTY_TYPE = "type";
    private SyntheticsAssertionType type;

    public SyntheticsAssertion operator(SyntheticsAssertionOperator operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="operator")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SyntheticsAssertionOperator getOperator() {
        return this.operator;
    }

    public void setOperator(SyntheticsAssertionOperator operator) {
        this.operator = operator;
    }

    public SyntheticsAssertion property(String property) {
        this.property = property;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The associated assertion property.")
    @JsonProperty(value="property")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public SyntheticsAssertion target(Object target) {
        this.target = target;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Target to apply the assertion to. It can be a string, a number, or a Date.")
    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public SyntheticsAssertion type(SyntheticsAssertionType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SyntheticsAssertionType getType() {
        return this.type;
    }

    public void setType(SyntheticsAssertionType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsAssertion syntheticsAssertion = (SyntheticsAssertion)o;
        return Objects.equals((Object)this.operator, (Object)syntheticsAssertion.operator) && Objects.equals(this.property, syntheticsAssertion.property) && Objects.equals(this.target, syntheticsAssertion.target) && Objects.equals((Object)this.type, (Object)syntheticsAssertion.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.property, this.target, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsAssertion {\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    property: ").append(this.toIndentedString(this.property)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

