/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.NoteWidgetDefinitionType;
import com.datadog.api.v1.client.model.WidgetTextAlign;
import com.datadog.api.v1.client.model.WidgetTickEdge;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The notes and links widget is similar to free text widget, but allows for more formatting options.")
@JsonPropertyOrder(value={"background_color", "content", "font_size", "show_tick", "text_align", "tick_edge", "tick_pos", "type"})
public class NoteWidgetDefinition {
    public static final String JSON_PROPERTY_BACKGROUND_COLOR = "background_color";
    private String backgroundColor;
    public static final String JSON_PROPERTY_CONTENT = "content";
    private String content;
    public static final String JSON_PROPERTY_FONT_SIZE = "font_size";
    private String fontSize;
    public static final String JSON_PROPERTY_SHOW_TICK = "show_tick";
    private Boolean showTick;
    public static final String JSON_PROPERTY_TEXT_ALIGN = "text_align";
    private WidgetTextAlign textAlign;
    public static final String JSON_PROPERTY_TICK_EDGE = "tick_edge";
    private WidgetTickEdge tickEdge;
    public static final String JSON_PROPERTY_TICK_POS = "tick_pos";
    private String tickPos;
    public static final String JSON_PROPERTY_TYPE = "type";
    private NoteWidgetDefinitionType type = NoteWidgetDefinitionType.NOTE;

    public NoteWidgetDefinition backgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Background color of the note.")
    @JsonProperty(value="background_color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public NoteWidgetDefinition content(String content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(required=true, value="Content of the note.")
    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public NoteWidgetDefinition fontSize(String fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Size of the text.")
    @JsonProperty(value="font_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    public NoteWidgetDefinition showTick(Boolean showTick) {
        this.showTick = showTick;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether to show a tick or not.")
    @JsonProperty(value="show_tick")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowTick() {
        return this.showTick;
    }

    public void setShowTick(Boolean showTick) {
        this.showTick = showTick;
    }

    public NoteWidgetDefinition textAlign(WidgetTextAlign textAlign) {
        this.textAlign = textAlign;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="text_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(WidgetTextAlign textAlign) {
        this.textAlign = textAlign;
    }

    public NoteWidgetDefinition tickEdge(WidgetTickEdge tickEdge) {
        this.tickEdge = tickEdge;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="tick_edge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTickEdge getTickEdge() {
        return this.tickEdge;
    }

    public void setTickEdge(WidgetTickEdge tickEdge) {
        this.tickEdge = tickEdge;
    }

    public NoteWidgetDefinition tickPos(String tickPos) {
        this.tickPos = tickPos;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Where to position the tick on an edge.")
    @JsonProperty(value="tick_pos")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTickPos() {
        return this.tickPos;
    }

    public void setTickPos(String tickPos) {
        this.tickPos = tickPos;
    }

    public NoteWidgetDefinition type(NoteWidgetDefinitionType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public NoteWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(NoteWidgetDefinitionType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NoteWidgetDefinition noteWidgetDefinition = (NoteWidgetDefinition)o;
        return Objects.equals(this.backgroundColor, noteWidgetDefinition.backgroundColor) && Objects.equals(this.content, noteWidgetDefinition.content) && Objects.equals(this.fontSize, noteWidgetDefinition.fontSize) && Objects.equals(this.showTick, noteWidgetDefinition.showTick) && Objects.equals((Object)this.textAlign, (Object)noteWidgetDefinition.textAlign) && Objects.equals((Object)this.tickEdge, (Object)noteWidgetDefinition.tickEdge) && Objects.equals(this.tickPos, noteWidgetDefinition.tickPos) && Objects.equals((Object)this.type, (Object)noteWidgetDefinition.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.backgroundColor, this.content, this.fontSize, this.showTick, this.textAlign, this.tickEdge, this.tickPos, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NoteWidgetDefinition {\n");
        sb.append("    backgroundColor: ").append(this.toIndentedString(this.backgroundColor)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    fontSize: ").append(this.toIndentedString(this.fontSize)).append("\n");
        sb.append("    showTick: ").append(this.toIndentedString(this.showTick)).append("\n");
        sb.append("    textAlign: ").append(this.toIndentedString((Object)this.textAlign)).append("\n");
        sb.append("    tickEdge: ").append(this.toIndentedString((Object)this.tickEdge)).append("\n");
        sb.append("    tickPos: ").append(this.toIndentedString(this.tickPos)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

