/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.Creator;
import com.datadog.api.v1.client.model.MonitorOptions;
import com.datadog.api.v1.client.model.MonitorOverallStates;
import com.datadog.api.v1.client.model.MonitorState;
import com.datadog.api.v1.client.model.MonitorType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Object describing a monitor update request.")
@JsonPropertyOrder(value={"created", "creator", "deleted", "id", "message", "modified", "multi", "name", "options", "overall_state", "query", "state", "tags", "type"})
public class MonitorUpdateRequest {
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_CREATOR = "creator";
    private Creator creator;
    public static final String JSON_PROPERTY_DELETED = "deleted";
    private JsonNullable<OffsetDateTime> deleted = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ID = "id";
    private Long id;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_MODIFIED = "modified";
    private OffsetDateTime modified;
    public static final String JSON_PROPERTY_MULTI = "multi";
    private Boolean multi;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private MonitorOptions options;
    public static final String JSON_PROPERTY_OVERALL_STATE = "overall_state";
    private MonitorOverallStates overallState;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    public static final String JSON_PROPERTY_STATE = "state";
    private MonitorState state;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private MonitorType type;

    @Nullable
    @ApiModelProperty(value="Timestamp of the monitor creation.")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public MonitorUpdateRequest creator(Creator creator) {
        this.creator = creator;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Creator getCreator() {
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the monitor is deleted. (Always `null`)")
    @JsonIgnore
    public OffsetDateTime getDeleted() {
        if (this.deleted == null) {
            this.deleted = JsonNullable.undefined();
        }
        return (OffsetDateTime)this.deleted.orElse(null);
    }

    @JsonProperty(value="deleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getDeleted_JsonNullable() {
        return this.deleted;
    }

    @JsonProperty(value="deleted")
    private void setDeleted_JsonNullable(JsonNullable<OffsetDateTime> deleted) {
        this.deleted = deleted;
    }

    @Nullable
    @ApiModelProperty(value="ID of this monitor.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getId() {
        return this.id;
    }

    public MonitorUpdateRequest message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A message to include with notifications for this monitor.")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Nullable
    @ApiModelProperty(value="Last timestamp when the monitor was edited.")
    @JsonProperty(value="modified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getModified() {
        return this.modified;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the monitor is broken down on different groups.")
    @JsonProperty(value="multi")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMulti() {
        return this.multi;
    }

    public MonitorUpdateRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The monitor name.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MonitorUpdateRequest options(MonitorOptions options) {
        this.options = options;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MonitorOptions getOptions() {
        return this.options;
    }

    public void setOptions(MonitorOptions options) {
        this.options = options;
    }

    public MonitorUpdateRequest overallState(MonitorOverallStates overallState) {
        this.overallState = overallState;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="overall_state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MonitorOverallStates getOverallState() {
        return this.overallState;
    }

    public void setOverallState(MonitorOverallStates overallState) {
        this.overallState = overallState;
    }

    public MonitorUpdateRequest query(String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The monitor query.")
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public MonitorUpdateRequest state(MonitorState state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MonitorState getState() {
        return this.state;
    }

    public void setState(MonitorState state) {
        this.state = state;
    }

    public MonitorUpdateRequest tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public MonitorUpdateRequest addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Tags associated to your monitor.")
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public MonitorUpdateRequest type(MonitorType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MonitorType getType() {
        return this.type;
    }

    public void setType(MonitorType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonitorUpdateRequest monitorUpdateRequest = (MonitorUpdateRequest)o;
        return Objects.equals(this.created, monitorUpdateRequest.created) && Objects.equals(this.creator, monitorUpdateRequest.creator) && Objects.equals(this.deleted, monitorUpdateRequest.deleted) && Objects.equals(this.id, monitorUpdateRequest.id) && Objects.equals(this.message, monitorUpdateRequest.message) && Objects.equals(this.modified, monitorUpdateRequest.modified) && Objects.equals(this.multi, monitorUpdateRequest.multi) && Objects.equals(this.name, monitorUpdateRequest.name) && Objects.equals(this.options, monitorUpdateRequest.options) && Objects.equals((Object)this.overallState, (Object)monitorUpdateRequest.overallState) && Objects.equals(this.query, monitorUpdateRequest.query) && Objects.equals(this.state, monitorUpdateRequest.state) && Objects.equals(this.tags, monitorUpdateRequest.tags) && Objects.equals((Object)this.type, (Object)monitorUpdateRequest.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.created, this.creator, this.deleted, this.id, this.message, this.modified, this.multi, this.name, this.options, this.overallState, this.query, this.state, this.tags, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MonitorUpdateRequest {\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    multi: ").append(this.toIndentedString(this.multi)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    overallState: ").append(this.toIndentedString((Object)this.overallState)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

