/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.LogsStatusRemapperType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Use this Processor if you want to assign some attributes as the official status.  Each incoming status value is mapped as follows.    - Integers from 0 to 7 map to the Syslog severity standards   - Strings beginning with `emerg` or f (case-insensitive) map to `emerg` (0)   - Strings beginning with `a` (case-insensitive) map to `alert` (1)   - Strings beginning with `c` (case-insensitive) map to `critical` (2)   - Strings beginning with `err` (case-insensitive) map to `error` (3)   - Strings beginning with `w` (case-insensitive) map to `warning` (4)   - Strings beginning with `n` (case-insensitive) map to `notice` (5)   - Strings beginning with `i` (case-insensitive) map to `info` (6)   - Strings beginning with `d`, `trace` or `verbose` (case-insensitive) map to `debug` (7)   - Strings beginning with `o` or matching `OK` or `Success` (case-insensitive) map to OK   - All others map to `info` (6)    **Note:** If multiple log status remapper processors can be applied to a given log,   only the first one (according to the pipelines order) is taken into account.")
@JsonPropertyOrder(value={"is_enabled", "name", "sources", "type"})
public class LogsStatusRemapper {
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SOURCES = "sources";
    private List<String> sources = new ArrayList<String>();
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogsStatusRemapperType type = LogsStatusRemapperType.STATUS_REMAPPER;

    public LogsStatusRemapper isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the processor is enabled.")
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public LogsStatusRemapper name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the processor.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsStatusRemapper sources(List<String> sources) {
        this.sources = sources;
        return this;
    }

    public LogsStatusRemapper addSourcesItem(String sourcesItem) {
        this.sources.add(sourcesItem);
        return this;
    }

    @ApiModelProperty(example="[]", required=true, value="Array of source attributes.")
    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getSources() {
        return this.sources;
    }

    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    public LogsStatusRemapper type(LogsStatusRemapperType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsStatusRemapperType getType() {
        return this.type;
    }

    public void setType(LogsStatusRemapperType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsStatusRemapper logsStatusRemapper = (LogsStatusRemapper)o;
        return Objects.equals(this.isEnabled, logsStatusRemapper.isEnabled) && Objects.equals(this.name, logsStatusRemapper.name) && Objects.equals(this.sources, logsStatusRemapper.sources) && Objects.equals((Object)this.type, (Object)logsStatusRemapper.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isEnabled, this.name, this.sources, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsStatusRemapper {\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

